/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.impl.execexp;

import com.scenari.src.ISrcNode;
import com.scenari.src.feature.search.SrcFeatureSearch;
import com.scenari.src.helpers.util.SrcNodeFrontEnd;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.All;
import com.scenari.src.search.exp.RootFolder;
import com.scenari.src.search.func.ImmutableFunc;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.src.search.helpers.util.ResultRowSrcContent;
import com.scenari.src.search.helpers.util.ResultRowSrcNode;
import eu.scenari.fw.util.collections.IteratorBufferedNextBase;
import eu.scenari.fw.util.collections.ListFilterBase;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import eu.scenari.fw.util.lang.TunneledException;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootFolderExecExp
extends ExecutableExpBase {
    protected ISearchFunction fRootPath = ImmutableFunc.EMPTYSTRING;

    public RootFolderExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    public RootFolderExecExp init(RootFolder pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) throws Exception {
        this.fRootPath = pExp.getStartPath();
        return this;
    }

    public RootFolderExecExp init(All pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) throws Exception {
        this.fRootPath = ImmutableFunc.EMPTYSTRING;
        return this;
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pUris, ISearchContext.ISearchContextInternal pContext) throws Exception {
        String vUri = this.fRootPath.evaluate(pContext).toString();
        if (vUri.length() == 0) {
            return pUris;
        }
        return new RootFolderFilterIt(pUris, vUri, this.matchValue()).setPredicateAsSelf();
    }

    @Override
    public boolean isSearchable() throws Exception {
        return true;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> search(ISearchContext.ISearchContextInternal pContext) throws Exception {
        String vUri = this.fRootPath.evaluate(pContext).toString();
        return new RootFolderIt(pContext, vUri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RootFolderIt
    extends IteratorBufferedNextBase<ISearchResultRow.ISearchResultRowInternal> {
        protected ISearchContext.ISearchContextInternal fContext;
        protected TreeMap<ISearchResultRow.ISearchResultRowInternal, ISearchResultRow.ISearchResultRowInternal> fMap = new TreeMap(ISearchResultRow.COMPARATOR_RESULTROW);
        protected FakeList fFakeList = new FakeList();

        public RootFolderIt(ISearchContext.ISearchContextInternal pContext, String pRootUri) throws Exception {
            this.fContext = pContext;
            ISrcNode vRoot = this.fContext.getSrcFrom().getAspect(ISrcNode.TYPE);
            vRoot = vRoot == null ? new SrcNodeFrontEnd(this.fContext.getSrcFrom(), pRootUri) : vRoot.findNodeByUri(pRootUri);
            this.fFakeList.add(vRoot);
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.fNext != null) {
                    return true;
                }
                if (this.fMap.isEmpty()) {
                    return false;
                }
                this.fNext = this.fMap.firstKey();
                this.fMap.remove(this.fNext);
                ISrcNode vNode = (ISrcNode)((ResultRowSrcContent)this.fNext).getSrcContent();
                if (Boolean.TRUE != vNode.getAspect(SrcFeatureSearch.SKIP_SCANNING_FOLDER_ASPECTTYPE)) {
                    vNode.listChildrenNodes(this.fFakeList);
                }
                return true;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TunneledException(e);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class FakeList
        extends ListFilterBase<ISrcNode> {
            protected FakeList() {
            }

            @Override
            public boolean add(ISrcNode pSrc) {
                ResultRowSrcNode vRes = new ResultRowSrcNode(pSrc, RootFolderIt.this.fContext);
                RootFolderIt.this.fMap.put(vRes, vRes);
                return true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RootFolderFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected String fUriPrefix;
        protected boolean fResultAttempted;

        public RootFolderFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, String pUriPrefix, boolean pResultAttempted) {
            super(pFrom);
            this.fUriPrefix = pUriPrefix;
            this.fResultAttempted = pResultAttempted;
        }

        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            String vUri = pEntry.getRowUri();
            if (vUri == null) {
                return false;
            }
            int vPrefixLen = this.fUriPrefix.length();
            return (vUri.length() > vPrefixLen && vUri.charAt(vPrefixLen) == '/' && vUri.startsWith(this.fUriPrefix)) == this.fResultAttempted;
        }
    }
}

