/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.system;

import com.scenari.src.ISrcNode;
import com.scenari.src.fs.basic.FsBasicSystemLoader;
import com.scenari.src.fs.basic.OldFsSystemLoader;
import com.scenari.src.system.ISrcSystemLoader;
import com.scenari.src.system.SrcSystemLoaderBase;
import eu.scenari.fw.log.LogMgr;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class SrcSystemFactory {
    public static final SrcSystemFactory DEFAULT = new SrcSystemFactory(null);
    protected Map<String, Class> fSrcSystemClassLoaderMap = new HashMap<String, Class>();
    protected SrcSystemFactory fParentChain = null;

    public SrcSystemFactory(SrcSystemFactory pParentChain) {
        this.fParentChain = pParentChain;
    }

    public static ISrcSystemLoader getInstanceLoader(String pType) throws Exception {
        return DEFAULT.newInstanceLoader(pType);
    }

    public static ISrcSystemLoader newGenericSourceSystemLoader(Object pOwner, ISrcNode pSrcNode) {
        return new GenericSystemSourceSaxHandler(pOwner, pSrcNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSrcSystemLoader(String pType, Class pClassLoader) {
        Map<String, Class> map = this.fSrcSystemClassLoaderMap;
        synchronized (map) {
            this.fSrcSystemClassLoaderMap.put(pType, pClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISrcSystemLoader newInstanceLoader(String pType) throws Exception {
        ISrcSystemLoader vResult = null;
        Class<?> vClass = null;
        Map<String, Class> map = this.fSrcSystemClassLoaderMap;
        synchronized (map) {
            vClass = this.fSrcSystemClassLoaderMap.get(pType);
        }
        if (vClass == null) {
            if (this.fParentChain != null && (vResult = this.fParentChain.newInstanceLoader(pType)) != null) {
                return vResult;
            }
            try {
                vClass = Class.forName(pType);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (vClass == null) {
            throw LogMgr.newException("SrcSystem '" + pType + "' is unknown.", new String[0]);
        }
        vResult = (ISrcSystemLoader)vClass.newInstance();
        return vResult;
    }

    static {
        DEFAULT.addSrcSystemLoader("file", FsBasicSystemLoader.class);
        DEFAULT.addSrcSystemLoader("file system", OldFsSystemLoader.class);
    }

    public static class GenericSystemSourceSaxHandler
    extends SrcSystemLoaderBase {
        protected SrcSystemFactory fFactory;

        public GenericSystemSourceSaxHandler(Object pOwner, ISrcNode pCurrentDocSource) {
            this.setOwner(pOwner);
            this.fCurrentDocSource = pCurrentDocSource;
            this.fFactory = DEFAULT;
        }

        public GenericSystemSourceSaxHandler(Object pOwner, ISrcNode pCurrentDocSource, SrcSystemFactory pSrcSystemFactory) {
            this.setOwner(pOwner);
            this.fCurrentDocSource = pCurrentDocSource;
            this.fFactory = pSrcSystemFactory;
        }

        protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
            String vName;
            String string = vName = pQName != null ? pQName : pLocalName;
            if (vName == "source") {
                ISrcSystemLoader vLoader = this.fFactory.newInstanceLoader(pAttributes.getValue("type"));
                if (vLoader != null) {
                    vLoader.setSourceDefinition(this.fCurrentDocSource);
                    vLoader.setOwner(this.fOwner);
                    vLoader.initSaxHandlerForElement(this.getXMLReader(), pUri, pLocalName, pQName, pAttributes);
                    this.fCurrentSystem = vLoader.getSrcSystem();
                }
                return true;
            }
            return false;
        }
    }
}

