/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.zip;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.refresh.IRefreshAspect;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.feature.transform.SrcFeatureTransform;
import com.scenari.src.helpers.base.SrcContentFileBase;
import com.scenari.src.helpers.base.SrcContentFolderBase;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.IByteStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class UnzipTransformSrcServer
implements ISrcServer,
IRefreshAspect {
    protected static final long NOT_LOADED = -99L;
    protected String fTransformKey = "zip";
    protected ISrcNode fZipSrcNode;
    protected XSourceFolder fSrcRoot = null;
    protected long fLastUpdate = -99L;

    public UnzipTransformSrcServer() {
        this(null);
    }

    public UnzipTransformSrcServer(ISrcNode pSrcToUnzip) {
        this.fZipSrcNode = pSrcToUnzip;
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IRefreshAspect.TYPE) {
            return this;
        }
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureRefresh.REFIND_SRCCONTENT_FOR_REFRESH) {
            return Boolean.TRUE;
        }
        return null;
    }

    public ISrcContent findContentByUri(String pUri) throws Exception {
        if (this.fLastUpdate == -99L) {
            this.loadTree(this.fZipSrcNode.getLastModifWithChildren());
        }
        if (this.fSrcRoot != null) {
            if (pUri.length() == 0) {
                return this.fSrcRoot;
            }
            return this.fSrcRoot.findUri(pUri, 1, false);
        }
        return ISrcContent.NULL;
    }

    public boolean refresh() throws Exception {
        if (!SrcFeatureRefresh.refresh(this.fZipSrcNode)) {
            return false;
        }
        long vNewLastModif = this.fZipSrcNode.getLastModifWithChildren();
        if (this.fLastUpdate == vNewLastModif) {
            return true;
        }
        this.loadTree(vNewLastModif);
        return true;
    }

    protected void loadTree(long pNewLastModef) throws Exception {
        this.fSrcRoot = this.fZipSrcNode.getContentStatus() == 1 ? new XSourceFolder(null).initRoot() : null;
        this.fLastUpdate = pNewLastModef;
    }

    public class XZipMapParser
    extends DefaultHandler {
        public static final String TAG_ENTRY = "entry";
        public static final String TAG_ENTRY_ATT_NAME = "name";
        public static final String TAG_ENTRY_ATT_SIZE = "size";
        protected XSourceFolder fFolderRootContent = null;

        public XZipMapParser(XSourceFolder pRoot) {
            this.fFolderRootContent = pRoot;
        }

        public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAtts) throws SAXException {
            block7: {
                try {
                    if (pLocalName != TAG_ENTRY) break block7;
                    String vPathName = pAtts.getValue(TAG_ENTRY_ATT_NAME);
                    if (!vPathName.endsWith("/")) {
                        long vSize = 0L;
                        try {
                            vSize = Long.parseLong(pAtts.getValue(TAG_ENTRY_ATT_SIZE));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        XSourceFolder vParent = this.fFolderRootContent;
                        int vIdx = vPathName.lastIndexOf(47);
                        if (vIdx >= 0) {
                            vParent = (XSourceFolder)this.fFolderRootContent.findUri(vPathName.substring(0, vIdx), 0, true);
                        }
                        vParent.fChilds.add(new XSourceFile(vPathName, (int)vSize));
                        break block7;
                    }
                    String vName = vPathName;
                    XSourceFolder vParent = this.fFolderRootContent;
                    int vEnd = vPathName.length() - 1;
                    int vIdx = vPathName.lastIndexOf(47, vEnd - 1);
                    vName = vPathName.substring(vIdx + 1, vEnd);
                    if (vIdx >= 0) {
                        vParent = (XSourceFolder)this.fFolderRootContent.findUri(vPathName.substring(0, vIdx), 0, true);
                    }
                    vParent.fChilds.add(new XSourceFolder(vName));
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                    throw new SAXException(e);
                }
            }
        }
    }

    public class XSourceFile
    extends SrcContentFileBase {
        protected int fSize = -1;
        protected String fContentName = null;
        protected HTransformParams fParams = null;

        public XSourceFile(String pZipName, int pSize) throws Exception {
            this.fSize = pSize;
            this.fParams = HTransformParams.hNewParamsTransformOfType(UnzipTransformSrcServer.this.fTransformKey);
            this.fParams.hPut("path", pZipName);
            int vIdx = pZipName.lastIndexOf(47);
            this.fContentName = pZipName.substring(vIdx + 1);
        }

        public String getContentName() {
            return this.fContentName;
        }

        public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
            IByteStream vStream = SrcFeatureTransform.transformContent(UnzipTransformSrcServer.this.fZipSrcNode, this.fParams);
            return vStream != null ? vStream.getInputStream(true) : null;
        }

        public int getContentSize() throws Exception {
            return this.fSize;
        }

        public long getLastModifWithChildren() throws Exception {
            return UnzipTransformSrcServer.this.fLastUpdate;
        }
    }

    public class XSourceFolder
    extends SrcContentFolderBase {
        protected String fContentName = null;
        protected List fChilds = new ArrayList();

        public XSourceFolder(String pName) {
            this.fContentName = pName;
        }

        public String getContentName() {
            return this.fContentName;
        }

        public long getLastModifWithChildren() throws Exception {
            return UnzipTransformSrcServer.this.fLastUpdate;
        }

        public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
            ArrayList<String> vResult = null;
            vResult = new ArrayList<String>();
            if (pStatusChilds == 0) {
                for (int i = 0; i < this.fChilds.size(); ++i) {
                    Object vCh = this.fChilds.get(i);
                    String vName = vCh instanceof XSourceFolder ? ((XSourceFolder)vCh).fContentName : ((XSourceFile)vCh).fContentName;
                    vResult.add(vName);
                }
            } else if (pStatusChilds == 1) {
                for (int i = 0; i < this.fChilds.size(); ++i) {
                    Object vCh = this.fChilds.get(i);
                    if (!(vCh instanceof XSourceFile)) continue;
                    String vName = ((XSourceFile)vCh).fContentName;
                    vResult.add(vName);
                }
            } else {
                for (int i = 0; i < this.fChilds.size(); ++i) {
                    Object vCh = this.fChilds.get(i);
                    if (!(vCh instanceof XSourceFolder)) continue;
                    String vName = ((XSourceFolder)vCh).fContentName;
                    vResult.add(vName);
                }
            }
            return vResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected XSourceFolder initRoot() throws Exception {
            IByteStream vMapEntries = SrcFeatureTransform.transformContent(UnzipTransformSrcServer.this.fZipSrcNode, HTransformParams.hNewParamsTransformOfType(UnzipTransformSrcServer.this.fTransformKey));
            InputStream vInputStream = vMapEntries.getInputStream(true);
            try {
                XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                vXmlReader.setContentHandler(new XZipMapParser(this));
                vXmlReader.parse(new InputSource(vInputStream));
                HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            }
            finally {
                if (vInputStream != null) {
                    vInputStream.close();
                }
            }
            return this;
        }

        protected ISrcContent findUri(String pUri, int pStart, boolean pCreate) {
            for (int i = 0; i < this.fChilds.size(); ++i) {
                String vName;
                Object vCh = this.fChilds.get(i);
                if (vCh instanceof XSourceFolder) {
                    vName = ((XSourceFolder)vCh).fContentName;
                    if (!pUri.regionMatches(pStart, vName, 0, vName.length())) continue;
                    int vEnd = pStart + vName.length();
                    if (pUri.length() == vEnd) {
                        return (ISrcContent)vCh;
                    }
                    if (pUri.charAt(vEnd) != '/') continue;
                    return ((XSourceFolder)vCh).findUri(pUri, vEnd + 1, pCreate);
                }
                vName = ((XSourceFile)vCh).fContentName;
                if (pUri.length() != pStart + vName.length() || !pUri.regionMatches(pStart, vName, 0, vName.length())) continue;
                return (ISrcContent)vCh;
            }
            if (pCreate) {
                int vIdx = pUri.indexOf(47, pStart);
                String vName = vIdx > 0 ? pUri.substring(pStart, vIdx) : pUri.substring(pStart);
                XSourceFolder vResult = new XSourceFolder(vName);
                this.fChilds.add(vResult);
                if (vIdx > 0) {
                    return vResult.findUri(pUri, vIdx + 1, true);
                }
                return vResult;
            }
            return ISrcContent.NULL;
        }
    }
}

