/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.fulltext.IModuleFullText;
import com.scenari.src.ISrcNode;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.FullText;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import eu.scenari.fw.util.lang.TunneledException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextExecExp
extends ExecutableExpBase {
    protected ISearchFunction fRawTextSearch = null;
    protected boolean fAddResults = false;
    protected boolean fAddScore = false;

    public FullTextExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    public ISearchExecutableExp init(FullText pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) {
        this.fRawTextSearch = pExp.getRawTextSearch();
        return this;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pUris, ISearchContext.ISearchContextInternal pContext) throws Exception {
        String vText = this.fRawTextSearch.evaluate(pContext).toString();
        return new FullTextFilterIt(pUris, vText, this.matchValue()).setPredicateAsSelf();
    }

    @Override
    public boolean provideData(String pKey) {
        if (pKey == "fullText_results") {
            this.fAddResults = true;
            return true;
        }
        if (pKey == "fullText_score") {
            this.fAddScore = true;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FullTextFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected boolean fResultAttempted;
        protected String[] fTextSearch;

        public FullTextFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, String pRawTextSearch, boolean pResultAttempted) {
            super(pFrom);
            this.fTextSearch = null;
            this.fResultAttempted = pResultAttempted;
            this.fTextSearch = new String[]{pRawTextSearch};
        }

        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            try {
                FullText.FullTextResults vResults;
                IModuleFullText vFullTextModule;
                IHItemType vItemType;
                ISrcNode vNode = pEntry.getSrcNode();
                IHItemDef vItemDef = (IHItemDef)vNode.getAspect(WspSrcNodeItem.ITEMDEF_ASPECT_TYPE);
                if (vItemDef != null && (vItemType = vItemDef.hGetWorkspace().hGetItemType(vItemDef.getUriSs())) != null && (vFullTextModule = (IModuleFullText)vItemType.hGetModuleByClass(IModuleFullText.class)) != null && (vResults = vFullTextModule.match(vItemDef, this.fTextSearch, FullTextExecExp.this.fAddResults)) != null) {
                    if (this.fResultAttempted) {
                        if (FullTextExecExp.this.fAddResults) {
                            pEntry.setData("fullText_results", vResults);
                        }
                        if (FullTextExecExp.this.fAddScore) {
                            pEntry.setData("fullText_score", vResults.getScore());
                        }
                    }
                    return this.fResultAttempted;
                }
                return !this.fResultAttempted;
            }
            catch (Exception e) {
                throw new TunneledException(e);
            }
        }
    }
}

