/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.ExternalItemsMgr;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcUtil;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.src.search.helpers.util.ResultRowSrcNode;
import com.scenari.wsp.src.search.exp.ItemExternals;
import eu.scenari.fw.util.collections.IteratorBufferedNextBase;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemExternalsExecExp
extends ExecutableExpBase {
    public ItemExternalsExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    @Override
    public boolean isSearchable() throws Exception {
        return true;
    }

    public ISearchExecutableExp init(ItemExternals pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) {
        return this;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pUris, ISearchContext.ISearchContextInternal pContext) throws Exception {
        return new ItemExternalsFilterIt(pUris, this.matchValue()).setPredicateAsSelf();
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> search(ISearchContext.ISearchContextInternal pContext) throws Exception {
        Iterator<IWspSrc> vExtItems;
        ExternalItemsMgr vExtItemMgr;
        IHWorkspace vWsp = pContext.getSrcFrom().getAspect(IWspSrc.WORKSPACE_ASPECT_TYPE);
        if (vWsp != null && vWsp instanceof HWorkspaceFs && (vExtItemMgr = ((HWorkspaceFs)vWsp).getExternalItemsMgr()) != null && (vExtItems = vExtItemMgr.getExternalsItemsInUse()) != null) {
            return new ItemExternalsIt(pContext, vExtItems);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemExternalsIt
    extends IteratorBufferedNextBase<ISearchResultRow.ISearchResultRowInternal> {
        protected Iterator<IWspSrc> fSubIt;
        protected ISearchContext.ISearchContextInternal fContext;

        public ItemExternalsIt(ISearchContext.ISearchContextInternal pContext, Iterator<IWspSrc> pSubIt) {
            this.fContext = pContext;
            this.fSubIt = pSubIt;
        }

        @Override
        public boolean hasNext() {
            if (this.fNext != null) {
                return true;
            }
            if (this.fSubIt.hasNext()) {
                this.fNext = new ResultRowSrcNode(this.fSubIt.next(), this.fContext);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemExternalsFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected boolean fResultAttempted;

        public ItemExternalsFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, boolean pResultAttempted) {
            super(pFrom);
            this.fResultAttempted = pResultAttempted;
        }

        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            return WspSrcUtil.isExternalUri(pEntry.getRowUri()) == this.fResultAttempted;
        }
    }
}

