/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.wsp.src.search.exp.ItemOrphan;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import eu.scenari.fw.util.lang.TunneledException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemOrphanExecExp
extends ExecutableExpBase {
    public ItemOrphanExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    public ISearchExecutableExp init(ItemOrphan pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) {
        return this;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pUris, ISearchContext.ISearchContextInternal pContext) throws Exception {
        return new ItemOrphanFilterIt(pUris, this.matchValue()).setPredicateAsSelf();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemOrphanFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected boolean fResultAttempted;

        public ItemOrphanFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, boolean pResultAttempted) {
            super(pFrom);
            this.fResultAttempted = pResultAttempted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            try {
                IWspSrc vSrcNode = pEntry.getSrcNode().getAspect(IWspSrc.WSPSRC_ASPECT_TYPE);
                if (vSrcNode.getClass() == WspSrcNodeItem.class) {
                    XItemCache vItemCache = ((WspSrcNodeItem)vSrcNode).xGetItemCacheData().getItemCache();
                    HWorkspaceFs hWorkspaceFs = vItemCache.getWsp();
                    synchronized (hWorkspaceFs) {
                        return vItemCache.getFirstPointer() == null == this.fResultAttempted;
                    }
                }
                return !this.fResultAttempted;
            }
            catch (Exception e) {
                throw new TunneledException(e);
            }
        }
    }
}

