/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.src.ISrcNode;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.wsp.src.search.exp.ItemSgnRegexp;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import eu.scenari.fw.util.lang.TunneledException;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemSgnRegexpExecExp
extends ExecutableExpBase {
    protected ISearchFunction fRegexpSgnFunc = null;

    public ItemSgnRegexpExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    public ISearchExecutableExp init(ItemSgnRegexp pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) {
        this.fRegexpSgnFunc = pExp.getRegexpSgn();
        return this;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pUris, ISearchContext.ISearchContextInternal pContext) throws Exception {
        Object vValue = this.fRegexpSgnFunc.evaluate(pContext);
        if (vValue != null && vValue.getClass() == String.class) {
            vValue = Pattern.compile((String)vValue);
        }
        return new SgnRegexpFilterIt(pUris, (Pattern)vValue, this.matchValue()).setPredicateAsSelf();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SgnRegexpFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected boolean fResultAttempted;
        protected Pattern fRegexpSgn;

        public SgnRegexpFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, Pattern pRegexpSgn, boolean pResultAttempted) {
            super(pFrom);
            this.fResultAttempted = pResultAttempted;
            this.fRegexpSgn = pRegexpSgn;
        }

        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            try {
                ISrcNode vNode = pEntry.getSrcNode();
                IHItemDef vItemDef = vNode.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
                if (vItemDef == null) {
                    return !this.fResultAttempted;
                }
                String vSgn = vItemDef.hGetSignature();
                if (vSgn == null) {
                    return !this.fResultAttempted;
                }
                return this.fRegexpSgn.matcher(vSgn).matches() == this.fResultAttempted;
            }
            catch (Exception e) {
                throw new TunneledException(e);
            }
        }
    }
}

