/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.wsp.src.search.exp.ItemSrcType;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import eu.scenari.fw.util.lang.TunneledException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemSrcTypeExecExp
extends ExecutableExpBase {
    protected ISearchFunction fSrcTypes = null;

    public ItemSrcTypeExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    public ISearchExecutableExp init(ItemSrcType pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) {
        this.fSrcTypes = pExp.getSrcTypes();
        return this;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pUris, ISearchContext.ISearchContextInternal pContext) throws Exception {
        int vSrcTypes = this.getInt(this.fSrcTypes.evaluate(pContext));
        return new SrcTypesFilterIt(pUris, vSrcTypes, this.matchValue()).setPredicateAsSelf();
    }

    protected int getInt(Object pObject) {
        if (pObject == null) {
            return 0;
        }
        if (pObject instanceof Number) {
            return ((Number)pObject).intValue();
        }
        String vVal = pObject.toString();
        return Integer.parseInt(vVal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SrcTypesFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected boolean fResultAttempted;
        protected int fSrcTypesValue;

        public SrcTypesFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, int pSrcTypes, boolean pResultAttempted) {
            super(pFrom);
            this.fResultAttempted = pResultAttempted;
            this.fSrcTypesValue = pSrcTypes;
        }

        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            try {
                String vUri = pEntry.getRowUri();
                if (vUri.length() == 0) {
                    return (this.fSrcTypesValue & 1) != 0 == this.fResultAttempted;
                }
                int vOffsetPoint = vUri.indexOf(46);
                if (vOffsetPoint < 0) {
                    return (this.fSrcTypesValue & 2) != 0 == this.fResultAttempted;
                }
                int vOffsetSubRes = vUri.indexOf(47, vOffsetPoint + 1);
                if (vOffsetSubRes < 0) {
                    int vItemTypes = 12;
                    int vMatchItemTypes = this.fSrcTypesValue & vItemTypes;
                    if (vMatchItemTypes == 0 || vMatchItemTypes == vItemTypes) {
                        return vMatchItemTypes != 0 == this.fResultAttempted;
                    }
                    int vSrcStatus = pEntry.getSrcContent().getContentStatus();
                    vSrcStatus = vSrcStatus == 1 ? 8 : 4;
                    return (this.fSrcTypesValue & vItemTypes) != 0 == this.fResultAttempted;
                }
                int vResTypes = 48;
                int vMatchResTypes = this.fSrcTypesValue & vResTypes;
                if (vMatchResTypes == 0 || vMatchResTypes == vResTypes) {
                    return vMatchResTypes != 0 == this.fResultAttempted;
                }
                int vSrcStatus = pEntry.getSrcContent().getContentStatus();
                vSrcStatus = vSrcStatus == 1 ? 32 : 16;
                return (this.fSrcTypesValue & vSrcStatus) != 0 == this.fResultAttempted;
            }
            catch (Exception e) {
                throw new TunneledException(e);
            }
        }
    }
}

