/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.wsp.src.search.exp.ItemStatus;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import eu.scenari.fw.util.lang.TunneledException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemStatusExecExp
extends ExecutableExpBase {
    protected ISearchFunction fItemStatusMin = null;
    protected ISearchFunction fItemStatusMax = null;

    public ItemStatusExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    public ISearchExecutableExp init(ItemStatus pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) {
        this.fItemStatusMin = pExp.getItemStatusMin();
        this.fItemStatusMax = pExp.getItemStatusMax();
        return this;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pUris, ISearchContext.ISearchContextInternal pContext) throws Exception {
        int vStatusMin = this.getInt(this.fItemStatusMin.evaluate(pContext));
        int vStatusMax = this.getInt(this.fItemStatusMax.evaluate(pContext));
        return new ItemStatusFilterIt(pUris, vStatusMin, vStatusMax, this.matchValue()).setPredicateAsSelf();
    }

    protected int getInt(Object pObject) {
        if (pObject == null) {
            return 0;
        }
        if (pObject instanceof Number) {
            return ((Number)pObject).intValue();
        }
        String vVal = pObject.toString();
        return Integer.parseInt(vVal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemStatusFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected boolean fResultAttempted;
        protected int fSrcStatusMinValue;
        protected int fSrcStatusMaxValue;

        public ItemStatusFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, int pSrcStatusMin, int pSrcStatusMax, boolean pResultAttempted) {
            super(pFrom);
            this.fResultAttempted = pResultAttempted;
            this.fSrcStatusMinValue = pSrcStatusMin;
            this.fSrcStatusMaxValue = pSrcStatusMax;
        }

        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            try {
                IHItemDef vItemDef = pEntry.getSrcNode().getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
                if (vItemDef == null) {
                    return !this.fResultAttempted;
                }
                int vSrcStatus = vItemDef.hGetStatus();
                return (vSrcStatus >= this.fSrcStatusMinValue && vSrcStatus <= this.fSrcStatusMaxValue) == this.fResultAttempted;
            }
            catch (Exception e) {
                throw new TunneledException(e);
            }
        }
    }
}

