/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.item.fs.WspSrcNodeRes;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.src.ISrcServer;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.LinkDesc;
import com.scenari.src.search.func.ImmutableFunc;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.src.search.helpers.util.ResultRow;
import com.scenari.src.search.helpers.util.ResultRowSrcNode;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkDescExecExp
extends ExecutableExpBase {
    protected ISearchFunction fStartPath = ImmutableFunc.EMPTYSTRING;

    public LinkDescExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    public LinkDescExecExp init(LinkDesc pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) throws Exception {
        this.fStartPath = pExp.getStartPath();
        return this;
    }

    @Override
    public boolean isSearchable() throws Exception {
        return true;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> search(ISearchContext.ISearchContextInternal pContext) throws Exception {
        TreeSet<ISearchResultRow.ISearchResultRowInternal> vListResult = new TreeSet<ISearchResultRow.ISearchResultRowInternal>(ISearchResultRow.COMPARATOR_RESULTROW);
        String vUri = this.fStartPath.evaluate(pContext).toString();
        ISrcServer vSrcFrom = pContext.getSrcFrom();
        boolean vIsFromWspImpl = vSrcFrom instanceof IWspSrc;
        IHWorkspace vWsp = (IHWorkspace)vSrcFrom.getAspect(WspSrcNodeItem.WORKSPACE_ASPECT_TYPE);
        IWspSrc vStartNode = vWsp.findNodeByUri(vUri);
        ResultRow vResult = vIsFromWspImpl ? new ResultRowSrcNode(vStartNode, pContext) : new ResultRow(vUri, pContext);
        vListResult.add(vResult);
        if (vStartNode instanceof WspSrcNodeItem && !(vStartNode instanceof WspSrcNodeRes)) {
            this.xAddLinks(vListResult, (WspSrcNodeItem)vStartNode, vIsFromWspImpl, pContext);
        }
        return vListResult.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xAddLinks(SortedSet<ISearchResultRow.ISearchResultRowInternal> pListResult, WspSrcNodeItem pStart, boolean pIsFromWspImpl, ISearchContext.ISearchContextInternal pContext) throws Exception {
        XItemCache vItemCache = pStart.xGetItemCacheData().getItemCache();
        HWorkspaceFs hWorkspaceFs = vItemCache.getWsp();
        synchronized (hWorkspaceFs) {
            Object[] vAttrs = vItemCache.hGetAttrs();
            if (vAttrs != null) {
                for (int i = 0; i < vAttrs.length; i += 4) {
                    ResultRow vResult;
                    WspSrcNodeItem vPtdSrc;
                    String vType = (String)vAttrs[i];
                    if (vType != "Ref") continue;
                    XItemCache.XRef vRef = (XItemCache.XRef)vAttrs[i + 3];
                    if (vRef.fPtd == null || (vPtdSrc = vRef.fPtd.getSource()) == null) continue;
                    ResultRow resultRow = vResult = pIsFromWspImpl ? new ResultRowSrcNode(vPtdSrc, pContext) : new ResultRow(vPtdSrc.getSrcUri(), pContext);
                    if (!pListResult.add(vResult)) continue;
                    this.xAddLinks(pListResult, vPtdSrc, pIsFromWspImpl, pContext);
                }
            }
        }
    }
}

