/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.wsp.src.search;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspSrcNodeItem;
import com.scenari.m.bdp.item.fs.WspSrcNodeRes;
import com.scenari.m.bdp.item.fs.WspSrcNodeSpace;
import com.scenari.m.bdp.item.fs.XItemCache;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.feature.uris.SrcFeatureUris;
import com.scenari.src.helpers.walkers.SrcIteratorNode;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.LinkParentsOutOfFolder;
import com.scenari.src.search.func.ImmutableFunc;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.src.search.helpers.util.ResultRow;
import com.scenari.src.search.helpers.util.ResultRowSrcNode;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkParentsOutOfFolderExecExp
extends ExecutableExpBase {
    protected ISearchFunction fStartPath = ImmutableFunc.EMPTYSTRING;

    public LinkParentsOutOfFolderExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    public LinkParentsOutOfFolderExecExp init(LinkParentsOutOfFolder pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) throws Exception {
        this.fStartPath = pExp.getStartPath();
        return this;
    }

    @Override
    public boolean isSearchable() throws Exception {
        return true;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> search(ISearchContext.ISearchContextInternal pContext) throws Exception {
        TreeSet<ISearchResultRow.ISearchResultRowInternal> vListResult = new TreeSet<ISearchResultRow.ISearchResultRowInternal>(ISearchResultRow.COMPARATOR_RESULTROW);
        String vUri = this.fStartPath.evaluate(pContext).toString();
        ISrcServer vSrcFrom = pContext.getSrcFrom();
        boolean vIsFromWspImpl = vSrcFrom instanceof IWspSrc;
        IHWorkspace vWsp = (IHWorkspace)vSrcFrom.getAspect(WspSrcNodeItem.WORKSPACE_ASPECT_TYPE);
        IWspSrc vStartNode = vWsp.findNodeByUri(vUri);
        SrcIteratorNode vItNode = new SrcIteratorNode(vStartNode);
        ISrcNode vCurrentNode = vItNode.nextNode();
        while (vCurrentNode != null) {
            if (vCurrentNode.getClass() == WspSrcNodeSpace.class) {
                vCurrentNode = vItNode.nextNode();
                continue;
            }
            if (vCurrentNode.getClass() == WspSrcNodeItem.class) {
                this.xAddLinks(vListResult, (WspSrcNodeItem)vCurrentNode, vIsFromWspImpl, pContext, vUri);
                vCurrentNode = vItNode.nextSiblingOrUncle();
                continue;
            }
            vCurrentNode = vItNode.nextSiblingOrUncle();
        }
        if (vStartNode instanceof WspSrcNodeItem && !(vStartNode instanceof WspSrcNodeRes)) {
            this.xAddLinks(vListResult, (WspSrcNodeItem)vStartNode, vIsFromWspImpl, pContext, vUri);
        }
        return vListResult.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void xAddLinks(SortedSet<ISearchResultRow.ISearchResultRowInternal> pListResult, WspSrcNodeItem pStart, boolean pIsFromWspImpl, ISearchContext.ISearchContextInternal pContext, String pUriFolder) throws Exception {
        XItemCache vItemCache = pStart.xGetItemCacheData().getItemCache();
        HWorkspaceFs hWorkspaceFs = vItemCache.getWsp();
        synchronized (hWorkspaceFs) {
            XItemCache.XLink vPointer = vItemCache.getFirstPointer();
            while (vPointer != null) {
                if (!SrcFeatureUris.isAncestorOrSameUri(pUriFolder, vPointer.fItem.getUri())) {
                    WspSrcNodeItem vPtdSrc = vPointer.fItem.getSource();
                    ResultRow vResult = pIsFromWspImpl ? new ResultRowSrcNode(vPtdSrc, pContext) : new ResultRow(vPtdSrc.getSrcUri(), pContext);
                    pListResult.add(vResult);
                }
                vPointer = vPointer.fNextPointer;
            }
        }
    }
}

