/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xerces.serialize;

import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.Serializer;
import com.scenari.xerces.serialize.impl.SerializerFactoryImpl;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;

public abstract class SerializerFactory {
    public static final String FactoriesProperty = "org.apache.xml.serialize.factories";
    private static Hashtable _factories = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSerializerFactory(SerializerFactory factory) {
        Hashtable hashtable = _factories;
        synchronized (hashtable) {
            String method = factory.getSupportedMethod();
            _factories.put(method, factory);
        }
    }

    public static SerializerFactory getSerializerFactory(String method) {
        return (SerializerFactory)_factories.get(method);
    }

    protected abstract String getSupportedMethod();

    public abstract Serializer makeSerializer(OutputFormat var1);

    public abstract Serializer makeSerializer(Writer var1, OutputFormat var2);

    public abstract Serializer makeSerializer(OutputStream var1, OutputFormat var2) throws UnsupportedEncodingException;

    static {
        SerializerFactoryImpl factory = new SerializerFactoryImpl("xml");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("html");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("xhtml");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("text");
        SerializerFactory.registerSerializerFactory(factory);
    }
}

