/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xerces.serialize.impl;

import com.scenari.xerces.serialize.impl.EncodingMap;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.io.CharToByteConverter;

public class EncodingInfo {
    String ianaName;
    String javaName;
    int lastPrintable;
    CharToByteConverter fCToB = null;
    boolean fHaveTriedCToB = false;

    public EncodingInfo(String ianaName, String javaName, int lastPrintable) {
        this.ianaName = ianaName;
        this.javaName = EncodingMap.getIANA2JavaMapping(ianaName);
        this.lastPrintable = lastPrintable;
    }

    public String getIANAName() {
        return this.ianaName;
    }

    public Writer getWriter(OutputStream output) throws UnsupportedEncodingException {
        if (this.javaName != null) {
            return new OutputStreamWriter(output, this.javaName);
        }
        this.javaName = EncodingMap.getIANA2JavaMapping(this.ianaName);
        if (this.javaName == null) {
            return new OutputStreamWriter(output, "UTF8");
        }
        return new OutputStreamWriter(output, this.javaName);
    }

    public boolean isPrintable(char ch) {
        if (ch <= this.lastPrintable) {
            return true;
        }
        if (this.fCToB == null) {
            if (this.fHaveTriedCToB) {
                return false;
            }
            try {
                this.fCToB = CharToByteConverter.getConverter((String)this.javaName);
            }
            catch (Exception e) {
                this.fHaveTriedCToB = true;
                return false;
            }
        }
        try {
            return this.fCToB.canConvert(ch);
        }
        catch (Exception e) {
            this.fCToB = null;
            this.fHaveTriedCToB = false;
            return false;
        }
    }

    public static void testJavaEncodingName(String name) throws UnsupportedEncodingException {
        byte[] bTest = new byte[]{118, 97, 108, 105, 100};
        new String(bTest, name);
    }
}

