/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xerces.serialize.impl;

import com.scenari.xerces.serialize.impl.EncodingInfo;
import com.scenari.xerces.serialize.impl.EncodingMap;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class Encodings {
    static final int DEFAULT_LAST_PRINTABLE = 127;
    static final int LAST_PRINTABLE_UNICODE = 65535;
    static final String[] UNICODE_ENCODINGS = new String[]{"Unicode", "UnicodeBig", "UnicodeLittle", "GB2312", "UTF8"};
    static final String DEFAULT_ENCODING = "UTF8";
    static Hashtable _encodings = new Hashtable();

    public static EncodingInfo getEncodingInfo(String encoding, boolean allowJavaNames) throws UnsupportedEncodingException {
        int i;
        EncodingInfo eInfo = null;
        if (encoding == null) {
            eInfo = (EncodingInfo)_encodings.get(DEFAULT_ENCODING);
            if (eInfo != null) {
                return eInfo;
            }
            eInfo = new EncodingInfo(EncodingMap.getJava2IANAMapping(DEFAULT_ENCODING), DEFAULT_ENCODING, 65535);
            _encodings.put(DEFAULT_ENCODING, eInfo);
            return eInfo;
        }
        String jName = EncodingMap.getIANA2JavaMapping(encoding = encoding.toUpperCase());
        if (jName == null) {
            if (allowJavaNames) {
                int i2;
                EncodingInfo.testJavaEncodingName(encoding);
                eInfo = (EncodingInfo)_encodings.get(encoding);
                if (eInfo != null) {
                    return eInfo;
                }
                for (i2 = 0; i2 < UNICODE_ENCODINGS.length; ++i2) {
                    if (!UNICODE_ENCODINGS[i2].equalsIgnoreCase(encoding)) continue;
                    eInfo = new EncodingInfo(EncodingMap.getJava2IANAMapping(encoding), encoding, 65535);
                    break;
                }
                if (i2 == UNICODE_ENCODINGS.length) {
                    eInfo = new EncodingInfo(EncodingMap.getJava2IANAMapping(encoding), encoding, 127);
                }
                _encodings.put(encoding, eInfo);
                return eInfo;
            }
            throw new UnsupportedEncodingException(encoding);
        }
        eInfo = (EncodingInfo)_encodings.get(jName);
        if (eInfo != null) {
            return eInfo;
        }
        for (i = 0; i < UNICODE_ENCODINGS.length; ++i) {
            if (!UNICODE_ENCODINGS[i].equalsIgnoreCase(jName)) continue;
            eInfo = new EncodingInfo(encoding, jName, 65535);
            break;
        }
        if (i == UNICODE_ENCODINGS.length) {
            eInfo = new EncodingInfo(encoding, jName, 127);
        }
        _encodings.put(jName, eInfo);
        return eInfo;
    }
}

