/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xerces.serialize.impl;

import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.Serializer;
import com.scenari.xerces.serialize.SerializerFactory;
import com.scenari.xerces.serialize.impl.DOMMessageFormatter;
import com.scenari.xerces.serialize.impl.HTMLSerializer;
import com.scenari.xerces.serialize.impl.TextSerializer;
import com.scenari.xerces.serialize.impl.XHTMLSerializer;
import com.scenari.xerces.serialize.impl.XMLSerializer;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    public SerializerFactoryImpl(String method) {
        this._method = method;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{method});
            throw new IllegalArgumentException(msg);
        }
    }

    public Serializer makeSerializer(OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputFormat(format);
        return serializer;
    }

    public Serializer makeSerializer(Writer writer, OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    public Serializer makeSerializer(OutputStream output, OutputFormat format) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputByteStream(output);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat format) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(format);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(format);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(format);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(msg);
    }

    protected String getSupportedMethod() {
        return this._method;
    }
}

