/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xerces.serialize.impl;

import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.impl.BaseMarkupSerializer;
import com.scenari.xerces.serialize.impl.DOMMessageFormatter;
import com.scenari.xerces.serialize.impl.ElementState;
import com.scenari.xerces.serialize.impl.NamespaceSupport;
import com.scenari.xerces.serialize.impl.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream output, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(output);
    }

    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
        if (this.fNSBinder == null) {
            this.fNSBinder = new NamespaceSupport();
            this.fLocalNSBinder = new NamespaceSupport();
        }
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        try {
            String value;
            String name;
            String prefix;
            if (this._printer == null) {
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(msg);
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(localName == null || localName.length() == 0 ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            attrs = this.extractNamespaces(attrs);
            if (rawName == null || rawName.length() == 0) {
                if (localName == null) {
                    String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(msg);
                }
                rawName = namespaceURI != null && !namespaceURI.equals("") ? ((prefix = this.getPrefix(namespaceURI)) != null && prefix.length() > 0 ? prefix + ":" + localName : localName) : localName;
            }
            this._printer.printText('<');
            this._printer.printText(rawName);
            this._printer.indent();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this._printer.printSpace();
                    name = attrs.getQName(i);
                    if (name != null && name.length() == 0) {
                        name = attrs.getLocalName(i);
                        String attrURI = attrs.getURI(i);
                        if (!(attrURI == null || attrURI.length() == 0 || namespaceURI != null && namespaceURI.length() != 0 && attrURI.equals(namespaceURI) || (prefix = this.getPrefix(attrURI)) == null || prefix.length() <= 0)) {
                            name = prefix + ":" + name;
                        }
                    }
                    if ((value = attrs.getValue(i)) == null) {
                        value = "";
                    }
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                    if (!name.equals("xml:space")) continue;
                    preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                }
            }
            if (this._prefixes != null) {
                int l = this._prefixes.size();
                for (int j = 0; j < l; j += 2) {
                    value = (String)this._prefixes.get(j + 1);
                    name = (String)this._prefixes.get(j);
                    this._printer.printSpace();
                    if (name.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            name = localName == null || localName.length() == 0 ? rawName : namespaceURI + "^" + localName;
            state.doCData = this._format.isCDataElement(name);
            state.unescaped = this._format.isNonEscapingElement(name);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty) {
            this._printer.printText("/>");
        } else {
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !state.preserveSpace && (state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName);
            this._printer.printText('>');
        }
        state = this.leaveElementState();
        state.afterElement = true;
        state.afterComment = false;
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    protected void startDocument(String rootTagName) throws IOException {
        String dtd = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuilder buffer = new StringBuilder("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    buffer.append(this._format.getVersion());
                } else {
                    buffer.append("1.0");
                }
                buffer.append('\"');
                String format_encoding = this._format.getEncoding();
                if (format_encoding != null) {
                    buffer.append(" encoding=\"");
                    buffer.append(format_encoding);
                    buffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    buffer.append(" standalone=\"yes\"");
                }
                buffer.append("?>");
                this._printer.printText(buffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            for (int i = 0; i < 18 + rootTagName.length(); ++i) {
                                this._printer.printText(" ");
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (dtd != null && dtd.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(dtd, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (dtd != null && dtd.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    this._printer.printText(" [");
                    this.printText(dtd, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element elem) throws IOException {
        String value;
        String name;
        Attr attr;
        int i;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fNSBinder.pushContext();
        }
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (state.inCData) {
                this._printer.printText("]]>");
                state.inCData = false;
            }
            if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.fPreserveSpace = state.preserveSpace;
        int length = 0;
        NamedNodeMap attrMap = null;
        if (elem.hasAttributes()) {
            attrMap = elem.getAttributes();
            length = attrMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            for (i = 0; i < length; ++i) {
                attr = (Attr)attrMap.item(i);
                name = attr.getName();
                value = attr.getValue();
                if (value == null) {
                    value = "";
                }
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
                if (!name.equals("xml:space")) continue;
                this.fPreserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
            }
        } else {
            String localpart;
            String prefix;
            String uri;
            for (i = 0; i < length; ++i) {
                attr = (Attr)attrMap.item(i);
                uri = attr.getNamespaceURI();
                if (uri == null || !uri.equals(XMLNS_URI)) continue;
                value = attr.getNodeValue();
                if (value == null) {
                    value = "";
                }
                if (value.equals(XMLNS_URI)) {
                    throw new RuntimeException("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name");
                }
                prefix = attr.getPrefix();
                prefix = prefix == null || prefix.length() == 0 ? "" : prefix.intern();
                localpart = attr.getLocalName().intern();
                if (prefix == "xmlns") {
                    if ((value = value.intern()).length() == 0) continue;
                    this.fNSBinder.declarePrefix(localpart, value);
                    continue;
                }
                value = value.intern();
                this.fNSBinder.declarePrefix("", value);
            }
            uri = elem.getNamespaceURI();
            prefix = elem.getPrefix();
            if (uri != null && prefix != null && uri.length() == 0 && prefix.length() != 0) {
                prefix = null;
                this._printer.printText('<');
                this._printer.printText(elem.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(tagName);
                this._printer.indent();
            }
            if (uri != null) {
                uri = uri.intern();
                String string = prefix = prefix == null || prefix.length() == 0 ? "" : prefix.intern();
                if (this.fNSBinder.getURI(prefix) != uri) {
                    this.printNamespaceAttr(prefix, uri);
                    this.fLocalNSBinder.declarePrefix(prefix, uri);
                    this.fNSBinder.declarePrefix(prefix, uri);
                }
            } else {
                if (elem.getLocalName() == null) {
                    throw new RuntimeException("DOM Level 1 node!");
                }
                uri = this.fNSBinder.getURI("");
                if (uri != null && uri.length() > 0) {
                    this.printNamespaceAttr("", "");
                    this.fLocalNSBinder.declarePrefix("", "");
                    this.fNSBinder.declarePrefix("", "");
                }
            }
            for (i = 0; i < length; ++i) {
                attr = (Attr)attrMap.item(i);
                value = attr.getValue();
                name = attr.getNodeName();
                uri = attr.getNamespaceURI();
                if (uri != null && uri.length() == 0) {
                    uri = null;
                    name = attr.getLocalName();
                }
                if (value == null) {
                    value = "";
                }
                if (uri != null) {
                    prefix = attr.getPrefix();
                    prefix = prefix == null ? "" : prefix.intern();
                    localpart = attr.getLocalName().intern();
                    if (uri != null && uri.equals(XMLNS_URI)) {
                        String localUri;
                        prefix = attr.getPrefix();
                        prefix = prefix == null || prefix.length() == 0 ? "" : prefix.intern();
                        localpart = attr.getLocalName().intern();
                        if (prefix == "xmlns") {
                            localUri = this.fLocalNSBinder.getURI(localpart);
                            if ((value = value.intern()).length() == 0 || localUri != null) continue;
                            this.printNamespaceAttr(localpart, value);
                            this.fLocalNSBinder.declarePrefix(localpart, value);
                            continue;
                        }
                        uri = this.fNSBinder.getURI("");
                        localUri = this.fLocalNSBinder.getURI("");
                        value = value.intern();
                        if (localUri != null) continue;
                        this.printNamespaceAttr("", value);
                        continue;
                    }
                    uri = uri.intern();
                    String declaredURI = this.fNSBinder.getURI(prefix);
                    if (prefix == "" || declaredURI != uri) {
                        name = attr.getNodeName();
                        String declaredPrefix = this.fNSBinder.getPrefix(uri);
                        if (declaredPrefix != null && declaredPrefix != "") {
                            prefix = declaredPrefix;
                            name = prefix + ":" + localpart;
                        } else {
                            if (prefix == "" || this.fLocalNSBinder.getURI(prefix) != null) {
                                int counter = 1;
                                prefix = (PREFIX + counter++).intern();
                                while (this.fLocalNSBinder.getURI(prefix) != null) {
                                    prefix = (PREFIX + counter++).intern();
                                }
                                name = prefix + ":" + localpart;
                            }
                            this.printNamespaceAttr(prefix, uri);
                            value = value.intern();
                            this.fLocalNSBinder.declarePrefix(prefix, value);
                            this.fNSBinder.declarePrefix(prefix, uri);
                        }
                    }
                    this.printAttribute(name, value == null ? "" : value, attr.getSpecified());
                    continue;
                }
                if (attr.getLocalName() == null) {
                    this.printAttribute(name, value, attr.getSpecified());
                    continue;
                }
                this.printAttribute(name, value, attr.getSpecified());
            }
        }
        if (elem.hasChildNodes()) {
            state = this.enterElementState(null, null, tagName, this.fPreserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.serializeNode(child);
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, tagName);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            state.afterElement = true;
            state.afterComment = false;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String prefix, String uri) throws IOException {
        this._printer.printSpace();
        if (prefix == "") {
            this._printer.printText("xmlns");
        } else {
            this._printer.printText("xmlns:" + prefix);
        }
        this._printer.printText("=\"");
        this.printEscaped(uri);
        this._printer.printText('\"');
    }

    private void printAttribute(String name, String value, boolean isSpecified) throws IOException {
        if (isSpecified || this.fFeatures != null && !((Boolean)this.fFeatures.get("discard-default-content")).booleanValue()) {
            this._printer.printSpace();
            this._printer.printText(name);
            this._printer.printText("=\"");
            this.printEscaped(value);
            this._printer.printText('\"');
        }
        if (name.equals("xml:space")) {
            this.fPreserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int ch) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attrs) throws SAXException {
        if (attrs == null) {
            return null;
        }
        int length = attrs.getLength();
        AttributesImpl attrsOnly = new AttributesImpl(attrs);
        for (int i = length - 1; i >= 0; --i) {
            String rawName = attrsOnly.getQName(i);
            if (!rawName.startsWith("xmlns")) continue;
            if (rawName.length() == 5) {
                this.startPrefixMapping("", attrs.getValue(i));
                attrsOnly.removeAttribute(i);
                continue;
            }
            if (rawName.charAt(5) != ':') continue;
            this.startPrefixMapping(rawName.substring(6), attrs.getValue(i));
            attrsOnly.removeAttribute(i);
        }
        return attrsOnly;
    }

    protected void printEscaped(String source) throws IOException {
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (!XMLChar.isValid(ch)) {
                if (++i < length) {
                    this.surrogates(ch, source.charAt(i));
                    continue;
                }
                this.fatalError("The character '" + (char)ch + "' is an invalid XML character");
                continue;
            }
            this.printXMLChar(ch);
        }
    }

    protected void printXMLChar(int ch) throws IOException {
        if (ch == 60) {
            this._printer.printText("&lt;");
        } else if (ch == 38) {
            this._printer.printText("&amp;");
        } else if (ch == 34) {
            this._printer.printText("&quot;");
        } else if (ch >= 32 && this._encodingInfo.isPrintable((char)ch) || ch == 10 || ch == 13 || ch == 9) {
            this._printer.printText((char)ch);
        } else {
            this._printer.printText("&#x");
            this._printer.printText(Integer.toHexString(ch));
            this._printer.printText(';');
        }
    }

    protected void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        int length = text.length();
        if (preserveSpace) {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index));
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (XMLChar.isSpace(ch)) {
                    this._printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    protected void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        int vEnd = start + length;
        if (preserveSpace) {
            while (start < vEnd) {
                char ch;
                if (!XMLChar.isValid(ch = chars[start++])) {
                    if (start < vEnd) {
                        this.surrogates(ch, chars[start++]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            while (start < vEnd) {
                char ch;
                if (!XMLChar.isValid(ch = chars[start++])) {
                    if (start < vEnd) {
                        this.surrogates(ch, chars[start++]);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (XMLChar.isSpace(ch)) {
                    this._printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    public boolean reset() {
        super.reset();
        if (this.fNSBinder != null) {
            this.fNSBinder.reset();
            this.fNSBinder.declarePrefix("", "");
        }
        return true;
    }
}

