/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.extensions;

import com.scenari.xsldom.xalan.extensions.ExpressionContext;
import com.scenari.xsldom.xalan.extensions.ExtensionHandler;
import com.scenari.xsldom.xalan.extensions.XSLProcessorContext;
import com.scenari.xsldom.xalan.templates.Stylesheet;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.StringVector;
import com.scenari.xsldom.xpath.XPathProcessorException;
import com.scenari.xsldom.xpath.objects.XObject;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionHandlerGeneral
extends ExtensionHandler {
    private String m_scriptSrc;
    private String m_scriptSrcURL;
    private Hashtable m_functions = new Hashtable();
    private Hashtable m_elements = new Hashtable();
    private Object m_mgr;
    private Object m_engine;
    private static final String BSF_MANAGER = "com.ibm.bsf.BSFManager";
    private static Class managerClass;
    private static Method mgrLoadScriptingEngine;
    private static final String BSF_ENGINE = "com.ibm.bsf.BSFEngine";
    private static Method engineExec;
    private static Method engineCall;
    private static final Integer NEG1INT;

    public ExtensionHandlerGeneral(String namespaceUri, StringVector elemNames, StringVector funcNames, String scriptLang, String scriptSrcURL, String scriptSrc) throws TransformerException {
        super(namespaceUri, scriptLang);
        String tok;
        int i;
        int n;
        Object junk;
        if (elemNames != null) {
            junk = new Object();
            n = elemNames.size();
            for (i = 0; i < n; ++i) {
                tok = elemNames.elementAt(i);
                this.m_elements.put(tok, junk);
            }
        }
        if (funcNames != null) {
            junk = new Object();
            n = funcNames.size();
            for (i = 0; i < n; ++i) {
                tok = funcNames.elementAt(i);
                this.m_functions.put(tok, junk);
            }
        }
        this.m_scriptSrcURL = scriptSrcURL;
        this.m_scriptSrc = scriptSrc;
        if (this.m_scriptSrcURL != null) {
            throw new TransformerException("src attribute not yet supported for " + scriptLang);
        }
        if (null == managerClass) {
            throw new TransformerException("Could not initialize BSF manager");
        }
        try {
            this.m_mgr = managerClass.newInstance();
            this.m_engine = mgrLoadScriptingEngine.invoke(this.m_mgr, scriptLang);
            engineExec.invoke(this.m_engine, "XalanScript", NEG1INT, NEG1INT, this.m_scriptSrc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException("Could not compile extension", e);
        }
    }

    public boolean isFunctionAvailable(String function) {
        return this.m_functions.get(function) != null;
    }

    public boolean isElementAvailable(String element) {
        return this.m_elements.get(element) != null;
    }

    public Object callFunction(String funcName, Vector args, Object methodKey, ExpressionContext exprContext) throws TransformerException {
        try {
            Object[] argArray = new Object[args.size()];
            for (int i = 0; i < argArray.length; ++i) {
                Object o = args.elementAt(i);
                argArray[i] = o instanceof XObject ? ((XObject)o).object() : o;
            }
            return engineCall.invoke(this.m_engine, null, funcName, argArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = e.getMessage();
            if (null != msg) {
                if (msg.startsWith("Stopping after fatal error:")) {
                    msg = msg.substring("Stopping after fatal error:".length());
                }
                throw new TransformerException(e);
            }
            throw new TransformerException("Could not create extension: " + funcName + " because of: " + e);
        }
    }

    public void processElement(String localPart, Element element, TransformerImpl transformer, Stylesheet stylesheetTree, Node sourceTree, Node sourceNode, QName mode, Object methodKey) throws TransformerException, IOException {
        Object result = null;
        XSLProcessorContext xpc = new XSLProcessorContext(transformer, stylesheetTree, sourceTree, sourceNode, mode);
        try {
            Vector<Object> argv = new Vector<Object>(2);
            argv.addElement(xpc);
            argv.addElement(element);
            result = this.callFunction(localPart, argv, methodKey, transformer.getXPathContext());
        }
        catch (XPathProcessorException e) {
            throw new TransformerException(e.getMessage(), e);
        }
        if (result != null) {
            xpc.outputToResultTree(stylesheetTree, result);
        }
    }

    static {
        NEG1INT = new Integer(-1);
        try {
            managerClass = ExtensionHandler.getClassForName(BSF_MANAGER);
            mgrLoadScriptingEngine = managerClass.getMethod("loadScriptingEngine", String.class);
            Class engineClass = ExtensionHandler.getClassForName(BSF_ENGINE);
            engineExec = engineClass.getMethod("exec", String.class, Integer.TYPE, Integer.TYPE, Object.class);
            engineCall = engineClass.getMethod("call", Object.class, String.class, Class.forName("[Ljava.lang.Object;"));
        }
        catch (Exception e) {
            managerClass = null;
            mgrLoadScriptingEngine = null;
            engineExec = null;
            engineCall = null;
            e.printStackTrace();
        }
    }
}

