/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.extensions;

import com.scenari.xsldom.xalan.templates.Stylesheet;
import com.scenari.xsldom.xalan.transformer.ResultTreeHandler;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xpath.objects.XBoolean;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XRTreeFrag;
import com.scenari.xsldom.xpath.objects.XString;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class XSLProcessorContext {
    private TransformerImpl transformer;
    private Stylesheet stylesheetTree;
    private Node sourceTree;
    private Node sourceNode;
    private QName mode;

    public XSLProcessorContext(TransformerImpl transformer, Stylesheet stylesheetTree, Node sourceTree, Node sourceNode, QName mode) {
        this.transformer = transformer;
        this.stylesheetTree = stylesheetTree;
        this.mode = mode;
        this.sourceTree = sourceTree;
        this.sourceNode = sourceNode;
    }

    public TransformerImpl getTransformer() {
        return this.transformer;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheetTree;
    }

    public Node getSourceTree() {
        return this.sourceTree;
    }

    public Node getContextNode() {
        return this.sourceNode;
    }

    public QName getMode() {
        return this.mode;
    }

    public void outputToResultTree(Stylesheet stylesheetTree, Object obj) throws TransformerException, MalformedURLException, FileNotFoundException, IOException {
        try {
            ResultTreeHandler rtreeHandler = this.transformer.getResultTreeHandler();
            XObject value = obj instanceof XObject ? (XObject)obj : (obj instanceof String ? new XString((String)obj) : (obj instanceof Boolean ? new XBoolean((Boolean)obj) : (obj instanceof Double ? new XNumber((Double)obj) : (obj instanceof DocumentFragment ? new XRTreeFrag((DocumentFragment)obj) : (obj instanceof Node ? new XNodeSet((Node)obj) : (obj instanceof NodeIterator ? new XNodeSet((NodeIterator)obj) : new XString(obj.toString())))))));
            int type = value.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    String s = value.str();
                    rtreeHandler.characters(s);
                    break;
                }
                case 4: {
                    Node pos;
                    NodeIterator nl = value.nodeset();
                    while (null != (pos = nl.nextNode())) {
                        Node top = pos;
                        while (null != pos) {
                            rtreeHandler.flushPending();
                            rtreeHandler.cloneToResultTree(pos, true);
                            Node nextNode = pos.getFirstChild();
                            while (null == nextNode) {
                                if (1 == pos.getNodeType()) {
                                    rtreeHandler.endElement("", "", pos.getNodeName());
                                }
                                if (top == pos) break;
                                nextNode = pos.getNextSibling();
                                if (null != nextNode || top != (pos = pos.getParentNode())) continue;
                                if (1 == pos.getNodeType()) {
                                    rtreeHandler.endElement("", "", pos.getNodeName());
                                }
                                nextNode = null;
                                break;
                            }
                            pos = nextNode;
                        }
                    }
                    break;
                }
                case 5: {
                    rtreeHandler.outputResultTreeFragment(value, this.transformer.getXPathContext());
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

