/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.lib;

import com.scenari.xsldom.xalan.extensions.ExpressionContext;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.NodeSet;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XBoolean;
import com.scenari.xsldom.xpath.objects.XNumber;
import com.scenari.xsldom.xpath.objects.XObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXNotSupportedException;

public class Extensions {
    private Extensions() {
    }

    public static NodeSet nodeset(ExpressionContext myProcessor, Object rtf) {
        if (rtf instanceof NodeSet) {
            try {
                return (NodeSet)((NodeSet)rtf).cloneWithReset();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        if (rtf instanceof NodeIterator) {
            return new NodeSet((NodeIterator)rtf);
        }
        String textNodeValue = rtf instanceof String ? (String)rtf : (rtf instanceof Boolean ? new XBoolean((Boolean)rtf).str() : (rtf instanceof Double ? new XNumber((Double)rtf).str() : rtf.toString()));
        Document myDoc = myProcessor.getContextNode().getOwnerDocument();
        Text textNode = myDoc.createTextNode(textNodeValue);
        DocumentFragment docFrag = myDoc.createDocumentFragment();
        docFrag.appendChild(textNode);
        return new NodeSet(docFrag);
    }

    public static NodeSet intersection(NodeIterator ni1, NodeIterator ni2) throws TransformerException {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        NodeSet inter = new NodeSet();
        inter.setShouldCacheNodes(true);
        for (int i = 0; i < ns1.getLength(); ++i) {
            Node n = ns1.elementAt(i);
            if (!ns2.contains(n)) continue;
            inter.addElement(n);
        }
        return inter;
    }

    public static NodeSet difference(NodeIterator ni1, NodeIterator ni2) throws TransformerException {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        NodeSet diff = new NodeSet();
        diff.setShouldCacheNodes(true);
        for (int i = 0; i < ns1.getLength(); ++i) {
            Node n = ns1.elementAt(i);
            if (ns2.contains(n)) continue;
            diff.addElement(n);
        }
        return diff;
    }

    public static NodeSet distinct(NodeIterator ni) throws TransformerException {
        NodeSet ns = new NodeSet(ni);
        NodeSet dist = new NodeSet();
        dist.setShouldCacheNodes(true);
        Hashtable<String, Node> stringTable = new Hashtable<String, Node>();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node n = ns.elementAt(i);
            String key = DOMHelper.getNodeData(n);
            if (stringTable.containsKey(key)) continue;
            stringTable.put(key, n);
            dist.addElement(n);
        }
        return dist;
    }

    public static boolean hasSameNodes(NodeIterator ni1, NodeIterator ni2) {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        if (ns1.getLength() != ns2.getLength()) {
            return false;
        }
        for (int i = 0; i < ns1.getLength(); ++i) {
            Node n = ns1.elementAt(i);
            if (ns2.contains(n)) continue;
            return false;
        }
        return true;
    }

    public static XObject evaluate(ExpressionContext myContext, String xpathExpr) throws SAXNotSupportedException, Exception {
        if (myContext instanceof XPathContext) {
            XPathContext xctxt = (XPathContext)myContext;
            XPath dynamicXPath = XPath.createXPath(xpathExpr, xctxt.getSAXLocator(), xctxt.getPrefixResolver(), 0);
            return dynamicXPath.execute(xctxt, myContext.getContextNode());
        }
        throw new SAXNotSupportedException("Invalid context passed to evaluate " + myContext);
    }

    public static NodeSet tokenize(ExpressionContext myContext, String toTokenize, String delims) {
        Document lDoc = myContext.getContextNode().getOwnerDocument();
        StringTokenizer lTokenizer = new StringTokenizer(toTokenize, delims);
        NodeSet resultSet = new NodeSet();
        while (lTokenizer.hasMoreTokens()) {
            resultSet.addNode(lDoc.createTextNode(lTokenizer.nextToken()));
        }
        return resultSet;
    }

    public static NodeSet tokenize(ExpressionContext myContext, String toTokenize) {
        return Extensions.tokenize(myContext, toTokenize, " \t\n\r");
    }
}

