/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.lib;

import com.scenari.xsldom.xalan.extensions.XSLProcessorContext;
import com.scenari.xsldom.xalan.templates.ElemExtensionCall;
import com.scenari.xsldom.xalan.templates.ElemTemplateElement;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldtm.xalan.templates.OutputProperties;
import com.scenari.xsldtm.xml.serializer.SerializationHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Redirect {
    protected Hashtable m_formatterListeners = new Hashtable();
    protected Hashtable m_outputStreams = new Hashtable();

    public void open(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName = this.getFilename(context, elem);
        Object flistener = this.m_formatterListeners.get(fileName);
        if (null == flistener) {
            String mkdirsExpr = elem.getAttribute("mkdirs", context.getContextNode(), context.getTransformer());
            boolean mkdirs = mkdirsExpr != null ? mkdirsExpr.equals("true") || mkdirsExpr.equals("yes") : true;
            this.makeFormatterListener(context, elem, fileName, true, mkdirs);
        }
    }

    public void write(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        OutputStream ostream;
        ContentHandler formatter;
        String fileName = this.getFilename(context, elem);
        Object flObject = this.m_formatterListeners.get(fileName);
        boolean inTable = false;
        if (null == flObject) {
            String mkdirsExpr = elem.getAttribute("mkdirs", context.getContextNode(), context.getTransformer());
            boolean mkdirs = mkdirsExpr != null ? mkdirsExpr.equals("true") || mkdirsExpr.equals("yes") : true;
            formatter = this.makeFormatterListener(context, elem, fileName, true, mkdirs);
        } else {
            inTable = true;
            formatter = (ContentHandler)flObject;
        }
        TransformerImpl transf = context.getTransformer();
        transf.executeChildTemplates((ElemTemplateElement)elem, context.getContextNode(), context.getMode(), formatter);
        if (!inTable && null != (ostream = (OutputStream)this.m_outputStreams.get(fileName))) {
            try {
                formatter.endDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            ostream.close();
            this.m_outputStreams.remove(fileName);
            this.m_formatterListeners.remove(fileName);
        }
    }

    public void close(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName = this.getFilename(context, elem);
        Object formatterObj = this.m_formatterListeners.get(fileName);
        if (null != formatterObj) {
            ContentHandler fl = (ContentHandler)formatterObj;
            try {
                fl.endDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            OutputStream ostream = (OutputStream)this.m_outputStreams.get(fileName);
            if (null != ostream) {
                ostream.close();
                this.m_outputStreams.remove(fileName);
            }
            this.m_formatterListeners.remove(fileName);
        }
    }

    public void serialize(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        TransformerImpl vTransf = context.getTransformer();
        com.scenari.xsldom.xalan.templates.OutputProperties vFormat = (com.scenari.xsldom.xalan.templates.OutputProperties)vTransf.getOutputFormat().clone();
        String vVal = elem.getAttribute("omit-xml-declaration");
        if (vVal != null) {
            vFormat.setProperty("omit-xml-declaration", vVal);
        }
        if ((vVal = elem.getAttribute("doctype-public")) != null) {
            vFormat.setProperty("doctype-public", vVal);
        }
        if ((vVal = elem.getAttribute("doctype-system")) != null) {
            vFormat.setProperty("doctype-system", vVal);
        }
        if ((vVal = elem.getAttribute("indent")) != null) {
            vFormat.setProperty("indent", vVal);
        }
        if ((vVal = elem.getAttribute("method")) != null) {
            vFormat.setProperty("method", vVal);
        }
        if ((vVal = elem.getAttribute("cdata-section-elements")) != null) {
            vFormat.setProperty("cdata-section-elements", vVal);
        }
        StringWriter vWriter = new StringWriter();
        ContentHandler vFormatter = vTransf.createResultContentHandler(new StreamResult(vWriter), vFormat);
        try {
            vFormatter.startDocument();
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        vTransf.executeChildTemplates((ElemTemplateElement)elem, context.getContextNode(), context.getMode(), vFormatter);
        try {
            vFormatter.endDocument();
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        context.outputToResultTree(context.getStylesheet(), vWriter.toString());
    }

    public void serialize(com.scenari.xsldtm.xalan.extensions.XSLProcessorContext context, com.scenari.xsldtm.xalan.templates.ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        com.scenari.xsldtm.xalan.transformer.TransformerImpl vTransf = context.getTransformer();
        OutputProperties vFormat = (OutputProperties)vTransf.getOutputFormat().clone();
        String vVal = elem.getAttribute("omit-xml-declaration");
        if (vVal != null) {
            vFormat.setProperty("omit-xml-declaration", vVal);
        }
        if ((vVal = elem.getAttribute("doctype-public")) != null) {
            vFormat.setProperty("doctype-public", vVal);
        }
        if ((vVal = elem.getAttribute("doctype-system")) != null) {
            vFormat.setProperty("doctype-system", vVal);
        }
        if ((vVal = elem.getAttribute("indent")) != null) {
            vFormat.setProperty("indent", vVal);
        }
        if ((vVal = elem.getAttribute("method")) != null) {
            vFormat.setProperty("method", vVal);
        }
        if ((vVal = elem.getAttribute("cdata-section-elements")) != null) {
            vFormat.setProperty("cdata-section-elements", vVal);
        }
        StringWriter vWriter = new StringWriter();
        SerializationHandler vFormatter = vTransf.createSerializationHandler(new StreamResult(vWriter), vFormat);
        try {
            vFormatter.startDocument();
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        vTransf.executeChildTemplates(elem, context.getContextNode(), context.getMode(), vFormatter);
        try {
            vFormatter.endDocument();
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        context.outputToResultTree(context.getStylesheet(), vWriter.toString());
    }

    private String getFilename(XSLProcessorContext context, ElemExtensionCall elem) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String fileName;
        String fileNameExpr = elem.getAttribute("select", context.getContextNode(), context.getTransformer());
        if (null != fileNameExpr) {
            XPathContext xctxt = context.getTransformer().getXPathContext();
            XPath myxpath = XPath.createXPath(fileNameExpr, elem, xctxt.getPrefixResolver(), 0);
            XObject xobj = myxpath.execute(xctxt, context.getContextNode());
            fileName = xobj.str();
            if (null == fileName || fileName.length() == 0) {
                fileName = elem.getAttribute("file", context.getContextNode(), context.getTransformer());
            }
        } else {
            fileName = elem.getAttribute("file", context.getContextNode(), context.getTransformer());
        }
        if (null == fileName) {
            context.getTransformer().getMsgMgr().error((SourceLocator)elem, elem, context.getContextNode(), 85);
        }
        return fileName;
    }

    private String urlToFileName(String base) {
        if (null != base) {
            if (base.startsWith("file:////")) {
                base = base.substring(7);
            } else if (base.startsWith("file:///")) {
                base = base.substring(6);
            } else if (base.startsWith("file://")) {
                base = base.substring(5);
            } else if (base.startsWith("file:/")) {
                base = base.substring(5);
            } else if (base.startsWith("file:")) {
                base = base.substring(4);
            }
        }
        return base;
    }

    private ContentHandler makeFormatterListener(XSLProcessorContext context, ElemExtensionCall elem, String fileName, boolean shouldPutInTable, boolean mkdirs) throws MalformedURLException, FileNotFoundException, IOException, TransformerException {
        String dirStr;
        Result outputTarget;
        String base;
        File file = new File(fileName);
        TransformerImpl transformer = context.getTransformer();
        if (!file.isAbsolute() && null != (base = null != (outputTarget = transformer.getOutputTarget()) && (base = outputTarget.getSystemId()) != null ? this.urlToFileName(base) : this.urlToFileName(transformer.getBaseURLOfSource()))) {
            File baseFile = new File(base);
            file = new File(baseFile.getParent(), fileName);
        }
        if (mkdirs && null != (dirStr = file.getParent()) && dirStr.length() > 0) {
            File dir = new File(dirStr);
            dir.mkdirs();
        }
        com.scenari.xsldom.xalan.templates.OutputProperties format = transformer.getOutputFormat();
        FileOutputStream ostream = new FileOutputStream(file);
        try {
            ContentHandler flistener = transformer.createResultContentHandler(new StreamResult(ostream), format);
            try {
                flistener.startDocument();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            if (shouldPutInTable) {
                this.m_outputStreams.put(fileName, ostream);
                this.m_formatterListeners.put(fileName, flistener);
            }
            return flistener;
        }
        catch (TransformerException te) {
            throw new TransformerException(te);
        }
    }
}

