/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.processor;

import com.scenari.xsldom.xalan.extensions.ExtensionHandler;
import com.scenari.xsldom.xalan.processor.CompiledStylesheetBundle;
import com.scenari.xsldom.xalan.processor.CompiledTemplate;
import com.scenari.xsldom.xalan.processor.StylesheetHandler;
import com.scenari.xsldom.xalan.processor.TransformerFactoryImpl;
import com.scenari.xsldom.xalan.templates.AVT;
import com.scenari.xsldom.xalan.templates.ElemAttribute;
import com.scenari.xsldom.xalan.templates.ElemAttributeSet;
import com.scenari.xsldom.xalan.templates.ElemLiteralResult;
import com.scenari.xsldom.xalan.templates.ElemTemplate;
import com.scenari.xsldom.xalan.templates.ElemTemplateElement;
import com.scenari.xsldom.xalan.templates.ElemUse;
import com.scenari.xsldom.xalan.templates.Stylesheet;
import com.scenari.xsldom.xalan.templates.StylesheetRoot;
import com.scenari.xsldom.xalan.templates.TemplateList;
import com.scenari.xsldom.xalan.templates.XMLNSDecl;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.synthetic.JavaUtils;
import com.scenari.xsldom.xml.utils.synthetic.SynthesisException;
import com.scenari.xsldom.xml.utils.synthetic.reflection.Constructor;
import com.scenari.xsldom.xml.utils.synthetic.reflection.Method;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CompilingStylesheetHandler
extends StylesheetHandler {
    final int MAY_THROW_SAX_EXCEPTION = 1;
    private static final com.scenari.xsldom.xml.utils.synthetic.Class sClassCompiledTemplate = com.scenari.xsldom.xml.utils.synthetic.Class.forClass(CompiledTemplate.class);
    private static final com.scenari.xsldom.xml.utils.synthetic.Class sClassObjectArray = com.scenari.xsldom.xml.utils.synthetic.Class.forClass(Object[].class);
    Stack attrSetStack = new Stack();
    int uniqueVarSuffix = 0;
    static int templateCounter = 0;

    public CompilingStylesheetHandler(TransformerFactoryImpl processor) throws TransformerConfigurationException {
        super(processor);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.isStylesheetParsingComplete()) {
            ElemTemplate et;
            Stylesheet current = this.getStylesheet();
            Vector compiledTemplates = new Vector();
            StylesheetRoot root = this.getStylesheetRoot();
            TemplateList newTl = new TemplateList();
            TemplateList.TemplateWalker tw = root.getTemplateListComposed().getWalker();
            while (null != (et = tw.next())) {
                ElemTemplate ct = this.compileTemplate(et);
                newTl.setTemplate(ct != null ? ct : et);
            }
            newTl.compose();
            root.setTemplateListComposed(newTl);
            CompiledStylesheetBundle.createBundle(root, compiledTemplates);
        }
    }

    ElemTemplate compileTemplate(ElemTemplate source) {
        ElemTemplate instance = source;
        String className = this.generateUniqueClassName("com.scenari.xsldom.xalan.processor.ACompiledTemplate");
        try {
            com.scenari.xsldom.xml.utils.synthetic.Class tClass = com.scenari.xsldom.xml.utils.synthetic.Class.declareClass(className);
            tClass.setModifiers(1);
            tClass.setSuperClass(sClassCompiledTemplate);
            Constructor ctor = tClass.declareConstructor();
            ctor.setModifiers(1);
            ctor.addParameter(com.scenari.xsldom.xml.utils.synthetic.Class.forClass(ElemTemplate.class), "original");
            ctor.addParameter(sClassObjectArray, "interpretArray");
            ctor.getBody().append("super(original,\n\t" + source.getLineNumber() + ',' + source.getColumnNumber() + ",\n" + '\t' + this.makeQuotedString(source.getPublicId()) + ",\n" + '\t' + this.makeQuotedString(source.getSystemId()) + ",\n" + "\tinterpretArray);\n");
            Vector interpretVector = new Vector();
            Method exec = tClass.declareMethod("execute");
            exec.setModifiers(1);
            exec.addParameter(com.scenari.xsldom.xml.utils.synthetic.Class.forClass(TransformerImpl.class), "transformer");
            exec.addParameter(com.scenari.xsldom.xml.utils.synthetic.Class.forClass(Node.class), "sourceNode");
            exec.addParameter(com.scenari.xsldom.xml.utils.synthetic.Class.forClass(QName.class), "mode");
            exec.addExceptionType(com.scenari.xsldom.xml.utils.synthetic.Class.forClass(TransformerException.class));
            ElemTemplateElement firstChild = source.getFirstChildElem();
            if (null == firstChild) {
                exec.getBody().append("//empty template");
            } else {
                StringBuilder body = exec.getBody().append("if(transformer.S_DEBUG)\n  transformer.getTraceManager().fireTraceEvent(sourceNode, mode, this);\ncom.scenari.xsldom.xalan.transformer.ResultTreeHandler rhandler = transformer.getResultTreeHandler();\norg.xml.sax.ContentHandler saxChandler = rhandler.getContentHandler();\nif(null == sourceNode) {\n  transformer.getMsgMgr().error(this, sourceNode,\n    com.scenari.xsldom.xalan.res.XSLTErrorResources.ER_NULL_SOURCENODE_HANDLEAPPLYTEMPLATES);\n  return; }\ncom.scenari.xsldom.xpath.XPathContext xctxt = transformer.getXPathContext();\n// Check for infinite loops if requested\nboolean check = (transformer.getRecursionLimit() > -1);\nif (check)\n  transformer.getStackGuard().push(this, sourceNode);\nString avtStringedValue; // ***** Optimize away?\n\norg.xml.sax.helpers.NamespaceSupport nsSupport=new org.xml.sax.helpers.NamespaceSupport();\norg.xml.sax.helpers.NamespaceSupport savedNsSupport=(org.xml.sax.helpers.NamespaceSupport)m_nsThreadContexts.get(Thread.currentThread());\nm_nsThreadContexts.put(Thread.currentThread(),nsSupport);\n");
                this.compileChildTemplates(source, body, interpretVector);
                body.append("if(null!=savedNsSupport) m_nsThreadContexts.put(Thread.currentThread(),savedNsSupport);\nelse m_nsThreadContexts.remove(Thread.currentThread());\n\n// Decrement infinite-loop check\nif (check)\n  transformer.getStackGuard().pop();\n");
            }
            Class realclass = this.compileSyntheticClass(tClass, ".");
            Object[] eteParms = new Object[interpretVector.size()];
            interpretVector.copyInto(eteParms);
            Constructor c = tClass.getConstructor(ctor.getParameterTypes());
            Object[] parms = new Object[]{source, eteParms};
            instance = (ElemTemplate)c.newInstance(parms);
        }
        catch (SynthesisException e) {
            System.out.println("CompilingStylesheetHandler class synthesis error");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("CompilingStylesheetHandler class comilation error");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.out.println("CompilingStylesheetHandler constructor resolution error");
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            System.out.println("CompilingStylesheetHandler constructor invocation error");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.out.println("CompilingStylesheetHandler constructor invocation error");
            e.printStackTrace();
        }
        return instance;
    }

    int compileElemTemplateElement(ElemTemplateElement kid, StringBuilder body, Vector interpretVector) {
        int maythrow = 0;
        ++this.uniqueVarSuffix;
        switch (kid.getXSLToken()) {
            case 77: {
                maythrow = this.compileElemLiteralResult((ElemLiteralResult)kid, body, interpretVector);
                break;
            }
            default: {
                int offset = interpretVector.size();
                interpretVector.addElement(kid);
                body.append("((com.scenari.xsldom.xalan.templates.ElemTemplateElement)m_interpretArray[" + offset + "]).execute(transformer,sourceNode,mode);\n");
            }
        }
        return maythrow;
    }

    int compileElemLiteralResult(ElemLiteralResult ele, StringBuilder body, Vector interpretVector) {
        boolean newNSlevel;
        int maythrow = 0;
        ++this.uniqueVarSuffix;
        body.append("rhandler.startElement(\"" + ele.getNamespace() + "\",\"" + ele.getLocalName() + "\",\"" + ele.getRawName() + "\");\n");
        this.compileUseAttrSet(ele, body, interpretVector);
        Vector prefixTable = ele.getPrefixes();
        int n = prefixTable.size();
        boolean bl = newNSlevel = n > 0;
        if (newNSlevel) {
            body.append("nsSupport.pushContext();\n");
        }
        for (int i = 0; i < n; ++i) {
            XMLNSDecl decl = (XMLNSDecl)prefixTable.elementAt(i);
            if (!decl.getIsExcluded()) {
                body.append("rhandler.startPrefixMapping(\"" + decl.getPrefix() + "\",\"" + decl.getURI() + "\");\n");
            }
            body.append("nsSupport.declarePrefix(\"" + decl.getPrefix() + "\",\"" + decl.getURI() + "\");\n");
        }
        Enumeration avts = ele.enumerateLiteralResultAttributes();
        if (avts != null) {
            while (avts.hasMoreElements()) {
                AVT avt = (AVT)avts.nextElement();
                String avtValueExpression = null;
                boolean literal = avt.isContextInsensitive();
                if (literal) {
                    try {
                        avtValueExpression = this.makeQuotedString(avt.evaluate(null, null, null));
                    }
                    catch (TransformerException e) {}
                } else {
                    int offset = interpretVector.size();
                    interpretVector.addElement(avt);
                    body.append("avtStringedValue=((com.scenari.xsldom.xalan.templates.AVT)(m_interpretArray[" + offset + "])" + ").evaluate(xctxt,sourceNode,this,new StringBuilder());\n" + "if(null!=avtStringedValue)\n{\n");
                    avtValueExpression = "avtStringedValue";
                }
                body.append("rhandler.addAttribute(\"" + avt.getURI() + "\",\"" + avt.getName() + "\",\"" + avt.getRawName() + "\",\"CDATA\"," + avtValueExpression + ");\n");
                if (literal) continue;
                body.append("} // endif\n");
            }
        }
        this.compileChildTemplates(ele, body, interpretVector);
        body.append("rhandler.endElement(\"" + ele.getNamespace() + "\",\"" + ele.getLocalName() + "\",\"" + ele.getRawName() + "\");\n");
        if (newNSlevel) {
            body.append("nsSupport.popContext();\n");
        }
        return maythrow | 1;
    }

    void compileUseAttrSet(ElemTemplateElement ete, StringBuilder body, Vector interpretVector) {
        ++this.uniqueVarSuffix;
        body.append("if(transformer.S_DEBUG)\n  transformer.getTraceManager().fireTraceEvent(sourceNode, mode, this);\n");
        QName[] attributeSetsNames = ((ElemUse)ete).getUseAttributeSets();
        if (null != attributeSetsNames) {
            StylesheetRoot stylesheet = ete.getStylesheetRoot();
            for (QName qname : attributeSetsNames) {
                Vector attrSets = stylesheet.getAttributeSetComposed(qname);
                int nSets = attrSets.size();
                for (int k = 0; k < nSets; ++k) {
                    ElemAttributeSet attrSet = (ElemAttributeSet)attrSets.elementAt(k);
                    if (this.attrSetStack.contains(attrSet)) {
                        String errmsg = "TEMPLATE COMPILATION ERROR: ATTRIBUTE SET RECURSION SUPPRESSED in " + attrSet.getName().getLocalPart();
                        System.err.println(errmsg);
                        body.append("// ***** " + errmsg + " *****/\n");
                        return;
                    }
                    this.attrSetStack.push(attrSet);
                    this.compileUseAttrSet(attrSet, body, interpretVector);
                    for (ElemAttribute attr = (ElemAttribute)attrSet.getFirstChild(); null != attr; attr = (ElemAttribute)attr.getNextSibling()) {
                        this.compileElemTemplateElement(attr, body, interpretVector);
                    }
                    this.attrSetStack.pop();
                }
            }
        }
    }

    String compileAVTvalue(AVT avt, StringBuilder body, Vector interpretVector) {
        if (avt.isContextInsensitive()) {
            try {
                return this.makeQuotedString(avt.evaluate(null, null, null));
            }
            catch (TransformerException e) {
                String s = ">UNEXPECTED ERROR evaluating context-insensitive AVT<";
                System.err.println(s);
                e.printStackTrace();
                return "\"" + s + '\"';
            }
        }
        int offset = interpretVector.size();
        interpretVector.addElement(avt);
        return "( ((com.scenari.xsldom.xalan.templates.AVT)m_interpretArray[" + offset + "]).evaluate(transformer.getXPathContext(),sourceNode,this,new StringBuilder()) )";
    }

    String makeQuotedString(String in) {
        if (in == null) {
            return "null";
        }
        StringBuilder out = new StringBuilder("\"");
        int startpos = 0;
        int quotepos = in.indexOf(34, startpos);
        while (quotepos != -1) {
            out.append(in.substring(startpos, quotepos)).append('\\').append('\"');
            startpos = quotepos + 1;
            quotepos = in.indexOf(34, startpos);
        }
        out.append(in.substring(startpos)).append('\"');
        return out.toString();
    }

    String compileTransformToString(ElemTemplateElement ea, StringBuilder body, Vector interpretVector) {
        ++this.uniqueVarSuffix;
        String savedResultTreeHandler = "savedResultTreeHandler" + this.uniqueVarSuffix;
        String shandler = "shandler" + this.uniqueVarSuffix;
        String sw = "sw" + this.uniqueVarSuffix;
        String sfactory = "sfactory" + this.uniqueVarSuffix;
        String format = "format" + this.uniqueVarSuffix;
        String serializer = "serializer" + this.uniqueVarSuffix;
        String ioe = "ioe" + this.uniqueVarSuffix;
        body.append("\n// Begin transformToString (probably of attribute contents)\n// by redirecting output into a StringWriter.\ncom.scenari.xsldom.xalan.transformer.ResultTreeHandler " + savedResultTreeHandler + "=rhandler;\n" + "org.xml.sax.ContentHandler " + shandler + ";\n" + "java.io.StringWriter " + sw + ";\n" + "try\n{\n" + "com.scenari.xsldom.xml.com.scenari.xsldom.xalan.serialize.SerializerFactory " + sfactory + "=com.scenari.xsldom.xml.com.scenari.xsldom.xalan.serialize.SerializerFactory.getSerializerFactory(\"text\");\n" + sw + "=new java.io.StringWriter();\n" + "com.scenari.xsldom.xalan.templates.OutputProperties " + format + "=new com.scenari.xsldom.xalan.templates.OutputProperties();\n" + format + ".setPreserveSpace(true);\n" + "com.scenari.xsldom.xml.com.scenari.xsldom.xalan.serialize.Serializer " + serializer + "=" + sfactory + ".makeSerializer(" + sw + "," + format + ");\n" + shandler + "=" + serializer + ".asContentHandler();\n" + "}\ncatch (java.io.IOException " + ioe + ")\n{\n" + "throw new javax.xml.transform.TransformerException(" + ioe + ");\n}\n" + "rhandler=new com.scenari.xsldom.xalan.transformer.ResultTreeHandler(transformer," + shandler + ");\n\n" + "rhandler.startDocument();\n" + "\n//unwind executeChildTemplates\n");
        this.compileChildTemplates(ea, body, interpretVector);
        body.append("\nrhandler.flushPending();\nrhandler.endDocument();\nrhandler=" + savedResultTreeHandler + ";\n" + "//End transformToString unwind; result in " + sw + "\n\n");
        return "(" + sw + ".toString())";
    }

    void compileElemAttribute(ElemAttribute ea, StringBuilder body, Vector interpretVector) {
        ++this.uniqueVarSuffix;
        String attrName = "attrName" + this.uniqueVarSuffix;
        String val = "val" + this.uniqueVarSuffix;
        String attrNameSpace = "attrNameSpace" + this.uniqueVarSuffix;
        String prefix = "prefix" + this.uniqueVarSuffix;
        String ns = "ns" + this.uniqueVarSuffix;
        String attributeHandled = "attributeHandled" + this.uniqueVarSuffix;
        String nsprefix = "nsprefix" + this.uniqueVarSuffix;
        String ex = "ex" + this.uniqueVarSuffix;
        String localName = "localName" + this.uniqueVarSuffix;
        String origAttrName = this.compileAVTvalue(ea.getName(), body, interpretVector);
        body.append("if(null == rhandler.getPendingElementName())\n{\ntransformer.getMsgMgr().warn(com.scenari.xsldom.xalan.res.XSLTErrorResources.WG_ILLEGAL_ATTRIBUTE_NAME, new Object[]{" + origAttrName + "}); \n" + "// warn(templateChild, sourceNode, \"Trying to add attribute after element child has been added, ignoring...\");\n" + "}\n");
        if (null == origAttrName) {
            return;
        }
        body.append("boolean " + attributeHandled + "=false;\n");
        body.append("String " + attrName + "=" + origAttrName + ";\n");
        String strval = this.compileTransformToString(ea, body, interpretVector);
        body.append("String " + val + "=" + strval + ";\n");
        body.append("if(null == rhandler.getPendingElementName())\n{\ntransformer.getMsgMgr().warn(com.scenari.xsldom.xalan.res.XSLTErrorResources.WG_ILLEGAL_ATTRIBUTE_NAME, new Object[]{" + origAttrName + "}); \n" + "// warn(templateChild, sourceNode, \"Trying to add attribute after element child has been added, ignoring...\");\n" + "}\n" + "if(null==" + attrName + ")\n return;\n\n");
        body.append("String " + attrNameSpace + "=null; // by default\n");
        if (null != ea.getNamespace()) {
            String avtValueExpression = this.compileAVTvalue(ea.getNamespace(), body, interpretVector);
            body.append(attrNameSpace + "=" + avtValueExpression + ";\n" + "if(null!=" + attrNameSpace + " && " + attrNameSpace + ".length()>0)\n" + "{\n" + "  String " + prefix + "=rhandler.getPrefix(" + attrNameSpace + ");\n" + "  if(null==" + prefix + ")\n" + "  {\n" + "    " + prefix + "=rhandler.getNewUniqueNSPrefix();\n" + "    rhandler.startPrefixMapping(" + prefix + "," + attrNameSpace + ");\n" + "  }\n" + "  " + attrName + "=(" + prefix + "+':'+com.scenari.xsldom.xml.utils.QName.getLocalPart(" + attrName + "));\n" + "}\n");
        }
        body.append("if(com.scenari.xsldom.xml.utils.QName.isXMLNSDecl(" + origAttrName + "))\n" + "{ // Just declare namespace prefix \n" + "  String " + prefix + "=com.scenari.xsldom.xml.utils.QName.getPrefixFromXMLNSDecl(" + origAttrName + ");\n" + "  String " + ns + "=rhandler.getURI(" + prefix + ");\n" + "  if(null==" + ns + ")\n" + "    rhandler.startPrefixMapping(" + prefix + "," + val + ");\n");
        body.append("  " + attributeHandled + "=true;\n");
        body.append("}\nelse\n{\n  String " + nsprefix + "=com.scenari.xsldom.xml.utils.QName.getPrefixPart(" + origAttrName + ");\n" + "  if(null==" + nsprefix + ") " + nsprefix + "=\"\";\n" + attrNameSpace + "=nsSupport.getURI(" + nsprefix + ");\n" + "if(!" + attributeHandled + ")\n{\n" + "String " + localName + "=com.scenari.xsldom.xml.utils.QName.getLocalPart(" + attrName + ");\n" + "rhandler.addAttribute(" + attrNameSpace + "," + localName + "," + attrName + ",\"CDATA\"," + val + ");\n" + "} //end attributeHandled\n" + "} //end else\n");
    }

    void compileChildTemplates(ElemTemplateElement source, StringBuilder body, Vector interpretVector) {
        int maythrow = 0;
        ++this.uniqueVarSuffix;
        if (source.getFirstChildElem() != null) {
            String savedLocatorName = "savedLocator" + this.uniqueVarSuffix;
            String varstackName = "varstack" + this.uniqueVarSuffix;
            body.append("\n// Unwound Transformer.executeChildTemplates: //\n\n// We need to push an element frame in the variables stack,\n// so all the variables can be popped at once when we're done.\ncom.scenari.xsldom.xpath.VariableStack " + varstackName + " = transformer.getXPathContext().getVarStack();\n" + varstackName + ".pushElemFrame();\n" + "javax.xml.transform.SourceLocator " + savedLocatorName + " = xctxt.getSAXLocator();\n");
            body.append("try {\n\n");
            for (ElemTemplateElement kid = source.getFirstChildElem(); kid != null; kid = kid.getNextSiblingElem()) {
                maythrow |= this.compileElemTemplateElement(kid, body, interpretVector);
            }
            body.append("\n\n}\n");
            if (0 != (maythrow & 1)) {
                body.append("catch(org.xml.sax.SAXException se) {\n  throw new javax.xml.transform.TransformerException(se);\n}\n");
            }
            body.append("finally {\n  xctxt.setSAXLocator(" + savedLocatorName + ");\n" + "  // Pop all the variables in this element frame.\n" + "  " + varstackName + ".popElemFrame();\n" + "}\n");
        }
    }

    Class compileSyntheticClass(com.scenari.xsldom.xml.utils.synthetic.Class tClass, String classLocation) {
        Class resolved = null;
        String filename = classLocation;
        int fnstart = filename.lastIndexOf(File.separator);
        StringBuilder subdir = new StringBuilder(fnstart >= 0 ? filename.substring(0, fnstart) : ".");
        StringTokenizer parts = new StringTokenizer(tClass.getPackageName(), ".");
        while (parts.hasMoreTokens()) {
            subdir.append(File.separator).append(parts.nextToken());
        }
        if (fnstart < 0) {
            subdir.append(File.separator);
        }
        File jfile = new File(subdir.toString());
        jfile.mkdirs();
        subdir.append(tClass.getShortName()).append(".java");
        filename = subdir.toString();
        jfile = new File(filename);
        try {
            PrintWriter out = new PrintWriter(new FileWriter(filename));
            tClass.toSource(out, 0);
            out.close();
        }
        catch (IOException e) {
            System.err.println("ERR: File open failed for " + filename);
            e.printStackTrace();
            return null;
        }
        String classpath = System.getProperty("java.class.path");
        String javac_options = System.getProperty("com.scenari.xsldom.xalan.processor.CompilingStylesheetHandler.options", "");
        boolean debug = javac_options.indexOf("-g") >= 0;
        JavaUtils.setDebug(debug);
        boolean compileOK = JavaUtils.JDKcompile(filename, classpath);
        if (compileOK) {
            if (debug) {
                System.err.println("\tCompilation successful. Debug specified, .java file retained.");
            } else if (jfile.exists()) {
                jfile.delete();
            }
            try {
                resolved = ExtensionHandler.getClassForName(tClass.getName());
                tClass.setRealClass(resolved);
            }
            catch (ClassNotFoundException e) {
                System.err.println("ERR: synthesized Template class load failed for " + tClass.getName());
                e.printStackTrace();
            }
            catch (SynthesisException e) {
                System.err.println("ERR: synthesized Template class realization failed for " + tClass.getName());
                e.printStackTrace();
            }
        } else {
            if (debug) {
                System.err.println("\tTemplate compilation failed; retaining .java file");
            }
            System.err.println("ERR: Java compilation failed for " + filename);
            System.exit(1);
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String generateUniqueClassName(String basename) {
        long templateNumber;
        long intAddr = 0L;
        try {
            byte[] ipAddr = InetAddress.getLocalHost().getAddress();
            for (int i = 0; i < ipAddr.length; ++i) {
                intAddr = (intAddr << 8) + (long)ipAddr[i];
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        CompilingStylesheetHandler compilingStylesheetHandler = this;
        synchronized (compilingStylesheetHandler) {
            templateNumber = ++templateCounter;
        }
        String className = basename + "On" + intAddr + "at" + new Date().getTime() + 'n' + templateNumber;
        return className;
    }
}

