/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.processor;

import com.scenari.xsldom.xalan.processor.StylesheetHandler;
import com.scenari.xsldom.xalan.templates.AVT;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.StringToIntTable;
import com.scenari.xsldom.xml.utils.StringVector;
import com.scenari.xsldom.xpath.XPath;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class XSLTAttributeDef {
    static final int T_CDATA = 1;
    static final int T_URL = 2;
    static final int T_AVT = 3;
    static final int T_PATTERN = 4;
    static final int T_EXPR = 5;
    static final int T_CHAR = 6;
    static final int T_PRIORITY = 7;
    static final int T_YESNO = 8;
    static final int T_QNAME = 9;
    static final int T_QNAMES = 10;
    static final int T_ENUM = 11;
    static final int T_SIMPLEPATTERNLIST = 12;
    static final int T_NMTOKEN = 13;
    static final int T_STRINGLIST = 14;
    static final int T_PREFIX_URLLIST = 15;
    static XSLTAttributeDef m_foreignAttr = new XSLTAttributeDef("*", "*", 1, false);
    static String S_FOREIGNATTR_SETTER = "setForeignAttr";
    private String m_namespace;
    private String m_name;
    private int m_type;
    private StringToIntTable m_enums;
    private String m_default;
    private boolean m_required;
    String m_setterString = null;

    XSLTAttributeDef(String namespace, String name, int type, boolean required) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_type = type;
        this.m_required = required;
    }

    XSLTAttributeDef(String namespace, String name, int type, String defaultVal) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_type = type;
        this.m_required = false;
        this.m_default = defaultVal;
    }

    XSLTAttributeDef(String namespace, String name, boolean required, String k1, int v1, String k2, int v2) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_type = 11;
        this.m_required = required;
        this.m_enums = new StringToIntTable(2);
        this.m_enums.put(k1, v1);
        this.m_enums.put(k2, v2);
    }

    XSLTAttributeDef(String namespace, String name, boolean required, String k1, int v1, String k2, int v2, String k3, int v3) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_type = 11;
        this.m_required = required;
        this.m_enums = new StringToIntTable(3);
        this.m_enums.put(k1, v1);
        this.m_enums.put(k2, v2);
        this.m_enums.put(k3, v3);
    }

    XSLTAttributeDef(String namespace, String name, boolean required, String k1, int v1, String k2, int v2, String k3, int v3, String k4, int v4) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_type = 11;
        this.m_required = required;
        this.m_enums = new StringToIntTable(4);
        this.m_enums.put(k1, v1);
        this.m_enums.put(k2, v2);
        this.m_enums.put(k3, v3);
        this.m_enums.put(k4, v4);
    }

    String getNamespace() {
        return this.m_namespace;
    }

    String getName() {
        return this.m_name;
    }

    int getType() {
        return this.m_type;
    }

    private int getEnum(String key) {
        return this.m_enums.get(key);
    }

    String getDefault() {
        return this.m_default;
    }

    void setDefault(String def) {
        this.m_default = def;
    }

    boolean getRequired() {
        return this.m_required;
    }

    public String getSetterMethodName() {
        if (null == this.m_setterString) {
            if (m_foreignAttr == this) {
                return S_FOREIGNATTR_SETTER;
            }
            if (this.m_name.equals("*")) {
                this.m_setterString = "addLiteralResultAttribute";
                return this.m_setterString;
            }
            StringBuilder outBuf = new StringBuilder();
            outBuf.append("set");
            if (this.m_namespace != null && this.m_namespace.equals("http://www.w3.org/XML/1998/namespace")) {
                outBuf.append("Xml");
            }
            int n = this.m_name.length();
            for (int i = 0; i < n; ++i) {
                char c = this.m_name.charAt(i);
                if ('-' == c) {
                    c = this.m_name.charAt(++i);
                    c = Character.toUpperCase(c);
                } else if (0 == i) {
                    c = Character.toUpperCase(c);
                }
                outBuf.append(c);
            }
            this.m_setterString = outBuf.toString();
        }
        return this.m_setterString;
    }

    AVT processAVT(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        try {
            AVT avt = new AVT(handler, uri, name, rawName, value);
            return avt;
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    Object processCDATA(StylesheetHandler handler, String uri, String name, String rawName, String value) {
        return value;
    }

    Object processCHAR(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        if (value.length() != 1) {
            handler.error("An XSLT attribute of type T_CHAR must be only 1 character!", null);
        }
        return new Character(value.charAt(0));
    }

    Object processENUM(StylesheetHandler handler, String uri, String name, String rawName, String value) {
        int vEnum = this.getEnum(value);
        return new Integer(vEnum);
    }

    Object processEXPR(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        try {
            XPath expr = handler.createXPath(value);
            return expr;
        }
        catch (TransformerException te) {
            SAXException se = new SAXException(te);
            throw new SAXException(te);
        }
    }

    Object processNMTOKEN(StylesheetHandler handler, String uri, String name, String rawName, String value) {
        return value;
    }

    Object processPATTERN(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        try {
            XPath pattern = handler.createMatchPatternXPath(value);
            return pattern;
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    Object processPRIORITY(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            handler.error("Priority value does not contain a parsable number.", nfe);
            return new Double(0.0);
        }
    }

    Object processQNAME(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        return new QName(value, handler);
    }

    Vector processQNAMES(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r\f");
        int nQNames = tokenizer.countTokens();
        Vector<QName> qnames = new Vector<QName>(nQNames);
        for (int i = 0; i < nQNames; ++i) {
            qnames.addElement(new QName(tokenizer.nextToken()));
        }
        return qnames;
    }

    Vector processSIMPLEPATTERNLIST(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r\f");
            int nPatterns = tokenizer.countTokens();
            Vector<XPath> patterns = new Vector<XPath>(nPatterns);
            for (int i = 0; i < nPatterns; ++i) {
                XPath pattern = handler.createMatchPatternXPath(tokenizer.nextToken());
                patterns.addElement(pattern);
            }
            return patterns;
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    StringVector processSTRINGLIST(StylesheetHandler handler, String uri, String name, String rawName, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r\f");
        int nStrings = tokenizer.countTokens();
        StringVector strings = new StringVector(nStrings);
        for (int i = 0; i < nStrings; ++i) {
            strings.addElement(tokenizer.nextToken());
        }
        return strings;
    }

    StringVector processPREFIX_URLLIST(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r\f");
        int nStrings = tokenizer.countTokens();
        StringVector strings = new StringVector(nStrings);
        for (int i = 0; i < nStrings; ++i) {
            String prefix = tokenizer.nextToken();
            String url = handler.getNamespaceForPrefix(prefix);
            strings.addElement(url);
        }
        return strings;
    }

    String processURL(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        return value;
    }

    private Boolean processYESNO(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        if (!value.equals("yes") && !value.equals("no")) {
            handler.error("Value for " + name + " should equal 'yes' or 'no'", null);
        }
        return new Boolean(value.equals("yes"));
    }

    Object processValue(StylesheetHandler handler, String uri, String name, String rawName, String value) throws SAXException {
        int type = this.getType();
        Object processedValue = null;
        switch (type) {
            case 3: {
                processedValue = this.processAVT(handler, uri, name, rawName, value);
                break;
            }
            case 1: {
                processedValue = this.processCDATA(handler, uri, name, rawName, value);
                break;
            }
            case 6: {
                processedValue = this.processCHAR(handler, uri, name, rawName, value);
                break;
            }
            case 11: {
                processedValue = this.processENUM(handler, uri, name, rawName, value);
                break;
            }
            case 5: {
                processedValue = this.processEXPR(handler, uri, name, rawName, value);
                break;
            }
            case 13: {
                processedValue = this.processNMTOKEN(handler, uri, name, rawName, value);
                break;
            }
            case 4: {
                processedValue = this.processPATTERN(handler, uri, name, rawName, value);
                break;
            }
            case 7: {
                processedValue = this.processPRIORITY(handler, uri, name, rawName, value);
                break;
            }
            case 9: {
                processedValue = this.processQNAME(handler, uri, name, rawName, value);
                break;
            }
            case 10: {
                processedValue = this.processQNAMES(handler, uri, name, rawName, value);
                break;
            }
            case 12: {
                processedValue = this.processSIMPLEPATTERNLIST(handler, uri, name, rawName, value);
                break;
            }
            case 2: {
                processedValue = this.processURL(handler, uri, name, rawName, value);
                break;
            }
            case 8: {
                processedValue = this.processYESNO(handler, uri, name, rawName, value);
                break;
            }
            case 14: {
                processedValue = this.processSTRINGLIST(handler, uri, name, rawName, value);
                break;
            }
            case 15: {
                processedValue = this.processPREFIX_URLLIST(handler, uri, name, rawName, value);
                break;
            }
        }
        return processedValue;
    }

    void setDefAttrValue(StylesheetHandler handler, Object elem) throws SAXException {
        this.setAttrValue(handler, this.getNamespace(), this.getName(), this.getName(), this.getDefault(), elem);
    }

    private Class getPrimativeClass(Object obj) {
        if (obj instanceof XPath) {
            return XPath.class;
        }
        Class<Object> cl = obj.getClass();
        if (cl == Double.class) {
            cl = Double.TYPE;
        }
        if (cl == Float.class) {
            cl = Float.TYPE;
        } else if (cl == Boolean.class) {
            cl = Boolean.TYPE;
        } else if (cl == Byte.class) {
            cl = Byte.TYPE;
        } else if (cl == Character.class) {
            cl = Character.TYPE;
        } else if (cl == Short.class) {
            cl = Short.TYPE;
        } else if (cl == Integer.class) {
            cl = Integer.TYPE;
        } else if (cl == Long.class) {
            cl = Long.TYPE;
        }
        return cl;
    }

    void setAttrValue(StylesheetHandler handler, String attrUri, String attrLocalName, String attrRawName, String attrValue, Object elem) throws SAXException {
        if (attrRawName.equals("xmlns") || attrRawName.startsWith("xmlns:")) {
            return;
        }
        String setterString = this.getSetterMethodName();
        if (null != setterString) {
            try {
                Object[] args;
                Method meth;
                if (setterString.equals(S_FOREIGNATTR_SETTER)) {
                    if (attrUri == null) {
                        attrUri = "";
                    }
                    Class<?> sclass = attrUri.getClass();
                    Class[] argTypes = new Class[]{sclass, sclass, sclass, sclass};
                    meth = elem.getClass().getMethod(setterString, argTypes);
                    args = new Object[]{attrUri, attrLocalName, attrRawName, attrValue};
                } else {
                    Object value = this.processValue(handler, attrUri, attrLocalName, attrRawName, attrValue);
                    Class[] argTypes = new Class[]{this.getPrimativeClass(value)};
                    try {
                        meth = elem.getClass().getMethod(setterString, argTypes);
                    }
                    catch (NoSuchMethodException nsme) {
                        Class<?> cl;
                        argTypes[0] = cl = value.getClass();
                        meth = elem.getClass().getMethod(setterString, argTypes);
                    }
                    args = new Object[]{value};
                }
                meth.invoke(elem, args);
            }
            catch (NoSuchMethodException nsme) {
                if (!setterString.equals(S_FOREIGNATTR_SETTER)) {
                    handler.error("Failed calling " + setterString + " method!", nsme);
                }
            }
            catch (IllegalAccessException iae) {
                handler.error("Failed calling " + setterString + " method!", iae);
            }
            catch (InvocationTargetException nsme) {
                handler.error("Failed calling " + setterString + " method!", nsme);
            }
        }
    }
}

