/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.processor;

import com.scenari.xsldom.xalan.processor.StylesheetHandler;
import com.scenari.xsldom.xalan.processor.XSLTAttributeDef;
import com.scenari.xsldom.xalan.processor.XSLTElementDef;
import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xml.utils.IntStack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSLTElementProcessor {
    private IntStack m_savedLastOrder;
    private XSLTElementDef m_elemDef;

    XSLTElementProcessor() {
    }

    XSLTElementDef getElemDef() {
        return this.m_elemDef;
    }

    void setElemDef(XSLTElementDef def) {
        this.m_elemDef = def;
    }

    public InputSource resolveEntity(StylesheetHandler handler, String publicId, String systemId) throws SAXException {
        return null;
    }

    public void notationDecl(StylesheetHandler handler, String name, String publicId, String systemId) {
    }

    public void unparsedEntityDecl(StylesheetHandler handler, String name, String publicId, String systemId, String notationName) {
    }

    public void startNonText(StylesheetHandler handler) throws SAXException {
    }

    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (this.m_savedLastOrder == null) {
            this.m_savedLastOrder = new IntStack();
        }
        this.m_savedLastOrder.push(this.getElemDef().getLastOrder());
        this.getElemDef().setLastOrder(-1);
    }

    public void endElement(StylesheetHandler handler, String uri, String localName, String rawName) throws SAXException {
        if (this.m_savedLastOrder != null && !this.m_savedLastOrder.empty()) {
            this.getElemDef().setLastOrder(this.m_savedLastOrder.pop());
        }
        if (!this.getElemDef().getRequiredFound()) {
            handler.error(110, new Object[]{this.getElemDef().getRequiredElem()}, null);
        }
    }

    public void characters(StylesheetHandler handler, char[] ch, int start, int length) throws SAXException {
        handler.error("Characters are not allowed at this point in the document!", null);
    }

    public void ignorableWhitespace(StylesheetHandler handler, char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(StylesheetHandler handler, String target, String data) throws SAXException {
    }

    public void skippedEntity(StylesheetHandler handler, String name) throws SAXException {
    }

    void setPropertiesFromAttributes(StylesheetHandler handler, String rawName, Attributes attributes, Object target) throws SAXException {
        this.setPropertiesFromAttributes(handler, rawName, attributes, target, true);
    }

    Attributes setPropertiesFromAttributes(StylesheetHandler handler, String rawName, Attributes attributes, Object target, boolean throwError) throws SAXException {
        XSLTElementDef def = this.getElemDef();
        AttributesImpl undefines = throwError ? null : new AttributesImpl();
        Vector<XSLTAttributeDef> processedDefs = new Vector<XSLTAttributeDef>();
        int nAttrs = attributes.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            String attrLocalName;
            XSLTAttributeDef attrDef;
            String attrUri = attributes.getURI(i);
            if (null != attrUri && attrUri.length() == 0 && (attributes.getQName(i).startsWith("xmlns:") || attributes.getQName(i).equals("xmlns"))) {
                attrUri = "http://www.w3.org/XML/1998/namespace";
            }
            if (null == (attrDef = def.getAttributeDef(attrUri, attrLocalName = attributes.getLocalName(i)))) {
                if (throwError) {
                    handler.error("\"" + attributes.getQName(i) + "\"" + " attribute is not allowed on the " + rawName + " element!", null);
                    continue;
                }
                undefines.addAttribute(attrUri, attrLocalName, attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                continue;
            }
            processedDefs.addElement(attrDef);
            attrDef.setAttrValue(handler, attrUri, attrLocalName, attributes.getQName(i), attributes.getValue(i), target);
        }
        for (XSLTAttributeDef attrDef : def.getAttributes()) {
            String defVal = attrDef.getDefault();
            if (null != defVal && !processedDefs.contains(attrDef)) {
                attrDef.setDefAttrValue(handler, target);
            }
            if (!attrDef.getRequired() || processedDefs.contains(attrDef)) continue;
            handler.error(XSLMessages.createMessage(9, new Object[]{rawName, attrDef.getName()}), null);
        }
        return undefines;
    }
}

