/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.res;

import com.scenari.xsldom.xml.utils.res.XResourceBundleBase;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class XSLMessages {
    private Locale fLocale = Locale.getDefault();
    private static XResourceBundleBase XSLTBundle = null;
    private static XResourceBundleBase XPATHBundle = null;
    private static final String XSLT_ERROR_RESOURCES = "com.scenari.xsldom.xalan.res.XSLTErrorResources";
    private static final String XPATH_ERROR_RESOURCES = "com.scenari.xsldom.xpath.res.XPATHErrorResources";
    private static String BAD_CODE = "BAD_CODE";
    private static String FORMAT_FAILED = "FORMAT_FAILED";

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public static final String createXPATHWarning(int errorCode, Object[] args) {
        XResourceBundleBase fResourceBundle;
        if (XPATHBundle == null) {
            XPATHBundle = (XResourceBundleBase)XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XPATHBundle) != null) {
            String msgKey = fResourceBundle.getWarningKey(errorCode);
            return XSLMessages.createXPATHMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMessage(int errorCode, Object[] args) {
        XResourceBundleBase fResourceBundle;
        if (XPATHBundle == null) {
            XPATHBundle = (XResourceBundleBase)XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XPATHBundle) != null) {
            String msgKey = fResourceBundle.getMessageKey(errorCode);
            return XSLMessages.createXPATHMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMsg(XResourceBundleBase fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString("BAD_CODE");
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                for (int i = 0; i < n; ++i) {
                    if (null != args[i]) continue;
                    args[i] = "";
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = fResourceBundle.getString("FORMAT_FAILED");
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final String createWarning(int errorCode, Object[] args) {
        XResourceBundleBase fResourceBundle;
        if (XSLTBundle == null) {
            XSLTBundle = (XResourceBundleBase)XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XSLTBundle) != null) {
            String msgKey = fResourceBundle.getWarningKey(errorCode);
            return XSLMessages.createMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMessage(int errorCode, Object[] args) {
        XResourceBundleBase fResourceBundle;
        if (XSLTBundle == null) {
            XSLTBundle = (XResourceBundleBase)XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if ((fResourceBundle = XSLTBundle) != null) {
            String msgKey = fResourceBundle.getMessageKey(errorCode);
            return XSLMessages.createMsg(fResourceBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMsg(XResourceBundleBase fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString(BAD_CODE);
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                for (int i = 0; i < n; ++i) {
                    if (null != args[i]) continue;
                    args[i] = "";
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = fResourceBundle.getString(FORMAT_FAILED);
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public String createMessage(String bundleName, int errorCode, Object[] args) throws Exception {
        boolean throwex = false;
        String fmsg = null;
        XResourceBundleBase aResourceBundle = null;
        aResourceBundle = (XResourceBundleBase)XSLMessages.loadResourceBundle(bundleName);
        String msgKey = aResourceBundle.getMessageKey(errorCode);
        String msg = null;
        if (msgKey != null) {
            msg = aResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = aResourceBundle.getString(BAD_CODE);
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                for (int i = 0; i < n; ++i) {
                    if (null != args[i]) continue;
                    args[i] = "";
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = aResourceBundle.getString(FORMAT_FAILED);
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final ListResourceBundle loadResourceBundle(String className) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        try {
            return (ListResourceBundle)ResourceBundle.getBundle(className, locale);
        }
        catch (MissingResourceException e) {
            try {
                return (ListResourceBundle)ResourceBundle.getBundle(XSLT_ERROR_RESOURCES, new Locale("en", "US"));
            }
            catch (MissingResourceException e2) {
                throw new MissingResourceException("Could not load any resource bundles." + className, className, "");
            }
        }
    }

    private static final String getResourceSuffix(Locale locale) {
        String suffix = "_" + locale.getLanguage();
        String country = locale.getCountry();
        if (country.equals("TW")) {
            suffix = suffix + "_" + country;
        }
        return suffix;
    }
}

