/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.stree;

import com.scenari.xsldom.xalan.stree.CDATASectionImpl;
import com.scenari.xsldom.xalan.stree.CommentImpl;
import com.scenari.xsldom.xalan.stree.DocImpl;
import com.scenari.xsldom.xalan.stree.DocumentFragmentImpl;
import com.scenari.xsldom.xalan.stree.DocumentTypeImpl;
import com.scenari.xsldom.xalan.stree.ElementImpl;
import com.scenari.xsldom.xalan.stree.ElementImplWithNS;
import com.scenari.xsldom.xalan.stree.ProcessingInstructionImpl;
import com.scenari.xsldom.xalan.stree.SourceTreeHandler;
import com.scenari.xsldom.xalan.stree.TextImpl;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends DocImpl {
    DocumentTypeImpl m_docType;
    ElementImpl m_docElement;
    HashMap m_idAttributes = new HashMap();

    public DocumentImpl() {
        this.setDoc(this);
    }

    public DocumentImpl(boolean pWaitForComplete) {
        this.fWaitForComplete = pWaitForComplete;
        this.setDoc(this);
    }

    public DocumentImpl(boolean pWaitForComplete, int charBufSize) {
        super(charBufSize);
        this.fWaitForComplete = pWaitForComplete;
        this.setDoc(this);
    }

    public DocumentImpl(int charBufSize) {
        super(charBufSize);
        this.setDoc(this);
    }

    DocumentImpl(SourceTreeHandler sth) {
        this.setDoc(this);
        this.m_sourceTreeHandler = sth;
    }

    public DocumentImpl(DocumentType doctype) {
        this.setDoc(this);
        if (null != doctype) {
            this.m_docType = (DocumentTypeImpl)doctype;
        }
    }

    public DocumentType getDoctype() {
        return this.m_docType;
    }

    public void setDoctype(DocumentType docType) {
        this.m_docType = (DocumentTypeImpl)docType;
    }

    public Element getDocumentElement() {
        return this.m_docElement;
    }

    public HashMap getIDAttributes() {
        return this.m_idAttributes;
    }

    public void setIDAttribute(String id, Element elem) {
        this.m_idAttributes.put(id, elem);
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (this.getNodeType() != 11) {
            short type = newChild.getNodeType();
            if (type == 1) {
                if (null != this.m_docElement) {
                    throw new DOMException(3, "DOM006 Hierarchy request error");
                }
                this.m_docElement = (ElementImpl)newChild;
            } else if (type == 10) {
                this.m_docType = (DocumentTypeImpl)newChild;
            }
        }
        return super.appendChild(newChild);
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public String getLocalName() {
        return "#document";
    }

    public Element createElement(String tagName) throws DOMException {
        return new ElementImpl(this, tagName);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this.fWaitForComplete);
    }

    public Text createTextNode(String data) {
        return new TextImpl(this, data);
    }

    public Comment createComment(String data) {
        return new CommentImpl(this, data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return new CDATASectionImpl(this, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return new ProcessingInstructionImpl(this, target, data);
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return super.importNode(importedNode, deep);
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return new ElementImplWithNS(this, namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return super.createAttributeNS(namespaceURI, qualifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElementById(String elementId) {
        Element elem = (Element)this.m_idAttributes.get(elementId);
        if (elem == null && this.m_doc.fWaitForComplete && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        elem = (Element)this.m_idAttributes.get(elementId);
                        if (null == elem) continue;
                        return elem;
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
            elem = (Element)this.m_idAttributes.get(elementId);
        }
        return elem;
    }

    public Node getNextSibling() {
        return null;
    }
}

