/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.stree;

import com.scenari.xsldom.xalan.stree.AttrImpl;
import com.scenari.xsldom.xalan.stree.AttrImplNS;
import com.scenari.xsldom.xalan.stree.Child;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.NameSpaceDecl;
import com.scenari.xsldom.xalan.stree.Parent;
import com.scenari.xsldom.xml.utils.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class ElementImpl
extends Parent
implements Attributes,
NamedNodeMap {
    private String m_name;
    private short m_attrsEnd = 0;
    private AttrImpl m_firstAttr;
    private AttrImpl m_lastAttr;

    public ElementImpl(DocumentImpl doc, String name) {
        super(doc);
        this.m_name = name;
    }

    public ElementImpl(DocumentImpl doc, String name, boolean pComplete) {
        super(doc);
        this.m_name = name;
        this.setComplete(pComplete);
    }

    public ElementImpl(DocumentImpl doc, String name, Attributes atts) {
        super(doc);
        this.m_name = name;
        this.setAttributes(atts);
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.m_name;
    }

    public String getLocalName() {
        return this.m_name;
    }

    public String getTagName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttrImpl getChildAttribute(int i) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (i < 0) {
            return null;
        }
        if (this.m_doc.fWaitForComplete && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
        }
        if (null != this.m_firstAttr) {
            Child next = this.m_firstAttr;
            for (int k = 0; k < i; ++k) {
                if (null == next) {
                    return null;
                }
                next = next.m_next;
            }
            return next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount() {
        if (this.m_doc.fWaitForComplete && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount;
    }

    public NamedNodeMap getAttributes() {
        return this;
    }

    public void setAttribute(String name, String value) throws DOMException {
        AttrImpl vAttr = this.m_firstAttr;
        while (null != vAttr && !vAttr.getNodeName().equals(name)) {
            vAttr = (AttrImpl)vAttr.m_next;
        }
        if (vAttr == null) {
            vAttr = (AttrImpl)this.createAttribute(name);
            if (null == this.m_firstAttr) {
                this.m_firstAttr = vAttr;
            } else {
                this.m_lastAttr.m_next = vAttr;
                vAttr.m_prev = this.m_lastAttr;
            }
            this.m_lastAttr = vAttr;
            vAttr.setUid(this.m_uid);
            vAttr.setParent(this);
            vAttr.setLevel((short)(this.getLevel() + 1));
            this.m_attrsEnd = (short)(this.m_attrsEnd + 1);
        }
        vAttr.setValue(value);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        String vLocalName = qualifiedName;
        int vIdx = vLocalName.indexOf(58);
        if (vIdx > 0) {
            vLocalName = vLocalName.substring(vIdx + 1);
        }
        AttrImpl vAttr = this.m_firstAttr;
        while (null != vAttr) {
            if (vAttr.getLocalName().equals(vLocalName) && vAttr.getNamespaceURI().equals(namespaceURI)) {
                vAttr.setValue(value);
                break;
            }
            vAttr = (AttrImpl)vAttr.m_next;
        }
        if (vAttr == null) {
            vAttr = new AttrImplNS(this.getDocumentImpl(), namespaceURI, vLocalName, qualifiedName, value);
            if (null == this.m_firstAttr) {
                this.m_firstAttr = vAttr;
            } else {
                this.m_lastAttr.m_next = vAttr;
                vAttr.m_prev = this.m_lastAttr;
            }
            this.m_lastAttr = vAttr;
            vAttr.setUid(this.m_uid);
            vAttr.setParent(this);
            vAttr.setLevel((short)(this.getLevel() + 1));
            this.m_attrsEnd = (short)(this.m_attrsEnd + 1);
        }
    }

    public void setAttributes(Attributes atts) throws DOMException {
        for (int i = 0; i < atts.getLength(); ++i) {
            String uri = atts.getURI(i);
            String name = atts.getQName(i);
            if (null != uri || name.indexOf(58) > 0) {
                this.setAttributeNS(uri, name, atts.getValue(i));
                continue;
            }
            this.setAttribute(name, atts.getValue(i));
        }
    }

    public void setIDAttribute(String value) {
        this.getDocumentImpl().setIDAttribute(value, this);
    }

    public Attr createAttribute(String name) throws DOMException {
        AttrImpl attrImpl = QName.isXMLNSDecl(name) ? new NameSpaceDecl(this.getDocumentImpl(), "http://www.w3.org/2000/xmlns/", name, "") : new AttrImpl(this.getDocumentImpl(), name, "");
        return attrImpl;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return new AttrImplNS(this.getDocumentImpl(), namespaceURI, qualifiedName, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttrCount() {
        if (this.m_doc.fWaitForComplete && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_attrsEnd;
    }

    public String getURI(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (null != attr) {
            return attr.getNamespaceURI();
        }
        return null;
    }

    public String getLocalName(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (null != attr) {
            return attr.getLocalName();
        }
        return null;
    }

    public String getQName(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (null != attr) {
            return attr.getNodeName();
        }
        return null;
    }

    public String getType(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (null != attr) {
            return Integer.toString(attr.getNodeType());
        }
        return null;
    }

    public String getValue(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (null != attr) {
            return attr.getValue();
        }
        return null;
    }

    public String getAttribute(String name) {
        return this.getValue(name);
    }

    public String getAttributeNS(String pNs, String pLocalName) {
        return this.getValue(pNs, pLocalName);
    }

    public Attr getAttributeNode(String pName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getNodeName().equals(pName)) continue;
            return attr;
        }
        return null;
    }

    public Attr getAttributeNodeNS(String pNamespaceURI, String pLocalName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getLocalName().equals(pLocalName) || !attr.getNamespaceURI().equals(pNamespaceURI)) continue;
            return attr;
        }
        return null;
    }

    public boolean hasAttribute(String pName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getNodeName().equals(pName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeNS(String pNamespaceURI, String pLocalName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getLocalName().equals(pLocalName) || !attr.getNamespaceURI().equals(pNamespaceURI)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributes() {
        return this.getAttrCount() > 0;
    }

    public int getIndex(String uri, String localPart) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getLocalName().equals(localPart) || !attr.getNamespaceURI().equals(uri)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String rawName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getNodeName().equals(rawName)) continue;
            return i;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getLocalName().equals(localName) || !attr.getNamespaceURI().equals(uri)) continue;
            return Integer.toString(attr.getNodeType());
        }
        return null;
    }

    public String getType(String rawName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getNodeName().equals(rawName)) continue;
            return Integer.toString(attr.getNodeType());
        }
        return null;
    }

    public String getValue(String uri, String localName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getLocalName().equals(localName) || !attr.getNamespaceURI().equals(uri)) continue;
            return attr.getValue();
        }
        return null;
    }

    public String getValue(String rawName) {
        for (int i = 0; i < this.getAttrCount(); ++i) {
            AttrImpl attr = this.getChildAttribute(i);
            if (!attr.getNodeName().equals(rawName)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Node getNamedItem(String name) {
        return this.getChildAttribute(this.getIndex(name));
    }

    public Node setNamedItem(Node arg) throws DOMException {
        this.setAttribute(((Attr)arg).getName(), ((Attr)arg).getValue());
        return this.getChildAttribute(this.getIndex(((Attr)arg).getName()));
    }

    public Node removeNamedItem(String name) throws DOMException {
        int index = this.getIndex(name);
        return this.removeItem(index);
    }

    public Node removeItem(int index) throws DOMException {
        AttrImpl attr = this.m_firstAttr;
        int pos = 0;
        while (null != attr) {
            if (pos == index) {
                if (null != attr.m_prev) {
                    attr.m_prev.m_next = attr.m_next;
                }
                if (null != this.m_next) {
                    attr.m_next.m_prev = attr.m_prev;
                }
                attr.m_next = null;
                attr.m_prev = null;
                return attr;
            }
            attr = (AttrImpl)attr.m_next;
            ++pos;
        }
        return null;
    }

    public void removeAttribute(String pName) throws DOMException {
        AttrImpl vAttr = this.m_firstAttr;
        while (vAttr != null) {
            if (vAttr.getName().equals(pName)) {
                if (vAttr.m_prev != null) {
                    vAttr.m_prev.m_next = vAttr.m_next;
                } else {
                    this.m_firstAttr = (AttrImpl)vAttr.m_next;
                }
                if (vAttr.m_next != null) {
                    vAttr.m_next.m_prev = vAttr.m_prev;
                } else {
                    this.m_lastAttr = (AttrImpl)vAttr.m_prev;
                }
                this.m_attrsEnd = (short)(this.m_attrsEnd - 1);
                return;
            }
            vAttr = (AttrImpl)vAttr.m_next;
        }
    }

    public int getLength() {
        return this.getAttrCount();
    }

    public Node item(int index) {
        return this.getChildAttribute(index);
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        return this.getChildAttribute(this.getIndex(namespaceURI, localName));
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        this.setAttributeNS(((Attr)arg).getNamespaceURI(), ((Attr)arg).getName(), ((Attr)arg).getValue());
        return this.getChildAttribute(this.getIndex(((Attr)arg).getNamespaceURI(), ((Attr)arg).getName()));
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        int index = this.getIndex(namespaceURI, localName);
        return this.removeItem(index);
    }

    protected void initDyn(int pIndex, short pLevel) {
        this.m_uid = pIndex;
        this.m_level = pLevel;
        Child vCh = this.m_first;
        short vChLevel = (short)(pLevel + 1);
        while (vCh != null) {
            vCh.initDyn(pIndex, vChLevel);
            vCh = vCh.m_next;
        }
        Child vAtt = this.m_firstAttr;
        while (vAtt != null) {
            vAtt.initDyn(pIndex, vChLevel);
            vAtt = vAtt.m_next;
        }
    }
}

