/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.stree;

import com.scenari.xsldom.xalan.stree.Child;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.ElementImpl;
import com.scenari.xsldom.xalan.stree.SaxEventDispatch;
import com.scenari.xsldom.xalan.stree.SourceTreeHandler;
import com.scenari.xsldom.xalan.templates.StylesheetRoot;
import com.scenari.xsldom.xalan.templates.WhiteSpaceInfo;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.WrappedRuntimeException;
import com.scenari.xsldom.xpath.XPathContext;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Parent
extends Child {
    protected int m_childCount = 0;
    protected boolean m_isComplete;
    protected Child m_last;
    protected Child m_first;

    public Parent(DocumentImpl doc) {
        super(doc);
        this.m_isComplete = doc != null ? doc.m_isComplete : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount() {
        if (this.m_doc.fWaitForComplete && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildNodes() {
        if (0 != this.m_childCount) {
            return true;
        }
        if (this.m_doc.fWaitForComplete && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (0 == this.m_childCount) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
        }
        return 0 != this.m_childCount;
    }

    public int getChildUID(int pos) {
        Child child = this.getChild(pos);
        return null != child ? child.getUid() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Child getChild(int i) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (i < 0) {
            return null;
        }
        if (i >= this.m_childCount && this.m_doc.fWaitForComplete && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (i >= this.m_childCount) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
        }
        if (i < this.m_childCount) {
            Child child = this.m_first;
            int pos = 0;
            while (null != child) {
                if (pos == i) {
                    return child;
                }
                child = child.m_next;
                ++pos;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getFirstChild() {
        if (null != this.m_first) {
            return this.m_first;
        }
        if (this.m_doc.fWaitForComplete && !this.m_isComplete) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        if (null == this.m_first) continue;
                        return this.m_first;
                    }
                }
                catch (InterruptedException e) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_first;
    }

    public Node getLastChild() {
        try {
            return this.getChild(this.getChildCount() - 1);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public Node appendChild(Node newChild) throws DOMException {
        TransformerImpl transformer;
        DocumentImpl vDoc;
        SourceTreeHandler sh;
        Child vChild = (Child)newChild;
        if (vChild.getNodeType() == 11) {
            Node vCh;
            for (vCh = vChild.getFirstChild(); vCh != null; vCh = vCh.getNextSibling()) {
                this.appendChild(vCh);
            }
            return vCh;
        }
        if (vChild.m_parent != null) {
            vChild.m_parent.removeChild(vChild);
        }
        vChild.m_parent = this;
        ++this.m_childCount;
        if (0 == vChild.m_uid) {
            int vUid;
            if (!this.m_isComplete) {
                vUid = ++this.m_doc.m_docOrderCount;
            } else if (this.getLastChild() != null) {
                Node vCh = this.getLastChild();
                while (vCh.getLastChild() != null) {
                    vCh = vCh.getLastChild();
                }
                vUid = ((Child)vCh).getUid();
            } else {
                vUid = this.getUid();
            }
            vChild.initDyn(vUid, (short)(this.m_level + 1));
        }
        if (null == this.m_first) {
            this.m_first = vChild;
        } else {
            vChild.m_prev = this.m_last;
            this.m_last.m_next = vChild;
        }
        this.m_last = vChild;
        if (1 == vChild.getNodeType() && null != (sh = (vDoc = this.m_doc).getSourceTreeHandler()) && sh.m_shouldCheckWhitespace && null != (transformer = sh.getTransformerImpl())) {
            StylesheetRoot stylesheet = transformer.getStylesheet();
            try {
                WhiteSpaceInfo info;
                ElementImpl elem = (ElementImpl)vChild;
                if (null == vDoc.m_xpathContext) {
                    vDoc.m_xpathContext = new XPathContext(vDoc);
                }
                boolean shouldStrip = null == (info = stylesheet.getWhiteSpaceInfo(vDoc.m_xpathContext, elem)) ? sh.getShouldStripWhitespace() : info.getShouldStripSpace();
                sh.setShouldStripWhitespace(shouldStrip);
            }
            catch (TransformerException se) {
                // empty catch block
            }
        }
        return newChild;
    }

    public Node insertBefore(Node pNewChild, Node pRefChild) throws DOMException {
        int vPrevId;
        Child vChild = (Child)pNewChild;
        if (vChild.m_parent != null) {
            vChild.m_parent.removeChild(vChild);
        }
        vChild.m_parent = this;
        ++this.m_childCount;
        if (pRefChild != null) {
            vPrevId = ((Child)pRefChild).getUid();
        } else if (this.getLastChild() != null) {
            Node vCh = this.getLastChild();
            while (vCh.getLastChild() != null) {
                vCh = vCh.getLastChild();
            }
            vPrevId = ((Child)vCh).getUid();
        } else {
            vPrevId = this.getUid();
        }
        vChild.initDyn(vPrevId, (short)(this.m_level + 1));
        if (pRefChild != null) {
            Child vNext = (Child)pRefChild;
            if (vNext.m_parent != this) {
                throw new DOMException(8, "vParent.insertBefore(pNew, pNextSibling) with pNextSibling not children of vParent.");
            }
            vChild.m_next = vNext;
            vChild.m_prev = vNext.m_prev;
            vNext.m_prev = vChild;
        } else {
            vChild.m_prev = this.m_last;
            this.m_last.m_next = vChild;
            this.m_last = vChild;
        }
        if (vChild.m_prev == null) {
            this.m_first = vChild;
        } else {
            vChild.m_prev.m_next = vChild;
        }
        return pNewChild;
    }

    public boolean isComplete() {
        if (!this.m_isComplete && null != this.m_doc.m_exceptionThrown) {
            this.throwParseError(this.m_doc.m_exceptionThrown);
        }
        return this.m_isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.m_isComplete = isComplete;
    }

    protected void throwParseError(Exception e) {
        this.m_isComplete = true;
        super.throwParseError(e);
    }

    public void dispatchCharactersEvent(ContentHandler ch) throws SAXException {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            short t = child.getNodeType();
            if (8 == t || 7 == t) continue;
            ((SaxEventDispatch)((Object)child)).dispatchCharactersEvent(ch);
        }
    }

    protected void initDyn(int pIndex, short pLevel) {
        this.m_uid = pIndex;
        this.m_level = pLevel;
        Child vCh = this.m_first;
        short vChLevel = (short)(pLevel + 1);
        while (vCh != null) {
            vCh.initDyn(pIndex, vChLevel);
            vCh = vCh.m_next;
        }
    }

    public Node removeChild(Node pOldChild) throws DOMException {
        if (pOldChild.getParentNode() != this) {
            throw new DOMException(8, "");
        }
        Child vCh = (Child)pOldChild;
        if (vCh.m_prev == null) {
            this.m_first = vCh.m_next;
        } else {
            vCh.m_prev.m_next = vCh.m_next;
        }
        if (vCh.m_next == null) {
            this.m_last = vCh.m_prev;
        } else {
            vCh.m_next.m_prev = vCh.m_prev;
        }
        vCh.m_parent = null;
        vCh.m_next = null;
        vCh.m_prev = null;
        vCh.initDyn(0, (short)0);
        --this.m_childCount;
        return pOldChild;
    }
}

