/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.stree;

import com.scenari.xsldom.xalan.stree.DocImpl;
import com.scenari.xsldom.xalan.stree.DocumentFragmentImpl;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.DocumentTypeImpl;
import com.scenari.xsldom.xalan.stree.EntityImpl;
import com.scenari.xsldom.xalan.stree.Parent;
import com.scenari.xsldom.xalan.stree.StreeDOMBuilder;
import com.scenari.xsldom.xalan.stree.StreeDOMHelper;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.BoolStack;
import com.scenari.xsldom.xml.utils.DOMBuilder;
import com.scenari.xsldom.xml.utils.SystemIDResolver;
import com.scenari.xsldom.xpath.SourceTreeManager;
import com.scenari.xsldom.xpath.XPathContext;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SourceTreeHandler
extends DefaultHandler
implements TransformerHandler,
DeclHandler,
DTDHandler {
    TransformerImpl m_transformer;
    private DOMBuilder m_sourceTreeHandler;
    private DocImpl m_root;
    private DocumentFragment m_docFrag;
    private boolean m_initedRoot;
    boolean m_shouldCheckWhitespace = false;
    boolean m_shouldTransformAtEnd = true;
    private Source m_inputSource;
    private boolean m_useMultiThreading = false;
    private int m_entryCount = 0;
    private static final boolean DEBUG = false;
    private boolean indexedLookup = false;
    private int m_eventsCount = 0;
    private int m_maxEventsToNotify = 18;
    private boolean m_isCData = false;
    private boolean m_inDTD = false;
    private boolean m_shouldStripWS = false;
    private BoolStack m_shouldStripWhitespaceStack = new BoolStack();

    public SourceTreeHandler(TransformerImpl transformer) {
        this(transformer, false);
    }

    public SourceTreeHandler(TransformerImpl transformer, boolean doFragment) {
        this.m_transformer = transformer;
        XPathContext xctxt = transformer.getXPathContext();
        if (xctxt.getDOMHelper() instanceof StreeDOMHelper) {
            xctxt.setDOMHelper(new StreeDOMHelper());
        }
        if (doFragment) {
            this.m_root = new DocumentFragmentImpl(1024);
            this.m_docFrag = (DocumentFragmentImpl)this.m_root;
        } else {
            this.m_root = new DocumentImpl(this);
        }
        this.m_initedRoot = false;
        this.m_shouldCheckWhitespace = transformer.getStylesheet().shouldCheckWhitespace();
    }

    public SourceTreeHandler() {
        this.m_root = new DocumentImpl(this);
        this.m_initedRoot = false;
    }

    public void setShouldTransformAtEnd(boolean b) {
        this.m_shouldTransformAtEnd = b;
    }

    public Node getRoot() {
        return this.m_root;
    }

    public void setRoot(DocImpl root) {
        this.m_root = root;
    }

    public void setExceptionThrown(Exception e) {
        this.m_root.m_exceptionThrown = e;
    }

    public void setInputSource(Source source) {
        this.m_inputSource = source;
    }

    public Source getInputSource() {
        return this.m_inputSource;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setUseMultiThreading(boolean b) {
        this.m_useMultiThreading = b;
    }

    public boolean getUseMultiThreading() {
        return this.m_useMultiThreading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters() {
        if (this.m_useMultiThreading && this.m_eventsCount >= this.m_maxEventsToNotify) {
            DocImpl synchObj;
            DocImpl docImpl = synchObj = this.m_root;
            synchronized (docImpl) {
                synchObj.notify();
            }
            this.m_eventsCount = 0;
        } else {
            ++this.m_eventsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDocument() throws SAXException {
        if (this.m_entryCount != 0) {
            throw new SAXException("startDocument can not be called while within startDocument/endDocument! Threading problem?");
        }
        ++this.m_entryCount;
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_inDTD = false;
            this.m_root.setSourceTreeHandler(this);
            this.m_root.setUid(1);
            this.m_root.setLevel(new Integer(1).shortValue());
            this.m_root.setUseMultiThreading(this.getUseMultiThreading());
            this.m_sourceTreeHandler = null != this.m_docFrag ? new StreeDOMBuilder((Document)this.m_root, this.m_docFrag) : (this.m_root.getNodeType() == 11 ? new StreeDOMBuilder(this.m_root.getOwnerDocument(), (DocumentFragment)((Object)this.m_root)) : new StreeDOMBuilder(this.m_root));
            this.pushShouldStripWhitespace(false);
            this.m_sourceTreeHandler.startDocument();
        }
        if (this.m_useMultiThreading && null != this.m_transformer && this.m_transformer.isParserEventsOnMain()) {
            ContentHandler resultContentHandler = this.m_transformer.getContentHandler();
            if (null != resultContentHandler && resultContentHandler instanceof SourceTreeHandler) {
                Properties myProps = this.m_transformer.getOutputProperties();
                SourceTreeHandler resultHandler = (SourceTreeHandler)resultContentHandler;
                Transformer resultTransformer = resultHandler.getTransformer();
                Properties resultProps = resultTransformer.getOutputProperties();
                Enumeration<Object> myKeys = myProps.keys();
                while (myKeys.hasMoreElements()) {
                    Object key = myKeys.nextElement();
                    if (null != resultProps.get(key)) continue;
                    resultProps.put(key, myProps.get(key));
                }
                resultTransformer.setOutputProperties(resultProps);
            }
            if (null != this.m_docFrag) {
                this.m_transformer.setSourceTreeDocForThread(this.m_docFrag);
            } else {
                this.m_transformer.setSourceTreeDocForThread(this.m_root);
            }
            int cpriority = Thread.currentThread().getPriority();
            this.m_transformer.runTransformThread(cpriority);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        DocImpl synchObj;
        this.m_eventsCount = this.m_maxEventsToNotify;
        DocImpl docImpl = synchObj = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.endDocument();
            this.m_root.setComplete(true);
            this.popShouldStripWhitespace();
            if (!this.m_useMultiThreading && null != this.m_transformer && this.m_shouldTransformAtEnd) {
                try {
                    this.m_transformer.transformNode(this.m_root);
                }
                catch (TransformerException te) {
                    throw new SAXException(te);
                }
            }
        }
        this.m_eventsCount = this.m_maxEventsToNotify;
        this.notifyWaiters();
        if (this.m_useMultiThreading && null != this.m_transformer) {
            this.m_transformer.waitTransformThread();
        }
        --this.m_entryCount;
    }

    private void printTree(Node n) {
        System.out.println("node: " + n.getNodeName());
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.printTree(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_shouldStripWhitespaceStack.push(this.m_shouldStripWS);
            this.m_sourceTreeHandler.startElement(ns, localName, name, atts);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String ns, String localName, String name) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            Parent myElement = (Parent)this.m_sourceTreeHandler.getCurrentNode();
            this.m_sourceTreeHandler.endElement(ns, localName, name);
            myElement.setComplete(true);
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
        this.notifyWaiters();
    }

    public void startCDATA() throws SAXException {
        this.m_isCData = true;
    }

    public void endCDATA() throws SAXException {
        this.m_isCData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.characters(ch, start, length);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.charactersRaw(ch, start, length);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            if (this.m_shouldStripWS) {
                return;
            }
            this.m_sourceTreeHandler.characters(ch, start, length);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processingInstruction(String target, String data) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.processingInstruction(target, data);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.comment(ch, start, length);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEntity(String name) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.startEntity(name);
        }
        this.notifyWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endEntity(String name) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.endEntity(name);
        }
        this.notifyWaiters();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.m_inDTD = true;
        if (this.m_root instanceof DocumentImpl) {
            DocumentImpl doc = (DocumentImpl)this.m_root;
            DocumentTypeImpl dtd = new DocumentTypeImpl(doc, name, publicId, systemId);
            ((DocumentImpl)this.m_root).setDoctype(dtd);
        }
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.m_sourceTreeHandler.endPrefixMapping(prefix);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS;
    }

    void pushShouldStripWhitespace(boolean shouldStrip) {
        this.m_shouldStripWS = shouldStrip;
        this.m_shouldStripWhitespaceStack.push(shouldStrip);
    }

    void popShouldStripWhitespace() {
        this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
    }

    void setShouldStripWhitespace(boolean shouldStrip) {
        this.m_shouldStripWS = shouldStrip;
        this.m_shouldStripWhitespaceStack.setTop(shouldStrip);
    }

    public void setResult(Result result) throws IllegalArgumentException {
        if (null == result) {
            throw new IllegalArgumentException("result should not be null");
        }
        try {
            ContentHandler handler = this.m_transformer.createResultContentHandler(result);
            this.m_transformer.setContentHandler(handler);
        }
        catch (TransformerException te) {
            throw new IllegalArgumentException("result could not be set");
        }
    }

    public void setSystemId(String baseID) {
        this.m_transformer.setBaseURLOfSource(baseID);
        XPathContext xctxt = this.m_transformer.getXPathContext();
        SourceTreeManager stm = xctxt.getSourceTreeManager();
        this.m_inputSource = new StreamSource(baseID);
        stm.putDocumentInCache(this.m_root, this.m_inputSource);
    }

    public String getSystemId() {
        return this.m_transformer.getBaseURLOfSource();
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    TransformerImpl getTransformerImpl() {
        return this.m_transformer;
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        try {
            if (null != this.m_inputSource) {
                systemId = SystemIDResolver.getAbsoluteURI(systemId, this.m_inputSource.getSystemId());
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        EntityImpl entity = new EntityImpl(name, notationName, publicId, systemId);
        this.m_root.getDoctype().getEntities().setNamedItem(entity);
    }
}

