/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.stree;

import com.scenari.xsldom.xalan.stree.CommentImpl;
import com.scenari.xsldom.xalan.stree.DocImpl;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.ElementImpl;
import com.scenari.xsldom.xalan.stree.Parent;
import com.scenari.xsldom.xalan.stree.TextImpl;
import com.scenari.xsldom.xml.utils.DOMBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StreeDOMBuilder
extends DOMBuilder {
    TextImpl m_text_buffer = null;
    protected DocumentImpl m_docImpl;
    private boolean m_previousIsText = false;
    private static final boolean DEBUG = false;

    public StreeDOMBuilder(Document doc, Node node) {
        super(doc, node);
        this.m_docImpl = (DocumentImpl)doc;
    }

    public StreeDOMBuilder(Document doc, DocumentFragment docFrag) {
        super(doc, docFrag);
        this.m_docImpl = (DocumentImpl)doc;
    }

    public StreeDOMBuilder(Document doc) {
        super(doc);
        this.m_docImpl = (DocumentImpl)doc;
    }

    public void setIDAttribute(String id, Element elem) {
        this.m_docImpl.setIDAttribute(id, elem);
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        this.setPreviousIsText(false);
        ElementImpl elem = null == ns || ns.length() == 0 ? (ElementImpl)this.m_doc.createElement(name) : (ElementImpl)this.m_doc.createElementNS(ns, name);
        elem.m_uid = ++((DocImpl)this.m_doc).m_docOrderCount;
        elem.m_level = (short)(((Parent)(this.m_currentNode == null ? this.m_doc : this.m_currentNode)).m_level + 1);
        int nAtts = atts.getLength();
        if (0 != nAtts) {
            for (int i = 0; i < nAtts; ++i) {
                String attrNS;
                if (atts.getType(i).equalsIgnoreCase("ID")) {
                    this.setIDAttribute(atts.getValue(i), elem);
                }
                if ((attrNS = atts.getURI(i)) == null) {
                    attrNS = "";
                }
                if (attrNS.length() == 0 || atts.getQName(i).startsWith("xmlns:")) {
                    elem.setAttribute(atts.getQName(i), atts.getValue(i));
                    continue;
                }
                elem.setAttributeNS(attrNS, atts.getQName(i), atts.getValue(i));
            }
        }
        this.append(elem);
        this.m_elemStack.push(elem);
        this.m_currentNode = elem;
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        this.setPreviousIsText(false);
        super.endElement(ns, localName, name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.getPreviousIsText()) {
            this.appendAccumulatedText(this.m_text_buffer, ch, start, length);
        } else {
            this.m_text_buffer = new TextImpl(this.m_docImpl, ch, start, length);
            this.setPreviousIsText(true);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.getPreviousIsText()) {
            this.appendAccumulatedText(this.m_text_buffer, ch, start, length);
        } else {
            this.m_text_buffer = new TextImpl(this.m_docImpl, ch, start, length);
        }
        this.setPreviousIsText(true);
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        this.setPreviousIsText(false);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(new TextImpl(this.m_docImpl, ch, start, length));
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.setPreviousIsText(false);
        this.append(new CommentImpl(this.m_docImpl, ch, start, length));
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.setPreviousIsText(false);
        super.processingInstruction(target, data);
    }

    public void setPreviousIsText(boolean isText) throws SAXException {
        if (this.m_previousIsText && !isText) {
            if (this.m_docImpl.m_sourceTreeHandler != null) {
                if (!this.m_docImpl.m_sourceTreeHandler.getShouldStripWhitespace() || !this.m_text_buffer.isWhitespace()) {
                    this.append(this.m_text_buffer);
                }
            } else {
                this.append(this.m_text_buffer);
            }
            this.m_text_buffer = null;
        }
        this.m_previousIsText = isText;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.setPreviousIsText(false);
    }

    boolean getPreviousIsText() {
        return this.m_previousIsText;
    }

    void appendAccumulatedText(Node currentNode, char[] ch, int start, int length) throws SAXException {
        if (this.m_text_buffer == null) {
            this.m_text_buffer = new TextImpl(this.m_docImpl, ch, start, length);
            this.setPreviousIsText(true);
        } else {
            this.m_text_buffer.appendText(ch, start, length);
        }
    }
}

