/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.templates;

import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xalan.templates.NamespaceAlias;
import com.scenari.xsldom.xalan.templates.Stylesheet;
import com.scenari.xsldom.xalan.templates.StylesheetComposed;
import com.scenari.xsldom.xalan.templates.StylesheetRoot;
import com.scenari.xsldom.xalan.templates.XMLNSDecl;
import com.scenari.xsldom.xalan.transformer.ResultTreeHandler;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.UnImplNode;
import com.scenari.xsldom.xpath.WhitespaceStrippingElementMatcher;
import com.scenari.xsldom.xpath.XPathContext;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ElemTemplateElement
extends UnImplNode
implements PrefixResolver,
Serializable,
SourceLocator,
WhitespaceStrippingElementMatcher {
    private int m_lineNumber;
    private int m_columnNumber;
    private boolean m_defaultSpace = true;
    private Vector m_declaredPrefixes;
    Vector m_prefixTable;
    protected int m_docOrderNumber = -1;
    protected ElemTemplateElement m_parentNode;
    ElemTemplateElement m_nextSibling;
    ElemTemplateElement m_firstChild;
    private transient Node m_DOMBackPointer;

    public boolean isCompiledTemplate() {
        return false;
    }

    public int getXSLToken() {
        return -1;
    }

    public String getNodeName() {
        return "Unknown XSLT Element";
    }

    public void runtimeInit(TransformerImpl transformer) throws TransformerException {
    }

    public void execute(TransformerImpl transformer, Node sourceNode, QName mode) throws TransformerException {
    }

    public StylesheetComposed getStylesheetComposed() {
        return this.m_parentNode.getStylesheetComposed();
    }

    public Stylesheet getStylesheet() {
        return this.m_parentNode.getStylesheet();
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_parentNode.getStylesheetRoot();
    }

    public void recompose(StylesheetRoot root) throws TransformerException {
    }

    public void compose() throws TransformerException {
        this.resolvePrefixTables();
    }

    protected boolean isValidNCName(String s) {
        int len = s.length();
        char c = s.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        if (len > 0) {
            for (int i = 1; i < len; ++i) {
                c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.') continue;
                return false;
            }
        }
        return true;
    }

    public void error(int msg, Object[] args) {
        String themsg = XSLMessages.createMessage(msg, args);
        this.error(XSLMessages.createMessage(19, new Object[]{themsg}));
    }

    public void error(String msg) {
        throw new RuntimeException(msg);
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (null == newChild) {
            this.error(20, null);
        }
        ElemTemplateElement elem = (ElemTemplateElement)newChild;
        if (null == this.m_firstChild) {
            this.m_firstChild = elem;
        } else {
            ElemTemplateElement last = (ElemTemplateElement)this.getLastChild();
            last.m_nextSibling = elem;
        }
        elem.m_parentNode = this;
        return newChild;
    }

    public boolean hasChildNodes() {
        return null != this.m_firstChild;
    }

    public short getNodeType() {
        return 1;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node removeChild(ElemTemplateElement childETE) throws DOMException {
        if (childETE == null || childETE.m_parentNode != this) {
            return null;
        }
        if (childETE == this.m_firstChild) {
            this.m_firstChild = childETE.m_nextSibling;
        } else {
            ElemTemplateElement prev = (ElemTemplateElement)childETE.getPreviousSibling();
            prev.m_nextSibling = childETE.m_nextSibling;
        }
        childETE.m_parentNode = null;
        childETE.m_nextSibling = null;
        return childETE;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (oldChild == null || oldChild.getParentNode() != this) {
            return null;
        }
        ElemTemplateElement newChildElem = (ElemTemplateElement)newChild;
        ElemTemplateElement oldChildElem = (ElemTemplateElement)oldChild;
        ElemTemplateElement prev = (ElemTemplateElement)oldChildElem.getPreviousSibling();
        if (null != prev) {
            prev.m_nextSibling = newChildElem;
        }
        if (this.m_firstChild == oldChildElem) {
            this.m_firstChild = newChildElem;
        }
        newChildElem.m_parentNode = this;
        oldChildElem.m_parentNode = null;
        newChildElem.m_nextSibling = oldChildElem.m_nextSibling;
        oldChildElem.m_nextSibling = null;
        return newChildElem;
    }

    public int getLength() {
        int count = 0;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            ++count;
            node = node.m_nextSibling;
        }
        return count;
    }

    public Node item(int index) {
        ElemTemplateElement node = this.m_firstChild;
        for (int i = 0; i < index && node != null; ++i) {
            node = node.m_nextSibling;
        }
        return node;
    }

    public Document getOwnerDocument() {
        return this.getStylesheet();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public String getBaseIdentifier() {
        return this.getSystemId();
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public String getPublicId() {
        return null != this.m_parentNode ? this.m_parentNode.getPublicId() : null;
    }

    public String getSystemId() {
        return this.getStylesheet().getHref();
    }

    public void setLocaterInfo(SourceLocator locator) {
        this.m_lineNumber = locator.getLineNumber();
        this.m_columnNumber = locator.getColumnNumber();
    }

    public void setXmlSpace(int v) {
        this.m_defaultSpace = 2 == v;
    }

    public boolean getXmlSpace() {
        return this.m_defaultSpace;
    }

    public Vector getDeclaredPrefixes() {
        return this.m_declaredPrefixes;
    }

    public void setPrefixes(NamespaceSupport nsSupport) throws TransformerException {
        this.setPrefixes(nsSupport, false);
    }

    public void setPrefixes(NamespaceSupport nsSupport, boolean excludeXSLDecl) throws TransformerException {
        Enumeration<String> decls = nsSupport.getDeclaredPrefixes();
        while (decls.hasMoreElements()) {
            String prefix = decls.nextElement();
            if (null == this.m_declaredPrefixes) {
                this.m_declaredPrefixes = new Vector();
            }
            String uri = nsSupport.getURI(prefix);
            if (excludeXSLDecl && uri.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            XMLNSDecl decl = new XMLNSDecl(prefix, uri, false);
            this.m_declaredPrefixes.addElement(decl);
        }
    }

    public String getNamespaceForPrefix(String prefix, Node context) {
        this.error(16, null);
        return null;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        Vector nsDecls = this.m_declaredPrefixes;
        if (null != nsDecls) {
            int n = nsDecls.size();
            for (int i = 0; i < n; ++i) {
                XMLNSDecl decl = (XMLNSDecl)nsDecls.elementAt(i);
                if (!prefix.equals(decl.getPrefix())) continue;
                return decl.getURI();
            }
        }
        if (null != this.m_parentNode) {
            return this.m_parentNode.getNamespaceForPrefix(prefix);
        }
        return null;
    }

    public Vector getPrefixes() {
        return this.m_prefixTable;
    }

    public boolean containsExcludeResultPrefix(String prefix) {
        ElemTemplateElement parent = this.getParentElem();
        if (null != parent) {
            return parent.containsExcludeResultPrefix(prefix);
        }
        return false;
    }

    private boolean excludeResultNSDecl(String prefix, String uri) throws TransformerException {
        if (uri != null) {
            if (uri.equals("http://www.w3.org/1999/XSL/Transform") || this.getStylesheet().containsExtensionElementURI(uri) || uri.equals("http://xml.apache.org/xslt")) {
                return true;
            }
            if (this.containsExcludeResultPrefix(prefix)) {
                return true;
            }
        }
        return false;
    }

    public void resolvePrefixTables() throws TransformerException {
        ElemTemplateElement parent;
        this.m_prefixTable = null;
        if (null != this.m_declaredPrefixes) {
            StylesheetRoot stylesheet = this.getStylesheetRoot();
            int n = this.m_declaredPrefixes.size();
            for (int i = 0; i < n; ++i) {
                NamespaceAlias nsAlias;
                XMLNSDecl decl = (XMLNSDecl)this.m_declaredPrefixes.elementAt(i);
                String prefix = decl.getPrefix();
                String uri = decl.getURI();
                if (null == uri) {
                    uri = "";
                }
                boolean shouldExclude = this.excludeResultNSDecl(prefix, uri);
                if (null == this.m_prefixTable) {
                    this.m_prefixTable = new Vector();
                }
                decl = null != (nsAlias = stylesheet.getNamespaceAliasComposed(uri)) ? new XMLNSDecl(nsAlias.getStylesheetPrefix(), nsAlias.getResultNamespace(), shouldExclude) : new XMLNSDecl(prefix, uri, shouldExclude);
                this.m_prefixTable.addElement(decl);
            }
        }
        if (null != (parent = (ElemTemplateElement)this.getParentNode())) {
            Vector prefixes = parent.m_prefixTable;
            if (null == this.m_prefixTable && !this.needToCheckExclude()) {
                this.m_prefixTable = parent.m_prefixTable;
            } else {
                int n = prefixes.size();
                for (int i = 0; i < n; ++i) {
                    XMLNSDecl decl = (XMLNSDecl)prefixes.elementAt(i);
                    boolean shouldExclude = this.excludeResultNSDecl(decl.getPrefix(), decl.getURI());
                    if (shouldExclude != decl.getIsExcluded()) {
                        decl = new XMLNSDecl(decl.getPrefix(), decl.getURI(), shouldExclude);
                    }
                    this.m_prefixTable.addElement(decl);
                }
            }
        } else if (null == this.m_prefixTable) {
            this.m_prefixTable = new Vector();
        }
    }

    boolean needToCheckExclude() {
        return false;
    }

    void executeNSDecls(TransformerImpl transformer) throws TransformerException {
        try {
            if (null != this.m_prefixTable) {
                ResultTreeHandler rhandler = transformer.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                for (int i = n - 1; i >= 0; --i) {
                    XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
                    if (decl.getIsExcluded()) continue;
                    rhandler.startPrefixMapping(decl.getPrefix(), decl.getURI(), true, false);
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    void unexecuteNSDecls(TransformerImpl transformer) throws TransformerException {
        try {
            if (null != this.m_prefixTable) {
                ResultTreeHandler rhandler = transformer.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                for (int i = 0; i < n; ++i) {
                    XMLNSDecl decl = (XMLNSDecl)this.m_prefixTable.elementAt(i);
                    if (decl.getIsExcluded()) continue;
                    rhandler.endPrefixMapping(decl.getPrefix());
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public void setUid(int i) {
        this.m_docOrderNumber = i;
    }

    public int getUid() {
        return this.m_docOrderNumber;
    }

    public Node getParentNode() {
        return this.m_parentNode;
    }

    public ElemTemplateElement getParentElem() {
        return this.m_parentNode;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public Node getPreviousSibling() {
        Node walker = this.getParentNode();
        Node prev = null;
        if (walker != null) {
            for (walker = walker.getFirstChild(); walker != null; walker = walker.getNextSibling()) {
                if (walker == this) {
                    return prev;
                }
                prev = walker;
            }
        }
        return null;
    }

    public ElemTemplateElement getNextSiblingElem() {
        return this.m_nextSibling;
    }

    public Node getFirstChild() {
        return this.m_firstChild;
    }

    public ElemTemplateElement getFirstChildElem() {
        return this.m_firstChild;
    }

    public Node getLastChild() {
        ElemTemplateElement lastChild = null;
        ElemTemplateElement node = this.m_firstChild;
        while (node != null) {
            lastChild = node;
            node = node.m_nextSibling;
        }
        return lastChild;
    }

    public Node getDOMBackPointer() {
        return this.m_DOMBackPointer;
    }

    public void setDOMBackPointer(Node n) {
        this.m_DOMBackPointer = n;
    }

    public int compareTo(Object o) throws ClassCastException {
        ElemTemplateElement ro = (ElemTemplateElement)o;
        int roPrecedence = ro.getStylesheetComposed().getImportCountComposed();
        int myPrecedence = this.getStylesheetComposed().getImportCountComposed();
        if (myPrecedence < roPrecedence) {
            return -1;
        }
        if (myPrecedence > roPrecedence) {
            return 1;
        }
        return this.getUid() - ro.getUid();
    }

    public boolean shouldStripWhiteSpace(XPathContext support, Element targetElement) throws TransformerException {
        StylesheetRoot sroot = this.getStylesheetRoot();
        return null != sroot ? sroot.shouldStripWhiteSpace(support, targetElement) : false;
    }

    public boolean canStripWhiteSpace() {
        StylesheetRoot sroot = this.getStylesheetRoot();
        return null != sroot ? sroot.canStripWhiteSpace() : false;
    }
}

