/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.templates;

import com.scenari.xsldom.xalan.serialize.Encodings;
import com.scenari.xsldom.xalan.templates.ElemTemplateElement;
import com.scenari.xsldom.xalan.templates.StylesheetRoot;
import com.scenari.xsldom.xml.utils.FastStringBuilder;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.WrappedRuntimeException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class OutputProperties
extends ElemTemplateElement
implements Cloneable {
    static final String S_XSLT_PREFIX = "xslt.output.";
    static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    static final String S_XALAN_PREFIX = "com.scenari.xsldom.xslt.";
    static final int S_XALAN_PREFIX_LEN = "com.scenari.xsldom.xslt.".length();
    static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private transient Hashtable m_propertiesLevels;
    private Properties m_properties = null;
    public static String S_KEY_INDENT_AMOUNT;
    public static String S_KEY_CONTENT_HANDLER;
    public static String S_KEY_ENTITIES;
    public static String S_USE_URL_ESCAPING;
    private static Integer m_synch_object;
    private static final Class[] NO_CLASSES;
    private static final Object[] NO_OBJS;

    public OutputProperties() {
        this("xml");
    }

    public OutputProperties(Properties defaults) {
        this.m_properties = new Properties(defaults);
    }

    public OutputProperties(String method) {
        this.m_properties = new Properties(OutputProperties.getDefaultMethodProperties(method));
    }

    private static String fixupPropertyString(String s, boolean doClipping) {
        int index;
        if (doClipping && s.startsWith(S_XSLT_PREFIX)) {
            s = s.substring(S_XSLT_PREFIX_LEN);
        }
        if (s.startsWith(S_XALAN_PREFIX)) {
            s = S_BUILTIN_EXTENSIONS_UNIVERSAL + s.substring(S_XALAN_PREFIX_LEN);
        }
        if ((index = s.indexOf("\\u003a")) > 0) {
            String temp = s.substring(index + 6);
            s = s.substring(0, index) + ":" + temp;
        }
        return s;
    }

    private static Properties loadPropertiesFile(String resourceName, Properties defaults) throws IOException {
        Properties props = new Properties(defaults);
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            try {
                Method getCCL = Thread.class.getMethod("getContextClassLoader", NO_CLASSES);
                if (getCCL != null) {
                    ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), NO_OBJS);
                    is = contextClassLoader.getResourceAsStream("com/scenari/xsldom/xalan/templates/" + resourceName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (is == null) {
                is = OutputProperties.class.getResourceAsStream(resourceName);
            }
            bis = new BufferedInputStream(is);
            props.load(bis);
        }
        catch (IOException ioe) {
            if (defaults == null) {
                throw ioe;
            }
            throw new WrappedRuntimeException("Could not load '" + resourceName + "' (check CLASSPATH), now using just the defaults ", ioe);
        }
        catch (SecurityException se) {
            if (defaults == null) {
                throw se;
            }
            throw new WrappedRuntimeException("Could not load '" + resourceName + "' (check CLASSPATH, applet security), now using just the defaults ", se);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (is != null) {
                is.close();
            }
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = null;
            try {
                value = System.getProperty(key);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (value == null) {
                value = (String)props.get(key);
            }
            String newKey = OutputProperties.fixupPropertyString(key, true);
            String newValue = null;
            try {
                newValue = System.getProperty(newKey);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            newValue = newValue == null ? OutputProperties.fixupPropertyString(value, false) : OutputProperties.fixupPropertyString(newValue, false);
            if (key == newKey && value == newValue) continue;
            props.remove(key);
            props.put(newKey, newValue);
        }
        return props;
    }

    public static Properties getDefaultMethodProperties(String method) {
        if (method.equals("xml")) {
            return m_xml_properties;
        }
        if (method.equals("html")) {
            return m_html_properties;
        }
        if (method.equals("text")) {
            return m_text_properties;
        }
        return m_xml_properties;
    }

    public Object clone() {
        try {
            OutputProperties cloned = (OutputProperties)super.clone();
            cloned.m_properties = (Properties)cloned.m_properties.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setProperty(QName key, String value) {
        this.setProperty(key.toNamespacedString(), value);
    }

    public void setProperty(String key, String value) {
        if (key.equals("method")) {
            this.setMethodDefaults(value);
        }
        this.m_properties.put(key, value);
    }

    public String getProperty(QName key) {
        return this.m_properties.getProperty(key.toNamespacedString());
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public void setBooleanProperty(QName key, boolean value) {
        this.m_properties.put(key.toNamespacedString(), value ? "yes" : "no");
    }

    public void setBooleanProperty(String key, boolean value) {
        this.m_properties.put(key, value ? "yes" : "no");
    }

    public boolean getBooleanProperty(QName key) {
        return this.getBooleanProperty(key.toNamespacedString());
    }

    public boolean getBooleanProperty(String key) {
        return OutputProperties.getBooleanProperty(key, this.m_properties);
    }

    public static boolean getBooleanProperty(String key, Properties props) {
        String s = props.getProperty(key);
        return null != s && s.equals("yes");
    }

    public void setIntProperty(QName key, int value) {
        this.setIntProperty(key.toNamespacedString(), value);
    }

    public void setIntProperty(String key, int value) {
        this.m_properties.put(key, Integer.toString(value));
    }

    public int getIntProperty(QName key) {
        return this.getIntProperty(key.toNamespacedString());
    }

    public int getIntProperty(String key) {
        return OutputProperties.getIntProperty(key, this.m_properties);
    }

    public static int getIntProperty(String key, Properties props) {
        String s = props.getProperty(key);
        if (null == s) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public void setQNameProperty(QName key, QName value) {
        this.setQNameProperty(key.toNamespacedString(), value);
    }

    public void setMethodDefaults(String method) {
        String defaultMethod = this.m_properties.getProperty("method");
        if (null == defaultMethod || !defaultMethod.equals(method)) {
            Properties savedProps = this.m_properties;
            Properties newDefaults = OutputProperties.getDefaultMethodProperties(method);
            this.m_properties = new Properties(newDefaults);
            this.copyFrom(savedProps, false);
        }
    }

    public void setQNameProperty(String key, QName value) {
        this.setProperty(key, value.toNamespacedString());
    }

    public QName getQNameProperty(QName key) {
        return this.getQNameProperty(key.toNamespacedString());
    }

    public QName getQNameProperty(String key) {
        return OutputProperties.getQNameProperty(key, this.m_properties);
    }

    public static QName getQNameProperty(String key, Properties props) {
        String s = props.getProperty(key);
        if (null != s) {
            return QName.getQNameFromString(s);
        }
        return null;
    }

    public void setQNameProperties(QName key, Vector v) {
        this.setQNameProperties(key.toNamespacedString(), v);
    }

    public void setQNameProperties(String key, Vector v) {
        int s = v.size();
        FastStringBuilder fsb = new FastStringBuilder(9, 9);
        for (int i = 0; i < s; ++i) {
            QName qname = (QName)v.elementAt(i);
            fsb.append(qname.toNamespacedString());
            if (i >= s - 1) continue;
            fsb.append(' ');
        }
        this.m_properties.put(key, fsb.toString());
    }

    public Vector getQNameProperties(QName key) {
        return this.getQNameProperties(key.toNamespacedString());
    }

    public Vector getQNameProperties(String key) {
        return OutputProperties.getQNameProperties(key, this.m_properties);
    }

    public static Vector getQNameProperties(String key, Properties props) {
        String s = props.getProperty(key);
        if (null != s) {
            Vector<QName> v = new Vector<QName>();
            int l = s.length();
            boolean inCurly = false;
            FastStringBuilder buf = new FastStringBuilder();
            for (int i = 0; i < l; ++i) {
                char c = s.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!inCurly) {
                        if (buf.length() <= 0) continue;
                        QName qname = QName.getQNameFromString(buf.toString());
                        v.addElement(qname);
                        buf.reset();
                        continue;
                    }
                } else if ('{' == c) {
                    inCurly = true;
                } else if ('}' == c) {
                    inCurly = false;
                }
                buf.append(c);
            }
            if (buf.length() > 0) {
                QName qname = QName.getQNameFromString(buf.toString());
                v.addElement(qname);
                buf.reset();
            }
            return v;
        }
        return null;
    }

    public void recompose(StylesheetRoot root) throws TransformerException {
        root.recomposeOutput(this);
    }

    public void compose() throws TransformerException {
        super.compose();
        this.m_propertiesLevels = null;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void copyFrom(Properties src) {
        this.copyFrom(src, true);
    }

    public void copyFrom(Properties src, boolean shouldResetDefaults) {
        Enumeration<Object> vEnum = src.keys();
        while (vEnum.hasMoreElements()) {
            String key = (String)vEnum.nextElement();
            Object oldValue = this.m_properties.get(key);
            if (null == oldValue) {
                String val = (String)src.get(key);
                if (shouldResetDefaults && key.equals("method")) {
                    this.setMethodDefaults(val);
                }
                this.m_properties.put(key, val);
                continue;
            }
            if (!key.equals("cdata-section-elements")) continue;
            this.m_properties.put(key, (String)oldValue + " " + (String)src.get(key));
        }
    }

    public void copyFrom(OutputProperties opsrc) throws TransformerException {
        this.checkDuplicates(opsrc);
        this.copyFrom(opsrc.getProperties());
    }

    private void checkDuplicates(OutputProperties newProps) throws TransformerException {
        if (null == this.m_propertiesLevels) {
            this.m_propertiesLevels = new Hashtable();
        }
        int newPrecedence = newProps.getStylesheetComposed().getImportCountComposed();
        Properties p = newProps.getProperties();
        Enumeration<Object> vEnum = p.keys();
        while (vEnum.hasMoreElements()) {
            String key = (String)vEnum.nextElement();
            if (key.equals("cdata-section-elements")) continue;
            Integer oldPrecedence = (Integer)this.m_propertiesLevels.get(key);
            if (null == oldPrecedence) {
                this.m_propertiesLevels.put(key, new Integer(newPrecedence));
                continue;
            }
            if (newPrecedence < oldPrecedence) continue;
            String oldValue = (String)this.m_properties.get(key);
            String newValue = (String)newProps.m_properties.get(key);
            if ((oldValue != null || newValue == null) && oldValue.equals(newValue)) continue;
            String msg = key + " can not be multiply defined at the same " + "import level! Old value = " + oldValue + "; New value = " + newValue;
            throw new TransformerException(msg, newProps);
        }
    }

    public boolean isLegalPropertyKey(String key) {
        return key.equals("cdata-section-elements") || key.equals("doctype-public") || key.equals("doctype-system") || key.equals("encoding") || key.equals("indent") || key.equals("media-type") || key.equals("method") || key.equals("omit-xml-declaration") || key.equals("standalone") || key.equals("version") || key.length() > 0 && key.charAt(0) == '{';
    }

    static {
        try {
            m_xml_properties = OutputProperties.loadPropertiesFile("output_xml.properties", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            m_html_properties = OutputProperties.loadPropertiesFile("output_html.properties", m_xml_properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            m_text_properties = OutputProperties.loadPropertiesFile("output_text.properties", m_xml_properties);
            if (null == m_text_properties.getProperty("encoding")) {
                String mimeEncoding = Encodings.getMimeEncoding(null);
                m_text_properties.put("encoding", mimeEncoding);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
        S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xslt}content-handler";
        S_KEY_ENTITIES = "{http://xml.apache.org/xslt}entities";
        S_USE_URL_ESCAPING = "{http://xml.apache.org/xslt}use-url-escaping";
        m_synch_object = new Integer(1);
        NO_CLASSES = new Class[0];
        NO_OBJS = new Object[0];
    }
}

