/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.templates;

import com.scenari.xsldom.xalan.processor.XSLTSchema;
import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xalan.templates.DecimalFormatProperties;
import com.scenari.xsldom.xalan.templates.ElemApplyTemplates;
import com.scenari.xsldom.xalan.templates.ElemAttributeSet;
import com.scenari.xsldom.xalan.templates.ElemTemplate;
import com.scenari.xsldom.xalan.templates.ElemTemplateElement;
import com.scenari.xsldom.xalan.templates.ElemValueOf;
import com.scenari.xsldom.xalan.templates.ElemVariable;
import com.scenari.xsldom.xalan.templates.KeyDeclaration;
import com.scenari.xsldom.xalan.templates.NamespaceAlias;
import com.scenari.xsldom.xalan.templates.OutputProperties;
import com.scenari.xsldom.xalan.templates.Stylesheet;
import com.scenari.xsldom.xalan.templates.StylesheetComposed;
import com.scenari.xsldom.xalan.templates.TemplateList;
import com.scenari.xsldom.xalan.templates.WhiteSpaceInfo;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StylesheetRoot
extends StylesheetComposed
implements Serializable,
Templates {
    private Hashtable m_availElems;
    private StylesheetComposed[] m_globalImportList;
    private OutputProperties m_outputProperties;
    private boolean m_outputMethodSet = false;
    private Hashtable m_attrSets;
    private Hashtable m_decimalFormatSymbols;
    private Vector m_keyDecls;
    private Hashtable m_namespaceAliasComposed;
    private TemplateList m_templateList;
    private Vector m_variables;
    private TemplateList m_whiteSpaceInfoList;
    private ElemTemplate m_defaultTextRule;
    private ElemTemplate m_defaultRule;
    private ElemTemplate m_defaultRootRule;
    XPath m_selectDefault;

    public StylesheetRoot(ErrorListener errorListener) throws TransformerConfigurationException {
        super(null);
        this.setStylesheetRoot(this);
        try {
            this.m_selectDefault = XPath.createXPath("node()", this, this, 0, errorListener);
            this.initDefaultRule(errorListener);
        }
        catch (TransformerException se) {
            throw new TransformerConfigurationException("Can't init default templates!", se);
        }
    }

    public StylesheetRoot(XSLTSchema schema, ErrorListener listener) throws TransformerConfigurationException {
        this(listener);
        this.m_availElems = schema.getElemsAvailable();
    }

    public boolean isRoot() {
        return true;
    }

    public Hashtable getAvailableElements() {
        return this.m_availElems;
    }

    public Transformer newTransformer() {
        return new TransformerImpl(this);
    }

    public Properties getDefaultOutputProps() {
        return this.m_outputProperties.getProperties();
    }

    public Properties getOutputProperties() {
        return (Properties)this.getDefaultOutputProps().clone();
    }

    public void recompose() throws TransformerException {
        StylesheetComposed imported;
        int i;
        if (null == this.m_globalImportList) {
            Vector importList = new Vector();
            this.addImports(this, true, importList);
            this.m_globalImportList = new StylesheetComposed[importList.size()];
            int j = 0;
            for (int i2 = importList.size() - 1; i2 >= 0; --i2) {
                this.m_globalImportList[j++] = (StylesheetComposed)importList.elementAt(i2);
            }
        }
        Vector recomposableElements = new Vector();
        int n = this.getGlobalImportCount();
        for (i = 0; i < n; ++i) {
            imported = this.getGlobalImport(i);
            imported.recompose(recomposableElements);
        }
        this.QuickSort2(recomposableElements, 0, recomposableElements.size() - 1);
        this.m_outputProperties = new OutputProperties("xml");
        this.m_attrSets = new Hashtable();
        this.m_decimalFormatSymbols = new Hashtable();
        this.m_keyDecls = new Vector();
        this.m_namespaceAliasComposed = new Hashtable();
        this.m_templateList = new TemplateList();
        this.m_variables = new Vector();
        for (i = recomposableElements.size() - 1; i >= 0; --i) {
            ((ElemTemplateElement)recomposableElements.elementAt(i)).recompose(this);
        }
        this.m_templateList.compose();
        this.m_outputProperties.compose();
        n = this.getGlobalImportCount();
        for (i = 0; i < n; ++i) {
            imported = this.getGlobalImport(i);
            int includedCount = imported.getIncludeCountComposed();
            for (int j = -1; j < includedCount; ++j) {
                Stylesheet included = imported.getIncludeComposed(j);
                StylesheetRoot.composeTemplates(included);
            }
        }
    }

    static void composeTemplates(ElemTemplateElement templ) throws TransformerException {
        templ.compose();
        for (ElemTemplateElement child = templ.getFirstChildElem(); child != null; child = child.getNextSiblingElem()) {
            StylesheetRoot.composeTemplates(child);
        }
    }

    protected void addImports(Stylesheet stylesheet, boolean addToList, Vector importList) {
        int i;
        int n = stylesheet.getImportCount();
        if (n > 0) {
            for (i = 0; i < n; ++i) {
                StylesheetComposed imported = stylesheet.getImport(i);
                this.addImports(imported, true, importList);
            }
        }
        if ((n = stylesheet.getIncludeCount()) > 0) {
            for (i = 0; i < n; ++i) {
                Stylesheet included = stylesheet.getInclude(i);
                this.addImports(included, false, importList);
            }
        }
        if (addToList) {
            importList.addElement(stylesheet);
        }
    }

    public StylesheetComposed getGlobalImport(int i) {
        return this.m_globalImportList[i];
    }

    public int getGlobalImportCount() {
        return this.m_globalImportList != null ? this.m_globalImportList.length : 1;
    }

    public int getImportNumber(StylesheetComposed sheet) {
        if (this == sheet) {
            return 0;
        }
        int n = this.getGlobalImportCount();
        for (int i = 0; i < n; ++i) {
            if (sheet != this.getGlobalImport(i)) continue;
            return i;
        }
        return -1;
    }

    void recomposeOutput(OutputProperties oprops) throws TransformerException {
        this.m_outputProperties.copyFrom(oprops);
    }

    public OutputProperties getOutputComposed() {
        return this.m_outputProperties;
    }

    public boolean isOutputMethodSet() {
        return this.m_outputMethodSet;
    }

    void recomposeAttributeSets(ElemAttributeSet attrSet) {
        Vector<ElemAttributeSet> attrSetList = (Vector<ElemAttributeSet>)this.m_attrSets.get(attrSet.getName());
        if (null == attrSetList) {
            attrSetList = new Vector<ElemAttributeSet>();
            this.m_attrSets.put(attrSet.getName(), attrSetList);
        }
        attrSetList.addElement(attrSet);
    }

    public Vector getAttributeSetComposed(QName name) throws ArrayIndexOutOfBoundsException {
        return (Vector)this.m_attrSets.get(name);
    }

    void recomposeDecimalFormats(DecimalFormatProperties dfp) {
        DecimalFormatSymbols oldDfs = (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(dfp.getName());
        if (null == oldDfs) {
            this.m_decimalFormatSymbols.put(dfp.getName(), dfp.getDecimalFormatSymbols());
        } else if (!dfp.getDecimalFormatSymbols().equals(oldDfs)) {
            String themsg = dfp.getName().equals(new QName("")) ? XSLMessages.createWarning(19, new Object[0]) : XSLMessages.createWarning(20, new Object[]{dfp.getName()});
            this.error(themsg);
        }
    }

    public DecimalFormatSymbols getDecimalFormatComposed(QName name) {
        return (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(name);
    }

    void recomposeKeys(KeyDeclaration keyDecl) {
        this.m_keyDecls.addElement(keyDecl);
    }

    public Vector getKeysComposed() {
        return this.m_keyDecls;
    }

    void recomposeNamespaceAliases(NamespaceAlias nsAlias) {
        this.m_namespaceAliasComposed.put(nsAlias.getStylesheetNamespace(), nsAlias);
    }

    public NamespaceAlias getNamespaceAliasComposed(String uri) {
        return null == this.m_namespaceAliasComposed ? null : this.m_namespaceAliasComposed.get(uri);
    }

    void recomposeTemplates(ElemTemplate template) {
        this.m_templateList.setTemplate(template);
    }

    public final TemplateList getTemplateListComposed() {
        return this.m_templateList;
    }

    public final void setTemplateListComposed(TemplateList templateList) {
        this.m_templateList = templateList;
    }

    public ElemTemplate getTemplateComposed(XPathContext xctxt, Node targetNode, QName mode, int maxImportLevel, boolean quietConflictWarnings) throws TransformerException {
        return this.m_templateList.getTemplate(xctxt, targetNode, mode, maxImportLevel, quietConflictWarnings);
    }

    public ElemTemplate getTemplateComposed(QName qname) {
        return this.m_templateList.getTemplate(qname);
    }

    void recomposeVariables(ElemVariable elemVar) {
        if (this.getVariableOrParamComposed(elemVar.getName()) == null) {
            this.m_variables.addElement(elemVar);
        }
    }

    public ElemVariable getVariableOrParamComposed(QName qname) {
        if (null != this.m_variables) {
            int n = this.m_variables.size();
            for (int i = 0; i < n; ++i) {
                ElemVariable var = (ElemVariable)this.m_variables.elementAt(i);
                if (!var.getName().equals(qname)) continue;
                return var;
            }
        }
        return null;
    }

    public Vector getVariablesAndParamsComposed() {
        return this.m_variables;
    }

    void recomposeWhiteSpaceInfo(WhiteSpaceInfo wsi) {
        if (null == this.m_whiteSpaceInfoList) {
            this.m_whiteSpaceInfoList = new TemplateList();
        }
        this.m_whiteSpaceInfoList.setTemplate(wsi);
    }

    public boolean shouldCheckWhitespace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public WhiteSpaceInfo getWhiteSpaceInfo(XPathContext support, Element targetElement) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            return (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, -1, false);
        }
        return null;
    }

    public boolean shouldStripWhiteSpace(XPathContext support, Element targetElement) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            while (null != targetElement) {
                WhiteSpaceInfo info = (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(support, targetElement, null, -1, false);
                if (null != info) {
                    return info.getShouldStripSpace();
                }
                Node parent = targetElement.getParentNode();
                if (null != parent && 1 == parent.getNodeType()) {
                    targetElement = (Element)parent;
                    continue;
                }
                targetElement = null;
            }
        }
        return false;
    }

    public boolean canStripWhiteSpace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public final ElemTemplate getDefaultTextRule() {
        return this.m_defaultTextRule;
    }

    public final ElemTemplate getDefaultRule() {
        return this.m_defaultRule;
    }

    public final ElemTemplate getDefaultRootRule() {
        return this.m_defaultRootRule;
    }

    private void initDefaultRule(ErrorListener errorListener) throws TransformerException {
        this.m_defaultRule = new ElemTemplate();
        this.m_defaultRule.setStylesheet(this);
        XPath defMatch = XPath.createXPath("*", this, this, 1, errorListener);
        this.m_defaultRule.setMatch(defMatch);
        ElemApplyTemplates childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        this.m_defaultRule.appendChild(childrenElement);
        this.m_defaultTextRule = new ElemTemplate();
        this.m_defaultTextRule.setStylesheet(this);
        defMatch = XPath.createXPath("text() | @*", this, this, 1, errorListener);
        this.m_defaultTextRule.setMatch(defMatch);
        ElemValueOf elemValueOf = new ElemValueOf();
        this.m_defaultTextRule.appendChild(elemValueOf);
        XPath selectPattern = XPath.createXPath(".", this, this, 0, errorListener);
        elemValueOf.setSelect(selectPattern);
        this.m_defaultRootRule = new ElemTemplate();
        this.m_defaultRootRule.setStylesheet(this);
        defMatch = XPath.createXPath("/", this, this, 1, errorListener);
        this.m_defaultRootRule.setMatch(defMatch);
        childrenElement = new ElemApplyTemplates();
        childrenElement.setIsDefaultTemplate(true);
        this.m_defaultRootRule.appendChild(childrenElement);
    }

    private void QuickSort2(Vector v, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            ElemTemplateElement midNode = (ElemTemplateElement)v.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && ((ElemTemplateElement)v.elementAt(lo)).compareTo(midNode) < 0) {
                    ++lo;
                }
                while (hi > lo0 && ((ElemTemplateElement)v.elementAt(hi)).compareTo(midNode) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                ElemTemplateElement node = (ElemTemplateElement)v.elementAt(lo);
                v.setElementAt(v.elementAt(hi), lo);
                v.setElementAt(node, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.QuickSort2(v, lo0, hi);
            }
            if (lo < hi0) {
                this.QuickSort2(v, lo, hi0);
            }
        }
    }
}

