/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.transformer;

import com.scenari.xsldom.xalan.transformer.ResultTreeHandler;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.XPathContext;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ClonerToResultTree {
    private ResultTreeHandler m_rth;
    private TransformerImpl m_transformer;

    public ClonerToResultTree(TransformerImpl transformer, ResultTreeHandler rth) {
        this.m_rth = rth;
        this.m_transformer = transformer;
    }

    public void cloneToResultTree(Node node, boolean shouldCloneAttributes) throws TransformerException {
        try {
            boolean stripWhiteSpace = false;
            XPathContext xctxt = this.m_transformer.getXPathContext();
            DOMHelper dhelper = xctxt.getDOMHelper();
            switch (node.getNodeType()) {
                case 3: {
                    Text tx = (Text)node;
                    String data = null;
                    if (stripWhiteSpace) {
                        if (!dhelper.isIgnorableWhitespace(tx) && null != (data = tx.getData()) && 0 == data.trim().length()) {
                            data = null;
                        }
                    } else {
                        Node parent = node.getParentNode();
                        if (null != parent) {
                            if (9 != parent.getNodeType() && null != (data = tx.getData()) && 0 == data.length()) {
                                data = null;
                            }
                        } else {
                            data = tx.getData();
                            if (null != data && 0 == data.length()) {
                                data = null;
                            }
                        }
                    }
                    if (null != data) {
                        if (dhelper.isIgnorableWhitespace(tx)) {
                            this.m_rth.ignorableWhitespace(data.toCharArray(), 0, data.length());
                            break;
                        }
                        this.m_rth.characters(data);
                    }
                    break;
                }
                case 9: 
                case 11: {
                    break;
                }
                case 1: {
                    if (shouldCloneAttributes) {
                        this.m_rth.addAttributes(node);
                        this.m_rth.processNSDecls(node);
                    }
                    String ns = dhelper.getNamespaceOfNode(node);
                    String localName = dhelper.getLocalNameOfNode(node);
                    this.m_rth.startElement(ns, localName, node.getNodeName(), null);
                    break;
                }
                case 4: {
                    this.m_rth.startCDATA();
                    String data = ((CDATASection)node).getData();
                    this.m_rth.characters(data);
                    this.m_rth.endCDATA();
                    break;
                }
                case 2: {
                    if (this.m_rth.isDefinedNSDecl((Attr)node)) break;
                    String ns = dhelper.getNamespaceOfNode(node);
                    String localName = dhelper.getLocalNameOfNode(node);
                    this.m_rth.addAttribute(ns, localName, node.getNodeName(), "CDATA", ((Attr)node).getValue());
                    break;
                }
                case 8: {
                    this.m_rth.comment(((Comment)node).getData());
                    break;
                }
                case 5: {
                    EntityReference er = (EntityReference)node;
                    this.m_rth.entityReference(er.getNodeName());
                    break;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    this.m_rth.processingInstruction(pi.getTarget(), pi.getData());
                    break;
                }
                default: {
                    this.m_transformer.getMsgMgr().error(null, 56, new Object[]{node.getNodeName()});
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

