/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.transformer;

import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xalan.templates.KeyDeclaration;
import com.scenari.xsldom.xalan.transformer.KeyIterator;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.axes.DescendantOrSelfWalker;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import com.scenari.xsldom.xpath.objects.XObject;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class KeyWalker
extends DescendantOrSelfWalker {
    transient NamedNodeMap m_attrs;
    transient boolean m_foundAttrs;
    transient int m_attrPos;
    String m_lookupKey;

    public KeyWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public void setRoot(Node root) {
        this.m_attrs = null;
        this.m_foundAttrs = false;
        this.m_attrPos = 0;
        super.setRoot(root);
    }

    protected Node getNextNode() {
        Node next;
        if (!this.m_foundAttrs) {
            this.m_attrs = this.getCurrentNode().getAttributes();
            this.m_foundAttrs = true;
        }
        if (null != this.m_attrs) {
            if (this.m_attrPos < this.m_attrs.getLength()) {
                return this.m_attrs.item(this.m_attrPos++);
            }
            this.m_attrs = null;
        }
        if (null != (next = super.getNextNode())) {
            this.m_foundAttrs = false;
        }
        return next;
    }

    public short acceptNode(Node testNode) {
        boolean foundKey = false;
        KeyIterator ki = (KeyIterator)this.m_lpi;
        Vector keys = ki.getKeyDeclarations();
        QName name = ki.getName();
        try {
            String lookupKey = this.m_lookupKey;
            int nDeclarations = keys.size();
            for (int i = 0; i < nDeclarations; ++i) {
                Node useNode;
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i);
                if (!kd.getName().equals(name)) continue;
                foundKey = true;
                ki.getXPathContext().setPrefixResolver(ki.getPrefixResolver());
                double score = kd.getMatch().getMatchScore(ki.getXPathContext(), testNode);
                kd.getMatch();
                if (score == Double.NEGATIVE_INFINITY) continue;
                XObject xuse = kd.getUse().execute(ki.getXPathContext(), testNode, ki.getPrefixResolver());
                if (xuse.getType() != 4) {
                    String exprResult = xuse.str();
                    ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                    if (!lookupKey.equals(exprResult)) continue;
                    return 1;
                }
                NodeIterator nl = xuse.nodeset();
                short result = -1;
                while (null != (useNode = nl.nextNode())) {
                    this.m_lpi.getDOMHelper();
                    String exprResult = DOMHelper.getNodeData(useNode);
                    ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                    if (null == exprResult || !lookupKey.equals(exprResult)) continue;
                    result = 1;
                }
                if (-1 == result) continue;
                return result;
            }
        }
        catch (TransformerException se) {
            // empty catch block
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage(58, new Object[]{name.getLocalName()}));
        }
        return 2;
    }

    public Node nextNode() {
        Node node = super.nextNode();
        if (node == null) {
            ((KeyIterator)this.m_lpi).setLookForMoreNodes(false);
        }
        return node;
    }
}

