/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.transformer;

import com.scenari.xsldom.xalan.transformer.NodeSortKey;
import com.scenari.xsldom.xml.utils.NodeVector;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import com.scenari.xsldom.xpath.objects.XObject;
import java.text.CollationKey;
import java.text.NumberFormat;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSorter {
    XPathContext m_execContext;
    Vector m_keys;
    NumberFormat m_formatter = NumberFormat.getNumberInstance();

    public NodeSorter(XPathContext p) {
        this.m_execContext = p;
    }

    public void sort(NodeVector v, Vector keys, XPathContext support) throws TransformerException {
        this.m_keys = keys;
        int n = v.size();
        Vector<NodeCompareElem> nodes = new Vector<NodeCompareElem>();
        for (int i = 0; i < n; ++i) {
            NodeCompareElem elem = new NodeCompareElem(v.elementAt(i));
            nodes.addElement(elem);
        }
        Vector scratchVector = new Vector();
        this.mergesort(nodes, scratchVector, 0, n - 1, support);
        for (int i = 0; i < n; ++i) {
            v.setElementAt(((NodeCompareElem)nodes.elementAt((int)i)).m_node, i);
        }
    }

    int compare(NodeCompareElem n1, NodeCompareElem n2, int kIndex, XPathContext support) throws TransformerException {
        int result = 0;
        NodeSortKey k = (NodeSortKey)this.m_keys.elementAt(kIndex);
        if (k.m_treatAsNumbers) {
            double diff;
            double n2Num;
            double n1Num;
            if (kIndex == 0) {
                n1Num = (Double)n1.m_key1Value;
                n2Num = (Double)n2.m_key1Value;
            } else if (kIndex == 1) {
                n1Num = (Double)n1.m_key2Value;
                n2Num = (Double)n2.m_key2Value;
            } else {
                XObject r1 = k.m_selectPat.execute(this.m_execContext, n1.m_node, k.m_namespaceContext);
                XObject r2 = k.m_selectPat.execute(this.m_execContext, n2.m_node, k.m_namespaceContext);
                double d = r1.num();
                n1Num = Double.isNaN(d) ? 0.0 : d;
                d = r2.num();
                double d2 = n2Num = Double.isNaN(d) ? 0.0 : d;
            }
            result = n1Num == n2Num && kIndex + 1 < this.m_keys.size() ? this.compare(n1, n2, kIndex + 1, support) : ((diff = n1Num - n2Num) < 0.0 ? (k.m_descending ? 1 : -1) : (diff > 0.0 ? (k.m_descending ? -1 : 1) : 0));
        } else {
            String tempN2;
            String tempN1;
            CollationKey n2String;
            CollationKey n1String;
            if (kIndex == 0) {
                n1String = (CollationKey)n1.m_key1Value;
                n2String = (CollationKey)n2.m_key1Value;
            } else if (kIndex == 1) {
                n1String = (CollationKey)n1.m_key2Value;
                n2String = (CollationKey)n2.m_key2Value;
            } else {
                XObject r1 = k.m_selectPat.execute(this.m_execContext, n1.m_node, k.m_namespaceContext);
                XObject r2 = k.m_selectPat.execute(this.m_execContext, n2.m_node, k.m_namespaceContext);
                n1String = k.m_col.getCollationKey(r1.str());
                n2String = k.m_col.getCollationKey(r2.str());
            }
            result = n1String.compareTo(n2String);
            if (k.m_caseOrderUpper && (tempN1 = n1String.getSourceString().toLowerCase()).equals(tempN2 = n2String.getSourceString().toLowerCase())) {
                int n = result = result == 0 ? 0 : -result;
            }
            if (k.m_descending) {
                result = -result;
            }
        }
        if (0 == result && kIndex + 1 < this.m_keys.size()) {
            result = this.compare(n1, n2, kIndex + 1, support);
        }
        if (0 == result) {
            result = support.getDOMHelper().isNodeAfter(n1.m_node, n2.m_node) ? -1 : 1;
        }
        return result;
    }

    void mergesort(Vector a, Vector b, int l, int r, XPathContext support) throws TransformerException {
        if (r - l > 0) {
            int j;
            int i;
            int m = (r + l) / 2;
            this.mergesort(a, b, l, m, support);
            this.mergesort(a, b, m + 1, r, support);
            for (i = m; i >= l; --i) {
                if (i >= b.size()) {
                    b.insertElementAt(a.elementAt(i), i);
                    continue;
                }
                b.setElementAt(a.elementAt(i), i);
            }
            i = l;
            for (j = m + 1; j <= r; ++j) {
                if (r + m + 1 - j >= b.size()) {
                    b.insertElementAt(a.elementAt(j), r + m + 1 - j);
                    continue;
                }
                b.setElementAt(a.elementAt(j), r + m + 1 - j);
            }
            j = r;
            for (int k = l; k <= r; ++k) {
                int compVal = i == j ? -1 : this.compare((NodeCompareElem)b.elementAt(i), (NodeCompareElem)b.elementAt(j), 0, support);
                if (compVal < 0) {
                    a.setElementAt(b.elementAt(i), k);
                    ++i;
                    continue;
                }
                if (compVal <= 0) continue;
                a.setElementAt(b.elementAt(j), k);
                --j;
            }
        }
    }

    private void swap(Vector v, int i, int j) {
        Node node = (Node)v.elementAt(i);
        v.setElementAt(v.elementAt(j), i);
        v.setElementAt(node, j);
    }

    class NodeCompareElem {
        Node m_node;
        int maxkey = 2;
        Object m_key1Value;
        Object m_key2Value;

        NodeCompareElem(Node node) throws TransformerException {
            boolean tryNextKey = true;
            this.m_node = node;
            if (!NodeSorter.this.m_keys.isEmpty()) {
                NodeIterator ni;
                double d;
                NodeSortKey k1 = (NodeSortKey)NodeSorter.this.m_keys.elementAt(0);
                XObject r = k1.m_selectPat.execute(NodeSorter.this.m_execContext, node, k1.m_namespaceContext);
                if (r == null) {
                    tryNextKey = false;
                }
                this.m_key1Value = k1.m_treatAsNumbers ? new Double(Double.isNaN(d = r.num()) ? 0.0 : d) : k1.m_col.getCollationKey(r.str());
                if (r.getType() == 4 && (ni = (NodeIterator)r.object()) instanceof ContextNodeList) {
                    boolean bl = tryNextKey = ((ContextNodeList)((Object)ni)).getCurrentNode() != null;
                }
                if (NodeSorter.this.m_keys.size() > 1) {
                    NodeSortKey k2 = (NodeSortKey)NodeSorter.this.m_keys.elementAt(1);
                    if (!tryNextKey) {
                        this.m_key2Value = k2.m_treatAsNumbers ? new Double(0.0) : k2.m_col.getCollationKey("");
                    } else {
                        XObject r2 = k2.m_selectPat.execute(NodeSorter.this.m_execContext, node, k2.m_namespaceContext);
                        this.m_key2Value = k2.m_treatAsNumbers ? new Double(Double.isNaN(d = r2.num()) ? 0.0 : d) : k2.m_col.getCollationKey(r2.str());
                    }
                }
            }
        }
    }
}

