/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.transformer;

import com.scenari.serializer.ISerializerHandler;
import com.scenari.xsldom.xalan.templates.ElemTemplate;
import com.scenari.xsldom.xalan.templates.ElemTemplateElement;
import com.scenari.xsldom.xalan.templates.StylesheetRoot;
import com.scenari.xsldom.xalan.transformer.ClonerToResultTree;
import com.scenari.xsldom.xalan.transformer.QueuedEvents;
import com.scenari.xsldom.xalan.transformer.QueuedStartDocument;
import com.scenari.xsldom.xalan.transformer.QueuedStartElement;
import com.scenari.xsldom.xalan.transformer.SerializerSwitcher;
import com.scenari.xsldom.xalan.transformer.TransformState;
import com.scenari.xsldom.xalan.transformer.TransformerClient;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.MutableAttrListImpl;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.TreeWalker;
import com.scenari.xsldom.xml.utils.XMLCharacterRecognizer;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XObject;
import java.util.Enumeration;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ResultTreeHandler
extends QueuedEvents
implements ContentHandler,
LexicalHandler,
TransformState {
    private static final boolean DEBUG = false;
    boolean m_nsContextPushed = false;
    NamespaceSupport m_nsSupport = new NamespaceSupport();
    private TransformerImpl m_transformer;
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;
    private ISerializerHandler m_SerializerHandler;
    private StylesheetRoot m_stylesheetRoot = null;
    private int m_uniqueNSValue = 0;
    private static final String S_NAMESPACEPREFIX = "ns";
    public ClonerToResultTree m_cloner;
    private static final int EVT_SETDOCUMENTLOCATOR = 1;
    private static final int EVT_STARTDOCUMENT = 2;
    private static final int EVT_ENDDOCUMENT = 3;
    private static final int EVT_STARTPREFIXMAPPING = 4;
    private static final int EVT_ENDPREFIXMAPPING = 5;
    private static final int EVT_STARTELEMENT = 6;
    private static final int EVT_ENDELEMENT = 7;
    private static final int EVT_CHARACTERS = 8;
    private static final int EVT_IGNORABLEWHITESPACE = 9;
    private static final int EVT_PROCESSINGINSTRUCTION = 10;
    private static final int EVT_SKIPPEDENTITY = 11;
    private static final int EVT_COMMENT = 12;
    private static final int EVT_ENTITYREF = 13;
    private static final int EVT_STARTENTITY = 14;
    private static final int EVT_ENDENTITY = 15;
    private static final int EVT_STARTDTD = 16;
    private static final int EVT_ENDDTD = 17;
    private static final int EVT_STARTCDATA = 22;
    private static final int EVT_ENDCDATA = 23;
    private static final int EVT_NODE = 24;

    public ResultTreeHandler() {
    }

    public ResultTreeHandler(TransformerImpl transformer, ContentHandler realHandler) {
        this.init(transformer, realHandler);
    }

    public void init(TransformerImpl transformer, ContentHandler realHandler) {
        this.m_transformer = transformer;
        this.m_startElement.setTransformer(this.m_transformer);
        this.m_startDoc.setTransformer(this.m_transformer);
        this.m_contentHandler = realHandler;
        this.m_startElement.setContentHandler(this.m_contentHandler);
        this.m_startDoc.setContentHandler(this.m_contentHandler);
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.m_SerializerHandler = this.m_contentHandler instanceof ISerializerHandler ? (ISerializerHandler)this.m_contentHandler : null;
        this.m_startElement.setIsTransformClient(this.m_contentHandler instanceof TransformerClient);
        this.m_cloner = new ClonerToResultTree(transformer, this);
        if (null != this.m_transformer) {
            this.m_stylesheetRoot = this.m_transformer.getStylesheet();
        }
        this.pushDocumentEvent();
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.flushPending(3);
        QueuedStartDocument qsd = this.getQueuedDocAtBottom();
        if (!qsd.isEnded) {
            this.m_contentHandler.endDocument();
            qsd.setPending(false);
        }
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        QueuedStartElement qse = this.getQueuedElem();
        this.checkForSerializerSwitch(ns, localName);
        this.flushPending(6);
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
        }
        this.ensurePrefixIsDeclared(ns, name);
        this.pushElementEvent(ns, localName, name, atts);
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        this.flushPending(7);
        this.m_contentHandler.endElement(ns, localName, name);
        this.sendEndPrefixMappings();
        this.popEvent();
        this.m_nsSupport.popContext();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.startPrefixMapping(prefix, uri, true, false);
    }

    public void startPrefixMapping(String prefix, String uri, boolean shouldFlush, boolean pForceAddDecl) throws SAXException {
        String existingURI;
        if (shouldFlush) {
            this.flushPending(4);
        }
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (null == prefix) {
            prefix = "";
        }
        if (null == (existingURI = this.m_nsSupport.getURI(prefix))) {
            existingURI = prefix.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : "";
        }
        if (null == uri) {
            uri = "";
        }
        if (!existingURI.equals(uri)) {
            QueuedStartElement qe;
            this.m_nsSupport.declarePrefix(prefix, uri);
            if (pForceAddDecl && (qe = this.getQueuedElem()) != null) {
                qe.addAttribute("http://www.w3.org/2000/xmlns/", prefix, prefix.length() == 0 ? "xmlns" : "xmlns:".concat(prefix), "CDATA", uri);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushPending(8);
        this.m_contentHandler.characters(ch, start, length);
    }

    public void characters(String pStr) throws SAXException {
        this.flushPending(8);
        if (this.m_SerializerHandler != null) {
            this.m_SerializerHandler.characters(pStr);
        } else {
            this.m_contentHandler.characters(pStr.toCharArray(), 0, pStr.length());
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        QueuedStartDocument qsd = this.getQueuedDoc();
        if (null != qsd && qsd.isPending && XMLCharacterRecognizer.isWhiteSpace(ch, start, length)) {
            return;
        }
        this.flushPending(9);
        this.m_contentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushPending(10);
        this.m_contentHandler.processingInstruction(target, data);
    }

    public void comment(String data) throws SAXException {
        this.flushPending(12);
        if (null != this.m_SerializerHandler) {
            this.m_SerializerHandler.comment(data);
        } else if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.comment(data.toCharArray(), 0, data.length());
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushPending(12);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.comment(ch, start, length);
        }
    }

    public void entityReference(String name) throws SAXException {
        this.flushPending(13);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startEntity(name);
            this.m_lexicalHandler.endEntity(name);
        }
    }

    public void startEntity(String name) throws SAXException {
        this.flushPending(14);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        this.flushPending(15);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endEntity(name);
        }
    }

    public void startDTD(String s1, String s2, String s3) throws SAXException {
        this.flushPending(16);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startDTD(s1, s2, s3);
        }
    }

    public void endDTD() throws SAXException {
        this.flushPending(17);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endDTD();
        }
    }

    public void startCDATA() throws SAXException {
        this.flushPending(22);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        this.flushPending(23);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void flushPending() throws SAXException {
        this.flushPending(24);
    }

    public void flushPending(int type) throws SAXException {
        QueuedStartElement qe = this.getQueuedElem();
        QueuedStartDocument qdab = this.getQueuedDocAtBottom();
        if (type != 4 && qdab.isPending) {
            qdab.flush(this);
        }
        if (null != qe && qe.isPending) {
            if (!qe.nsDeclsHaveBeenAdded()) {
                this.addNSDeclsToAttrs();
            }
            this.sendStartPrefixMappings();
            qe.flush();
            this.m_nsContextPushed = false;
        }
    }

    public void outputResultTreeFragment(XObject obj, XPathContext support) throws SAXException {
        DocumentFragment docFrag = obj.rtree(support);
        TreeWalker tw = new TreeWalker(this, support.getDOMHelper());
        for (Node n = docFrag.getFirstChild(); null != n; n = n.getNextSibling()) {
            this.flushPending(24);
            tw.traverse(n);
        }
    }

    public void cloneToResultTree(Node node, boolean shouldCloneAttributes) throws SAXException {
        try {
            this.m_cloner.cloneToResultTree(node, shouldCloneAttributes);
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    void ensurePrefixIsDeclared(String ns, String rawName) throws SAXException {
        if (ns != null && ns.length() > 0) {
            String foundURI;
            String prefix;
            int index = rawName.indexOf(":");
            String string = prefix = index < 0 ? "" : rawName.substring(0, index);
            if (!(null == prefix || null != (foundURI = this.m_nsSupport.getURI(prefix)) && foundURI.equals(ns))) {
                this.startPrefixMapping(prefix, ns, false, false);
            }
        }
    }

    protected void sendStartPrefixMappings() throws SAXException {
        Enumeration<String> prefixes = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler handler = this.m_contentHandler;
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            handler.startPrefixMapping(prefix, this.m_nsSupport.getURI(prefix));
        }
    }

    protected void sendEndPrefixMappings() throws SAXException {
        Enumeration<String> prefixes = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler handler = this.m_contentHandler;
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            handler.endPrefixMapping(prefix);
        }
    }

    private void checkForSerializerSwitch(String ns, String localName) throws SAXException {
        try {
            QueuedStartDocument qdab = this.getQueuedDocAtBottom();
            if (qdab.isPending) {
                SerializerSwitcher.switchSerializerIfHTML(this.m_transformer, ns, localName);
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    protected void addNSDeclsToAttrs() {
        Enumeration<String> prefixes = this.m_nsSupport.getDeclaredPrefixes();
        QueuedStartElement qe = this.getQueuedElem();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            boolean isDefault = prefix.length() == 0;
            String name = isDefault ? "xmlns" : "xmlns:" + prefix;
            String uri = this.m_nsSupport.getURI(prefix);
            if (null == uri) {
                uri = "";
            }
            qe.addAttribute("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
        }
        qe.setNSDeclsHaveBeenAdded(true);
    }

    public void processNSDecls(Node src) throws TransformerException {
        try {
            Node parent;
            short type = src.getNodeType();
            if ((type == 1 || type == 5) && (parent = src.getParentNode()) != null) {
                this.processNSDecls(parent);
            }
            if (type == 1) {
                NamedNodeMap nnm = src.getAttributes();
                int nAttrs = nnm.getLength();
                for (int i = 0; i < nAttrs; ++i) {
                    Node attr = nnm.item(i);
                    String aname = attr.getNodeName();
                    if (!QName.isXMLNSDecl(aname)) continue;
                    String prefix = QName.getPrefixFromXMLNSDecl(aname);
                    String desturi = this.getURI(prefix);
                    String srcURI = attr.getNodeValue();
                    if (srcURI.equalsIgnoreCase(desturi)) continue;
                    this.startPrefixMapping(prefix, srcURI, false, false);
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public String getURI(String prefix) {
        return this.m_nsSupport.getURI(prefix);
    }

    public String getPrefix(String namespace) {
        Enumeration<String> vEnum = this.m_nsSupport.getPrefixes();
        while (vEnum.hasMoreElements()) {
            String prefix = vEnum.nextElement();
            if (!this.m_nsSupport.getURI(prefix).equals(namespace)) continue;
            return prefix;
        }
        return null;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setContentHandler(ContentHandler ch) {
        this.m_contentHandler = ch;
        this.m_startElement.setIsTransformClient(this.m_contentHandler instanceof TransformerClient);
        this.m_startElement.setContentHandler(this.m_contentHandler);
        this.m_startDoc.setContentHandler(this.m_contentHandler);
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.m_SerializerHandler = this.m_contentHandler instanceof ISerializerHandler ? (ISerializerHandler)this.m_contentHandler : null;
        this.reInitEvents();
    }

    public int getUniqueNSValue() {
        return this.m_uniqueNSValue++;
    }

    public String getNewUniqueNSPrefix() {
        return S_NAMESPACEPREFIX + String.valueOf(this.getUniqueNSValue());
    }

    public MutableAttrListImpl getPendingAttributes() {
        return this.getQueuedElem().getAttrs();
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value) throws TransformerException {
        QueuedStartElement qe = this.getQueuedElem();
        if (!qe.nsDeclsHaveBeenAdded()) {
            this.addNSDeclsToAttrs();
        }
        if (null == uri) {
            uri = "";
        }
        try {
            if (!rawName.equals("xmlns")) {
                this.ensurePrefixIsDeclared(uri, rawName);
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        if (!this.isDefinedNSDecl(rawName, value)) {
            qe.addAttribute(uri, localName, rawName, type, value);
        }
    }

    public boolean isDefinedNSDecl(String rawName, String value) {
        if (rawName.equals("xmlns") || rawName.startsWith("xmlns:")) {
            int index = rawName.indexOf(":");
            String prefix = index < 0 ? "" : rawName.substring(0, index);
            String definedURI = this.m_nsSupport.getURI(prefix);
            if (null != definedURI) {
                return definedURI.equals(value);
            }
            return false;
        }
        return false;
    }

    public boolean isDefinedNSDecl(Attr attr) {
        int index;
        String prefix;
        String uri;
        String rawName = attr.getNodeName();
        return (rawName.equals("xmlns") || rawName.startsWith("xmlns:")) && null != (uri = this.getURI(prefix = (index = rawName.indexOf(":")) < 0 ? "" : rawName.substring(0, index))) && uri.equals(attr.getValue());
    }

    public void addAttribute(Attr attr) throws TransformerException {
        if (this.isDefinedNSDecl(attr)) {
            return;
        }
        DOMHelper helper = this.m_transformer.getXPathContext().getDOMHelper();
        String ns = helper.getNamespaceOfNode(attr);
        if (ns == null) {
            ns = "";
        }
        this.addAttribute(ns, helper.getLocalNameOfNode(attr), attr.getNodeName(), "CDATA", attr.getValue());
    }

    public void addAttributes(Node src) throws TransformerException {
        NamedNodeMap nnm = src.getAttributes();
        int nAttrs = nnm.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            Attr node = (Attr)nnm.item(i);
            this.addAttribute(node);
        }
    }

    public boolean isElementPending() {
        QueuedStartElement qse = this.getQueuedElem();
        return null != qse ? qse.isPending : false;
    }

    public ElemTemplateElement getCurrentElement() {
        QueuedStartElement qe = this.getQueuedElem();
        if (null != qe && qe.isPending) {
            return qe.getCurrentElement();
        }
        return this.m_transformer.getCurrentElement();
    }

    public Node getCurrentNode() {
        QueuedStartElement qe = this.getQueuedElem();
        if (null != qe && qe.isPending) {
            return qe.getCurrentNode();
        }
        return this.m_transformer.getCurrentNode();
    }

    public ElemTemplate getCurrentTemplate() {
        QueuedStartElement qe = this.getQueuedElem();
        if (null != qe && qe.isPending) {
            return qe.getCurrentTemplate();
        }
        return this.m_transformer.getCurrentTemplate();
    }

    public ElemTemplate getMatchedTemplate() {
        QueuedStartElement qe = this.getQueuedElem();
        if (null != qe && qe.isPending) {
            return qe.getMatchedTemplate();
        }
        return this.m_transformer.getMatchedTemplate();
    }

    public Node getMatchedNode() {
        QueuedStartElement qe = this.getQueuedElem();
        if (null != qe && qe.isPending) {
            return qe.getMatchedNode();
        }
        return this.m_transformer.getMatchedNode();
    }

    public NodeIterator getContextNodeList() {
        QueuedStartElement qe = this.getQueuedElem();
        if (null != qe && qe.isPending) {
            return qe.getContextNodeList();
        }
        return this.m_transformer.getContextNodeList();
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }
}

