/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.transformer;

import com.scenari.xsldom.xalan.templates.ElemTemplateElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StackGuard {
    public static int sRecursionLimit = -1;
    protected int m_recursionLimit = sRecursionLimit;
    Node m_xslRule;
    Node m_sourceXML;
    Stack stack = new Stack();

    public int getRecursionLimit() {
        return this.m_recursionLimit;
    }

    public void setRecursionLimit(int limit) {
        this.m_recursionLimit = limit;
    }

    public StackGuard() {
    }

    public StackGuard(ElemTemplateElement xslTemplate, Node sourceXML) {
        this.m_xslRule = xslTemplate;
        this.m_sourceXML = sourceXML;
    }

    public boolean equals(Object obj) {
        return ((StackGuard)obj).m_xslRule.equals(this.m_xslRule) && ((StackGuard)obj).m_sourceXML.equals(this.m_sourceXML);
    }

    public void print(PrintWriter pw) {
        if (this.m_sourceXML instanceof Text) {
            Text tx = (Text)this.m_sourceXML;
            pw.println(tx.getData());
        } else if (this.m_sourceXML instanceof Element) {
            Element elem = (Element)this.m_sourceXML;
            pw.println(elem.getNodeName());
        }
    }

    public void checkForInfinateLoop(StackGuard guard) throws TransformerException {
        int nRules = this.stack.size();
        int loopCount = 0;
        for (int i = nRules - 1; i >= 0; --i) {
            int k;
            if (this.stack.elementAt(i).equals(guard)) {
                ++loopCount;
            }
            if (loopCount < this.m_recursionLimit) continue;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Infinite loop diagnosed!  Stack trace:");
            for (k = 0; k < nRules; ++k) {
                pw.println("Source Elem #" + k + " ");
                StackGuard guardOnStack = (StackGuard)this.stack.elementAt(i);
                guardOnStack.print(pw);
            }
            pw.println("Source Elem #" + k + " ");
            guard.print(pw);
            pw.println("End of infinite loop diagnosis.");
            throw new TransformerException(sw.getBuffer().toString());
        }
    }

    public void push(ElemTemplateElement xslTemplate, Node sourceXML) throws TransformerException {
        StackGuard guard = new StackGuard(xslTemplate, sourceXML);
        this.checkForInfinateLoop(guard);
        this.stack.push(guard);
    }

    public void pop() {
        this.stack.pop();
    }
}

