/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.transformer;

import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xalan.serialize.Serializer;
import com.scenari.xsldom.xalan.serialize.SerializerFactory;
import com.scenari.xsldom.xalan.stree.Child;
import com.scenari.xsldom.xalan.stree.SourceTreeHandler;
import com.scenari.xsldom.xalan.templates.AVT;
import com.scenari.xsldom.xalan.templates.ElemAttributeSet;
import com.scenari.xsldom.xalan.templates.ElemCallTemplate;
import com.scenari.xsldom.xalan.templates.ElemForEach;
import com.scenari.xsldom.xalan.templates.ElemParam;
import com.scenari.xsldom.xalan.templates.ElemSort;
import com.scenari.xsldom.xalan.templates.ElemTemplate;
import com.scenari.xsldom.xalan.templates.ElemTemplateElement;
import com.scenari.xsldom.xalan.templates.ElemVariable;
import com.scenari.xsldom.xalan.templates.ElemWithParam;
import com.scenari.xsldom.xalan.templates.OutputProperties;
import com.scenari.xsldom.xalan.templates.Stylesheet;
import com.scenari.xsldom.xalan.templates.StylesheetComposed;
import com.scenari.xsldom.xalan.templates.StylesheetRoot;
import com.scenari.xsldom.xalan.templates.XUnresolvedVariable;
import com.scenari.xsldom.xalan.transformer.CountersTable;
import com.scenari.xsldom.xalan.transformer.KeyManager;
import com.scenari.xsldom.xalan.transformer.MsgMgr;
import com.scenari.xsldom.xalan.transformer.NodeSortKey;
import com.scenari.xsldom.xalan.transformer.ResultTreeHandler;
import com.scenari.xsldom.xalan.transformer.StackGuard;
import com.scenari.xsldom.xalan.transformer.TransformSnapshot;
import com.scenari.xsldom.xalan.transformer.TransformSnapshotImpl;
import com.scenari.xsldom.xalan.transformer.TransformState;
import com.scenari.xsldom.xml.utils.BoolStack;
import com.scenari.xsldom.xml.utils.DOMBuilder;
import com.scenari.xsldom.xml.utils.DefaultErrorHandler;
import com.scenari.xsldom.xml.utils.NodeVector;
import com.scenari.xsldom.xml.utils.ObjectPool;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.SystemIDResolver;
import com.scenari.xsldom.xml.utils.WrappedRuntimeException;
import com.scenari.xsldom.xpath.Arg;
import com.scenari.xsldom.xpath.SourceTreeManager;
import com.scenari.xsldom.xpath.VariableStack;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.objects.XRTreeFrag;
import com.scenari.xsldom.xpath.objects.XString;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerImpl
extends Transformer
implements Runnable,
TransformState {
    private Boolean m_reentryGuard = new Boolean(true);
    private FileOutputStream m_outputStream = null;
    private boolean m_parserEventsOnMain = true;
    private Thread m_transformThread;
    private String m_urlOfSource = null;
    private Result m_outputTarget = null;
    private OutputProperties m_outputFormat;
    private Serializer m_serializer;
    ContentHandler m_inputContentHandler;
    private ContentHandler m_outputContentHandler = null;
    DocumentBuilder m_docBuilder = null;
    private ObjectPool m_textResultHandlerObjectPool = new ObjectPool("com.scenari.xsldom.xalan.transformer.ResultTreeHandler");
    private ObjectPool m_stringWriterObjectPool = new ObjectPool("java.io.StringWriter");
    private OutputProperties m_textformat = new OutputProperties("text");
    NodeVector m_currentTemplateElements = new NodeVector(64);
    NodeVector m_currentMatchTemplates = new NodeVector();
    private StylesheetRoot m_stylesheetRoot = null;
    private boolean m_quietConflictWarnings = true;
    private XPathContext m_xcontext;
    private StackGuard m_stackGuard = new StackGuard();
    private ResultTreeHandler m_resultTreeHandler;
    private KeyManager m_keyManager = new KeyManager();
    Stack m_attrSetStack = null;
    CountersTable m_countersTable = null;
    BoolStack m_currentTemplateRuleIsNull = new BoolStack();
    private MsgMgr m_msgMgr;
    public static boolean S_DEBUG = false;
    private ErrorListener m_errorHandler = new DefaultErrorHandler();
    private Exception m_exceptionThrown = null;
    private Source m_xmlSource;
    private Node m_doc;
    private boolean m_isTransformDone = false;
    private boolean m_hasBeenReset = false;
    private boolean m_shouldReset = true;
    private boolean m_hasTransformThreadErrorCatcher = false;
    static ThreadControler tpool = new ThreadControler();

    public void setShouldReset(boolean shouldReset) {
        this.m_shouldReset = shouldReset;
    }

    public TransformerImpl(StylesheetRoot stylesheet) {
        this.setStylesheet(stylesheet);
        this.setXPathContext(new XPathContext(this));
        this.getXPathContext().setPrefixResolver(stylesheet);
    }

    public void reset() {
        if (!this.m_hasBeenReset && this.m_shouldReset) {
            this.m_hasBeenReset = true;
            if (this.m_outputStream != null) {
                try {
                    this.m_outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.m_outputStream = null;
            this.m_countersTable = null;
            this.m_stackGuard = new StackGuard();
            this.getXPathContext().reset();
            this.getXPathContext().getVarStack().reset();
            this.m_currentTemplateElements.removeAllElements();
            this.m_currentMatchTemplates.removeAllElements();
            this.m_resultTreeHandler = null;
            this.m_outputTarget = null;
            this.m_keyManager = new KeyManager();
            this.m_attrSetStack = null;
            this.m_countersTable = null;
            this.m_currentTemplateRuleIsNull = new BoolStack();
            this.m_xmlSource = null;
            this.m_doc = null;
            this.m_isTransformDone = false;
            this.m_inputContentHandler = null;
            this.getXPathContext().getSourceTreeManager().reset();
        }
    }

    public boolean isParserEventsOnMain() {
        return this.m_parserEventsOnMain;
    }

    public Thread getTransformThread() {
        return this.m_transformThread;
    }

    public void setTransformThread(Thread t) {
        this.m_transformThread = t;
    }

    public boolean hasTransformThreadErrorCatcher() {
        return this.m_hasTransformThreadErrorCatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(Source source) throws TransformerException {
        if (source instanceof DOMSource) {
            DOMSource dsource = (DOMSource)source;
            this.m_urlOfSource = dsource.getSystemId();
            Node dNode = dsource.getNode();
            if (null != dNode) {
                if (null != this.m_urlOfSource) {
                    this.getXPathContext().getSourceTreeManager().putDocumentInCache(dNode, dsource);
                }
                this.transformNode(dsource.getNode());
                return;
            }
            String messageStr = XSLMessages.createMessage(108, null);
            throw new IllegalArgumentException(messageStr);
        }
        InputSource xmlSource = SAXSource.sourceToInputSource(source);
        if (null == xmlSource) {
            this.m_errorHandler.fatalError(new TransformerException("Can't transform a Source of type " + (source == null ? "null" : source.getClass().getName()) + "!"));
        }
        if (null != xmlSource.getSystemId()) {
            this.m_urlOfSource = SystemIDResolver.getAbsoluteURI(xmlSource.getSystemId());
            xmlSource.setSystemId(this.m_urlOfSource);
        }
        try {
            this.m_hasTransformThreadErrorCatcher = true;
            XMLReader reader = null;
            if (source instanceof SAXSource) {
                reader = ((SAXSource)source).getXMLReader();
            }
            if (null == reader) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError ex2) {
                }
                catch (AbstractMethodError ame) {
                    // empty catch block
                }
            }
            if (null == reader) {
                reader = XMLReaderFactory.createXMLReader();
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException se) {
                // empty catch block
            }
            ContentHandler inputHandler = this.getInputContentHandler();
            reader.setContentHandler(inputHandler);
            if (inputHandler instanceof DTDHandler) {
                reader.setDTDHandler((DTDHandler)((Object)inputHandler));
            }
            try {
                if (inputHandler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", inputHandler);
                }
                if (inputHandler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/properties/declaration-handler", inputHandler);
                }
            }
            catch (SAXException se) {
                // empty catch block
            }
            try {
                if (inputHandler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", inputHandler);
                }
                if (inputHandler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/DeclHandler", inputHandler);
                }
            }
            catch (SAXNotRecognizedException snre) {
                // empty catch block
            }
            this.getXPathContext().setPrimaryReader(reader);
            this.m_exceptionThrown = null;
            if (inputHandler instanceof SourceTreeHandler) {
                SourceTreeHandler sth = (SourceTreeHandler)inputHandler;
                sth.setInputSource(source);
                sth.setUseMultiThreading(true);
                Node doc = sth.getRoot();
                if (null != doc) {
                    SourceTreeManager stm = this.getXPathContext().getSourceTreeManager();
                    stm.putDocumentInCache(doc, source);
                    this.m_xmlSource = source;
                    this.m_doc = doc;
                    if (this.isParserEventsOnMain()) {
                        this.m_isTransformDone = false;
                        this.getXPathContext().getPrimaryReader().parse(xmlSource);
                    } else {
                        this.runTransformThread();
                        this.transformNode(doc);
                    }
                }
            } else {
                reader.parse(xmlSource);
            }
            Exception e = this.getExceptionThrown();
            if (null != e) {
                if (e instanceof TransformerException) {
                    throw (TransformerException)e;
                }
                if (!(e instanceof WrappedRuntimeException)) throw new TransformerException(e);
                this.m_errorHandler.fatalError(new TransformerException(((WrappedRuntimeException)e).getException()));
                return;
            } else {
                if (null == this.m_resultTreeHandler) return;
                this.m_resultTreeHandler.endDocument();
            }
            return;
        }
        catch (WrappedRuntimeException wre) {
            Exception throwable = wre.getException();
            while (throwable instanceof WrappedRuntimeException) {
                throwable = ((WrappedRuntimeException)throwable).getException();
            }
            this.m_errorHandler.fatalError(new TransformerException(wre.getException()));
            return;
        }
        catch (SAXParseException spe) {
            this.m_errorHandler.fatalError(new TransformerException(spe));
            return;
        }
        catch (SAXException se) {
            this.m_errorHandler.fatalError(new TransformerException(se));
            return;
        }
        catch (IOException ioe) {
            this.m_errorHandler.fatalError(new TransformerException(ioe));
            return;
        }
        finally {
            this.m_hasTransformThreadErrorCatcher = false;
            this.reset();
        }
    }

    public String getBaseURLOfSource() {
        return this.m_urlOfSource;
    }

    public void setBaseURLOfSource(String base) {
        this.m_urlOfSource = base;
    }

    public Result getOutputTarget() {
        return this.m_outputTarget;
    }

    public void setOutputTarget(Result outputTarget) {
        this.m_outputTarget = outputTarget;
    }

    public String getOutputProperty(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = props.getProperty(qnameString);
        if (null == value && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException("output property not recognized: " + qnameString);
        }
        return value;
    }

    public String getOutputPropertyNoDefault(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = (String)props.getProperties().get(qnameString);
        if (null == value && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException("output property not recognized: " + qnameString);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (null == this.m_outputFormat) {
                this.m_outputFormat = (OutputProperties)this.getStylesheet().getOutputComposed().clone();
            }
            if (!this.m_outputFormat.isLegalPropertyKey(name)) {
                throw new IllegalArgumentException("output property not recognized: " + name);
            }
            this.m_outputFormat.setProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputProperties(Properties oformat) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (null != oformat) {
                String method = (String)oformat.get("method");
                this.m_outputFormat = null != method ? new OutputProperties(method) : new OutputProperties();
            }
            if (null != oformat) {
                this.m_outputFormat.copyFrom(oformat);
            }
            this.m_outputFormat.copyFrom(this.m_stylesheetRoot.getOutputProperties());
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.getOutputFormat().getProperties().clone();
    }

    public Node parseToNode(Source source) throws TransformerException {
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        InputSource xmlSource = SAXSource.sourceToInputSource(source);
        if (null == xmlSource) {
            throw new TransformerException("Can't transform a Source of type " + source.getClass().getName() + "!");
        }
        if (null != xmlSource.getSystemId()) {
            this.m_urlOfSource = xmlSource.getSystemId();
        }
        Node doc = null;
        try {
            XMLReader reader = null;
            if (source instanceof SAXSource) {
                reader = ((SAXSource)source).getXMLReader();
            }
            if (null == reader) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError ex2) {
                }
                catch (AbstractMethodError ame) {
                    // empty catch block
                }
            }
            if (null == reader) {
                reader = XMLReaderFactory.createXMLReader();
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException se) {
                // empty catch block
            }
            ContentHandler inputHandler = this.getInputContentHandler();
            Class<?> inputHandlerClass = inputHandler.getClass();
            inputHandler = (ContentHandler)inputHandlerClass.newInstance();
            reader.setContentHandler(inputHandler);
            if (inputHandler instanceof DTDHandler) {
                reader.setDTDHandler((DTDHandler)((Object)inputHandler));
            }
            try {
                if (inputHandler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", inputHandler);
                }
                if (inputHandler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/properties/declaration-handler", inputHandler);
                }
            }
            catch (SAXNotRecognizedException snre) {
                // empty catch block
            }
            try {
                if (inputHandler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", inputHandler);
                }
                if (inputHandler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/DeclHandler", inputHandler);
                }
            }
            catch (SAXNotRecognizedException snre) {
                // empty catch block
            }
            this.getXPathContext().setPrimaryReader(reader);
            if (inputHandler instanceof SourceTreeHandler) {
                reader.parse(xmlSource);
                doc = ((SourceTreeHandler)inputHandler).getRoot();
            }
        }
        catch (IllegalAccessException iae) {
            throw new TransformerException(iae);
        }
        catch (InstantiationException ie) {
            throw new TransformerException(ie);
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe);
        }
        return doc;
    }

    public ContentHandler createResultContentHandler(Result outputTarget) throws TransformerException {
        return this.createResultContentHandler(outputTarget, this.getOutputFormat());
    }

    public ContentHandler createResultContentHandler(Result outputTarget, OutputProperties format) throws TransformerException {
        ContentHandler handler;
        Node outputNode = null;
        if (outputTarget instanceof DOMResult) {
            Document doc;
            short type;
            outputNode = ((DOMResult)outputTarget).getNode();
            if (null != outputNode) {
                type = outputNode.getNodeType();
                doc = 9 == type ? (Document)outputNode : outputNode.getOwnerDocument();
            } else {
                doc = this.getXPathContext().getDOMHelper().createDocument();
                outputNode = doc;
                type = outputNode.getNodeType();
                ((DOMResult)outputTarget).setNode(outputNode);
            }
            handler = 11 == type ? new DOMBuilder(doc, (DocumentFragment)outputNode) : new DOMBuilder(doc, outputNode);
        } else if (outputTarget instanceof SAXResult) {
            handler = ((SAXResult)outputTarget).getHandler();
            if (null == handler) {
                throw new IllegalArgumentException("handler can not be null for a SAXResult");
            }
        } else if (outputTarget instanceof StreamResult) {
            StreamResult sresult = (StreamResult)outputTarget;
            try {
                Serializer serializer = SerializerFactory.getSerializer(format.getProperties());
                if (null != sresult.getWriter()) {
                    serializer.setWriter(sresult.getWriter());
                } else if (null != sresult.getOutputStream()) {
                    serializer.setOutputStream(sresult.getOutputStream());
                } else if (null != sresult.getSystemId()) {
                    String fileURL = sresult.getSystemId();
                    if (fileURL.startsWith("file:///")) {
                        fileURL = fileURL.substring(8);
                    }
                    this.m_outputStream = new FileOutputStream(fileURL);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException("No output specified!");
                }
                handler = serializer.asContentHandler();
                this.setSerializer(serializer);
            }
            catch (UnsupportedEncodingException uee) {
                throw new TransformerException(uee);
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
        } else {
            throw new TransformerException("Can't transform to a Result of type " + outputTarget.getClass().getName() + "!");
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            ContentHandler handler = this.createResultContentHandler(outputTarget);
            this.m_outputTarget = outputTarget;
            this.setContentHandler(handler);
            this.transform(xmlSource);
        }
    }

    public void transformNode(Node node, Result outputTarget) throws TransformerException {
        ContentHandler handler = this.createResultContentHandler(outputTarget);
        this.m_outputTarget = outputTarget;
        this.setContentHandler(handler);
        this.transformNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformNode(Node node) throws TransformerException {
        ContentHandler contentHandler = this.m_outputContentHandler;
        synchronized (contentHandler) {
            this.m_hasBeenReset = false;
            try {
                this.pushGlobalVars(node);
                StylesheetRoot stylesheet = this.getStylesheet();
                int n = stylesheet.getGlobalImportCount();
                for (int i = 0; i < n; ++i) {
                    StylesheetComposed imported = stylesheet.getGlobalImport(i);
                    int includedCount = imported.getIncludeCountComposed();
                    for (int j = -1; j < includedCount; ++j) {
                        Stylesheet included = imported.getIncludeComposed(j);
                        included.runtimeInit(this);
                        for (ElemTemplateElement child = included.getFirstChildElem(); child != null; child = child.getNextSiblingElem()) {
                            child.runtimeInit(this);
                        }
                    }
                }
                this.applyTemplateToNode(null, null, node, null);
                if (null != this.m_resultTreeHandler) {
                    this.m_resultTreeHandler.endDocument();
                }
            }
            catch (TransformerException se) {
                if (null != this.m_resultTreeHandler) {
                    try {
                        this.m_resultTreeHandler.endDocument();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw se;
            }
            catch (Exception se) {
                if (null != this.m_resultTreeHandler) {
                    try {
                        this.m_resultTreeHandler.endDocument();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw new TransformerException(se.getMessage(), se);
            }
            finally {
                this.reset();
            }
        }
    }

    public ContentHandler getInputContentHandler() {
        return this.getInputContentHandler(false);
    }

    public ContentHandler getInputContentHandler(boolean doDocFrag) {
        if (null == this.m_inputContentHandler) {
            this.m_inputContentHandler = new SourceTreeHandler(this, doDocFrag);
            ((SourceTreeHandler)this.m_inputContentHandler).setUseMultiThreading(true);
        }
        return this.m_inputContentHandler;
    }

    public DeclHandler getInputDeclHandler() {
        if (this.m_inputContentHandler instanceof DeclHandler) {
            return (DeclHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public LexicalHandler getInputLexicalHandler() {
        if (this.m_inputContentHandler instanceof LexicalHandler) {
            return (LexicalHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public void setOutputFormat(OutputProperties oformat) {
        this.m_outputFormat = oformat;
    }

    public OutputProperties getOutputFormat() {
        OutputProperties format = null == this.m_outputFormat ? this.getStylesheet().getOutputComposed() : this.m_outputFormat;
        return format;
    }

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    public void setSerializer(Serializer s) {
        this.m_serializer = s;
    }

    public void setParameter(String name, String namespace, Object value) {
        this.setParameter(new QName(namespace, name), value);
    }

    public void setParameter(QName pQame, Object value) {
        VariableStack varstack = this.getXPathContext().getVarStack();
        XObject xobject = XObject.create(value);
        varstack.pushOrReplaceParameter(pQame, xobject);
    }

    public void setParameter(String name, Object value) {
        this.setParameter(QName.getQNameFromString(name), value);
    }

    public Object getParameter(String name) {
        try {
            QName vQname = QName.getQNameFromString(name);
            VariableStack vVarStack = this.getXPathContext().getVarStack();
            Arg vArg = vVarStack.getParamArg(vQname);
            if (vArg != null) {
                return vArg.getVal().object();
            }
            return null;
        }
        catch (TransformerException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            VariableStack varstack = new VariableStack();
            this.getXPathContext().setVarStack(varstack);
        }
    }

    public void pushParams(XPathContext xctxt, ElemCallTemplate xslCallTemplateElement, Node sourceNode, QName mode) throws TransformerException {
        VariableStack vars = xctxt.getVarStack();
        int n = xslCallTemplateElement.getParamElemCount();
        int paramDeclareContext = vars.getSearchStartOrTop();
        vars.pushContextMarker();
        int paramReferenceContext = -1;
        for (int i = 0; i < n; ++i) {
            XObject var;
            vars.setSearchStart(paramDeclareContext);
            ElemWithParam xslParamElement = xslCallTemplateElement.getParamElem(i);
            XPath param = xslParamElement.getSelect();
            if (null != param) {
                var = param.execute(this.getXPathContext(), sourceNode, xslParamElement);
            } else if (null == xslParamElement.getFirstChild()) {
                var = XString.EMPTYSTRING;
            } else {
                DocumentFragment df = this.transformToRTF(xslParamElement, sourceNode, mode);
                var = new XRTreeFrag(df);
            }
            vars.setSearchStart(paramReferenceContext);
            vars.pushVariableArg(new Arg(xslParamElement.getName(), var, true));
        }
    }

    protected void pushGlobalVars(Node contextNode) throws TransformerException {
        XPathContext xctxt = this.getXPathContext();
        VariableStack vs = xctxt.getVarStack();
        StylesheetRoot sr = this.getStylesheet();
        Vector vars = sr.getVariablesAndParamsComposed();
        int startGlobals = vs.size();
        int i = vars.size();
        while (--i >= 0) {
            XUnresolvedVariable xobj;
            ElemVariable v = (ElemVariable)vars.elementAt(i);
            Arg previouslyDeclared = vs.getDeclaredVariable(v.getName());
            if (null != previouslyDeclared) {
                if (v instanceof ElemParam && previouslyDeclared.isFromWithParam()) {
                    previouslyDeclared.setIsVisible(true);
                    continue;
                }
                xobj = new XUnresolvedVariable(v, contextNode, this, vs.getSearchStartOrTop(), 0, true);
                previouslyDeclared.setVal(xobj);
                continue;
            }
            xobj = new XUnresolvedVariable(v, contextNode, this, vs.getSearchStartOrTop(), 0, true);
            vs.pushVariable(v.getName(), xobj);
            vs.markGlobalStackFrame();
        }
        vs.markGlobalStackFrame();
        int endGlobals = vs.size();
        for (i = startGlobals; i < endGlobals; ++i) {
            Arg arg = (Arg)vs.elementAt(i);
            XUnresolvedVariable uv = (XUnresolvedVariable)arg.getVal();
            uv.setVarStackPos(endGlobals);
        }
        vs.pushContextMarker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURIResolver(URIResolver resolver) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            this.getXPathContext().getSourceTreeManager().setURIResolver(resolver);
        }
    }

    public URIResolver getURIResolver() {
        return this.getXPathContext().getSourceTreeManager().getURIResolver();
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Null content handler");
        }
        this.m_outputContentHandler = handler;
        if (null == this.m_resultTreeHandler) {
            this.m_resultTreeHandler = new ResultTreeHandler(this, handler);
        } else {
            this.m_resultTreeHandler.setContentHandler(handler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.m_outputContentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFragment transformToRTF(ElemTemplateElement templateParent, Node sourceNode, QName mode) throws TransformerException {
        DocumentFragment resultFragment;
        ContentHandler rtfHandler;
        boolean isSTree = sourceNode instanceof Child;
        if (isSTree) {
            rtfHandler = new SourceTreeHandler(this, true);
            rtfHandler.setUseMultiThreading(false);
            rtfHandler.setShouldTransformAtEnd(false);
            resultFragment = (DocumentFragment)rtfHandler.getRoot();
        } else {
            if (null == this.m_docBuilder) {
                try {
                    DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                    dfactory.setNamespaceAware(true);
                    dfactory.setValidating(true);
                    this.m_docBuilder = dfactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException pce) {
                    throw new TransformerException(pce);
                }
            }
            Document docFactory = this.m_docBuilder.newDocument();
            resultFragment = docFactory.createDocumentFragment();
            rtfHandler = new DOMBuilder(docFactory, resultFragment);
        }
        ResultTreeHandler savedRTreeHandler = this.m_resultTreeHandler;
        ResultTreeHandler rth = this.m_resultTreeHandler = new ResultTreeHandler(this, rtfHandler);
        try {
            rth.startDocument();
            try {
                this.executeChildTemplates(templateParent, sourceNode, mode, true);
                rth.flushPending();
            }
            finally {
                rth.endDocument();
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        finally {
            this.m_resultTreeHandler = savedRTreeHandler;
        }
        return resultFragment;
    }

    public ObjectPool getStringWriterPool() {
        return this.m_stringWriterObjectPool;
    }

    public String transformToString(ElemTemplateElement elem, Node sourceNode, QName mode) throws TransformerException {
        String result;
        ResultTreeHandler savedRTreeHandler = this.m_resultTreeHandler;
        StringWriter sw = (StringWriter)this.m_stringWriterObjectPool.getInstance();
        this.m_resultTreeHandler = (ResultTreeHandler)this.m_textResultHandlerObjectPool.getInstance();
        Serializer serializer = this.m_resultTreeHandler.getSerializer();
        try {
            if (null == serializer) {
                serializer = SerializerFactory.getSerializer(this.m_textformat.getProperties());
                this.m_resultTreeHandler.setSerializer(serializer);
                serializer.setWriter(sw);
                ContentHandler shandler = serializer.asContentHandler();
                this.m_resultTreeHandler.init(this, shandler);
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe);
        }
        try {
            this.m_resultTreeHandler.startDocument();
            this.executeChildTemplates(elem, sourceNode, mode, true);
            this.m_resultTreeHandler.endDocument();
            result = sw.toString();
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        finally {
            sw.getBuffer().setLength(0);
            try {
                sw.close();
            }
            catch (Exception ioe) {}
            this.m_stringWriterObjectPool.freeInstance(sw);
            this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
            this.m_resultTreeHandler.reset();
            this.m_resultTreeHandler = savedRTreeHandler;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTemplateToNode(ElemTemplateElement xslInstruction, ElemTemplateElement template, Node child, QName mode) throws TransformerException {
        short nodeType = child.getNodeType();
        boolean isDefaultTextRule = false;
        if (null == template) {
            boolean isApplyImports = xslInstruction == null ? false : xslInstruction.getXSLToken() == 72;
            int maxImportLevel = isApplyImports ? xslInstruction.getStylesheetComposed().getImportCountComposed() - 1 : -1;
            if (isApplyImports && maxImportLevel == -1) {
                template = null;
            } else {
                XPathContext xctxt = this.getXPathContext();
                PrefixResolver savedPrefixResolver = xctxt.getPrefixResolver();
                try {
                    xctxt.setPrefixResolver(xslInstruction);
                    template = this.m_stylesheetRoot.getTemplateComposed(xctxt, child, mode, maxImportLevel, this.m_quietConflictWarnings);
                }
                finally {
                    xctxt.setPrefixResolver(savedPrefixResolver);
                }
            }
            if (null == template) {
                switch (nodeType) {
                    case 1: 
                    case 11: {
                        template = this.m_stylesheetRoot.getDefaultRule();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        template = this.m_stylesheetRoot.getDefaultTextRule();
                        isDefaultTextRule = true;
                        break;
                    }
                    case 9: {
                        template = this.m_stylesheetRoot.getDefaultRootRule();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        try {
            this.pushElemTemplateElement(template);
            this.m_xcontext.pushCurrentNode(child);
            this.pushPairCurrentMatched(template, child);
            if (isDefaultTextRule) {
                switch (nodeType) {
                    case 3: 
                    case 4: {
                        this.m_resultTreeHandler.m_cloner.cloneToResultTree(child, false);
                        break;
                    }
                    case 2: {
                        String val = ((Attr)child).getValue();
                        this.getResultTreeHandler().characters(val);
                    }
                }
            } else {
                this.m_xcontext.setSAXLocator(template);
                if (template.isCompiledTemplate()) {
                    template.execute(this, child, mode);
                } else {
                    this.executeChildTemplates(template, child, mode, true);
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        finally {
            this.m_xcontext.popCurrentNode();
            this.popCurrentMatched();
            this.popElemTemplateElement();
        }
        return true;
    }

    public void executeChildTemplates(ElemTemplateElement elem, Node sourceNode, QName mode, ContentHandler handler) throws TransformerException {
        ResultTreeHandler rth = this.getResultTreeHandler();
        ContentHandler savedRTHHandler = rth.getContentHandler();
        ContentHandler savedHandler = this.getContentHandler();
        try {
            this.getResultTreeHandler().flushPending();
            this.setContentHandler(handler);
            this.executeChildTemplates(elem, sourceNode, mode, true);
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
        finally {
            this.setContentHandler(savedHandler);
            rth.setContentHandler(savedRTHHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeChildTemplates(ElemTemplateElement elem, Node sourceNode, QName mode, boolean shouldAddAttrs) throws TransformerException {
        boolean check;
        ElemTemplateElement t = elem.getFirstChildElem();
        if (null == t) {
            return;
        }
        XPathContext xctxt = this.getXPathContext();
        boolean bl = check = this.m_stackGuard.m_recursionLimit > -1;
        if (check) {
            this.getStackGuard().push(elem, sourceNode);
        }
        VariableStack varstack = this.getXPathContext().getVarStack();
        varstack.pushElemFrame();
        SourceLocator savedLocator = xctxt.getSAXLocator();
        try {
            this.pushElemTemplateElement(null);
            while (t != null) {
                if (shouldAddAttrs || t.getXSLToken() != 48) {
                    xctxt.setSAXLocator(t);
                    this.m_currentTemplateElements.setTail(t);
                    t.execute(this, sourceNode, mode);
                }
                t = t.getNextSiblingElem();
            }
        }
        finally {
            this.popElemTemplateElement();
            xctxt.setSAXLocator(savedLocator);
            varstack.popElemFrame();
        }
        if (check) {
            this.getStackGuard().pop();
        }
    }

    public Vector processSortKeys(ElemForEach foreach, Node sourceNodeContext) throws TransformerException {
        Vector<NodeSortKey> keys = null;
        XPathContext xctxt = this.getXPathContext();
        int nElems = foreach.getSortElemCount();
        if (nElems > 0) {
            keys = new Vector<NodeSortKey>();
        }
        for (int i = 0; i < nElems; ++i) {
            boolean caseOrderUpper;
            ElemSort sort = foreach.getSortElem(i);
            String langString = null != sort.getLang() ? sort.getLang().evaluate(xctxt, sourceNodeContext, foreach) : null;
            String dataTypeString = sort.getDataType().evaluate(xctxt, sourceNodeContext, foreach);
            if (dataTypeString.indexOf(":") >= 0) {
                System.out.println("TODO: Need to write the hooks for QNAME sort data type");
            } else if (!dataTypeString.equalsIgnoreCase("text") && !dataTypeString.equalsIgnoreCase("number")) {
                foreach.error(93, new Object[]{"data-type", dataTypeString});
            }
            boolean treatAsNumbers = null != dataTypeString && dataTypeString.equals("number");
            String orderString = sort.getOrder().evaluate(xctxt, sourceNodeContext, foreach);
            if (!orderString.equalsIgnoreCase("ascending") && !orderString.equalsIgnoreCase("descending")) {
                foreach.error(93, new Object[]{"order", orderString});
            }
            boolean descending = null != orderString && orderString.equals("descending");
            AVT caseOrder = sort.getCaseOrder();
            if (null != caseOrder) {
                String caseOrderString = caseOrder.evaluate(xctxt, sourceNodeContext, foreach);
                if (!caseOrderString.equalsIgnoreCase("upper-first") && !caseOrderString.equalsIgnoreCase("lower-first")) {
                    foreach.error(93, new Object[]{"case-order", caseOrderString});
                }
                caseOrderUpper = null != caseOrderString && caseOrderString.equals("upper-first");
            } else {
                caseOrderUpper = false;
            }
            keys.addElement(new NodeSortKey(this, sort.getSelect(), treatAsNumbers, descending, langString, caseOrderUpper, foreach));
        }
        return keys;
    }

    public void pushElemTemplateElement(ElemTemplateElement elem) {
        this.m_currentTemplateElements.push(elem);
    }

    public void popElemTemplateElement() {
        this.m_currentTemplateElements.pop();
    }

    public void setCurrentElement(ElemTemplateElement e) {
        this.m_currentTemplateElements.setTail(e);
    }

    public ElemTemplateElement getCurrentElement() {
        return (ElemTemplateElement)this.m_currentTemplateElements.peepTail();
    }

    public Node getCurrentNode() {
        return this.m_xcontext.getCurrentNode();
    }

    public ElemTemplate getCurrentTemplate() {
        ElemTemplateElement elem;
        for (elem = this.getCurrentElement(); null != elem && elem.getXSLToken() != 19; elem = elem.getParentElem()) {
        }
        return (ElemTemplate)elem;
    }

    public void pushPairCurrentMatched(ElemTemplateElement template, Node child) {
        this.m_currentMatchTemplates.pushPair(template, child);
    }

    public void popCurrentMatched() {
        this.m_currentMatchTemplates.popPair();
    }

    public ElemTemplate getMatchedTemplate() {
        return (ElemTemplate)this.m_currentMatchTemplates.peepTailSub1();
    }

    public Node getMatchedNode() {
        return this.m_currentMatchTemplates.peepTail();
    }

    public NodeIterator getContextNodeList() {
        try {
            ContextNodeList cnl = this.getXPathContext().getContextNodeList();
            return cnl == null ? null : cnl.cloneWithReset();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public Transformer getTransformer() {
        return this;
    }

    public void setStylesheet(StylesheetRoot stylesheetRoot) {
        this.m_stylesheetRoot = stylesheetRoot;
    }

    public StylesheetRoot getStylesheet() {
        return this.m_stylesheetRoot;
    }

    public boolean getQuietConflictWarnings() {
        return this.m_quietConflictWarnings;
    }

    public void setQuietConflictWarnings(boolean b) {
        this.m_quietConflictWarnings = b;
    }

    public void setXPathContext(XPathContext xcontext) {
        this.m_xcontext = xcontext;
    }

    public XPathContext getXPathContext() {
        return this.m_xcontext;
    }

    public StackGuard getStackGuard() {
        return this.m_stackGuard;
    }

    public int getRecursionLimit() {
        return this.m_stackGuard.getRecursionLimit();
    }

    public void setRecursionLimit(int limit) {
        this.m_stackGuard.setRecursionLimit(limit);
    }

    public ResultTreeHandler getResultTreeHandler() {
        return this.m_resultTreeHandler;
    }

    public KeyManager getKeyManager() {
        return this.m_keyManager;
    }

    public boolean isRecursiveAttrSet(ElemAttributeSet attrSet) {
        int loc;
        if (null == this.m_attrSetStack) {
            this.m_attrSetStack = new Stack();
        }
        return !this.m_attrSetStack.empty() && (loc = this.m_attrSetStack.search(attrSet)) > -1;
    }

    public void pushElemAttributeSet(ElemAttributeSet attrSet) {
        this.m_attrSetStack.push(attrSet);
    }

    public void popElemAttributeSet() {
        this.m_attrSetStack.pop();
    }

    public CountersTable getCountersTable() {
        if (null == this.m_countersTable) {
            this.m_countersTable = new CountersTable();
        }
        return this.m_countersTable;
    }

    public boolean currentTemplateRuleIsNull() {
        return !this.m_currentTemplateRuleIsNull.isEmpty() && this.m_currentTemplateRuleIsNull.peek();
    }

    public void pushCurrentTemplateRuleIsNull(boolean b) {
        this.m_currentTemplateRuleIsNull.push(b);
    }

    public void popCurrentTemplateRuleIsNull() {
        this.m_currentTemplateRuleIsNull.pop();
    }

    public MsgMgr getMsgMgr() {
        if (null == this.m_msgMgr) {
            this.m_msgMgr = new MsgMgr(this);
        }
        return this.m_msgMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (listener == null) {
                throw new IllegalArgumentException("Null error handler");
            }
            this.m_errorHandler = listener;
        }
    }

    public ErrorListener getErrorListener() {
        return this.m_errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/trax/features/sax/input".equals(name)) {
            return true;
        }
        if ("http://xml.org/trax/features/dom/input".equals(name)) {
            return true;
        }
        throw new SAXNotRecognizedException(name);
    }

    public static void setThreadControler(ThreadControler tp) {
        tpool = tp;
    }

    public void runTransformThread(int priority) {
        Thread t = tpool.run(this, priority);
        this.setTransformThread(t);
    }

    public void runTransformThread() {
        tpool.run(this, -1);
    }

    public void waitTransformThread() throws SAXException {
        Thread transformThread = this.getTransformThread();
        if (null != transformThread) {
            try {
                Exception e;
                tpool.waitThread(transformThread, this);
                if (!this.hasTransformThreadErrorCatcher() && null != (e = this.getExceptionThrown())) {
                    throw new SAXException(e);
                }
                this.setTransformThread(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Exception getExceptionThrown() {
        return this.m_exceptionThrown;
    }

    public void setSourceTreeDocForThread(Node doc) {
        this.m_doc = doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransformDone() {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            return this.m_isTransformDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postExceptionFromThread(Exception e) {
        ContentHandler ch;
        if (this.m_inputContentHandler instanceof SourceTreeHandler) {
            SourceTreeHandler sth = (SourceTreeHandler)this.m_inputContentHandler;
            sth.setExceptionThrown(e);
        }
        if ((ch = this.getContentHandler()) instanceof SourceTreeHandler) {
            SourceTreeHandler sth = (SourceTreeHandler)ch;
            ((TransformerImpl)sth.getTransformer()).postExceptionFromThread(e);
        }
        this.m_isTransformDone = true;
        this.m_exceptionThrown = e;
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block17: {
            this.m_hasBeenReset = false;
            try {
                if (this.isParserEventsOnMain()) {
                    try {
                        this.m_isTransformDone = false;
                        this.transformNode(this.m_doc);
                        break block17;
                    }
                    catch (Exception e) {
                        this.postExceptionFromThread(e);
                        break block17;
                    }
                    finally {
                        this.m_isTransformDone = true;
                        TransformerImpl e = this;
                        synchronized (e) {
                            this.notifyAll();
                        }
                    }
                }
                InputSource isource = SAXSource.sourceToInputSource(this.m_xmlSource);
                this.getXPathContext().getPrimaryReader().parse(isource);
            }
            catch (Exception e) {
                this.postExceptionFromThread(e);
            }
        }
    }

    public TransformSnapshot getSnapshot() {
        return new TransformSnapshotImpl(this);
    }

    public void executeFromSnapshot(TransformSnapshot ts) throws TransformerException {
        ElemTemplate template = this.getMatchedTemplate();
        Node child = this.getMatchedNode();
        this.pushElemTemplateElement(template);
        this.m_xcontext.pushCurrentNode(child);
        this.executeChildTemplates((ElemTemplateElement)template, child, null, true);
    }

    public void resetToStylesheet(TransformSnapshot ts) {
        ((TransformSnapshotImpl)ts).apply(this);
    }

    public void stopTransformation() {
    }

    public static class ThreadControler {
        public Thread run(Runnable task, int priority) {
            Thread t = new Thread(task);
            t.start();
            return t;
        }

        public void waitThread(Thread worker, Runnable task) throws InterruptedException {
            worker.join();
        }
    }
}

