/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xalan.transformer;

import com.scenari.xsldom.xalan.transformer.ResultTreeHandler;
import com.scenari.xsldom.xalan.transformer.TransformerImpl;
import com.scenari.xsldom.xml.utils.TreeWalker;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.XPathContext;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TreeWalker2Result
extends TreeWalker {
    TransformerImpl m_transformer;
    ResultTreeHandler m_handler;
    Node m_startNode;

    public TreeWalker2Result(TransformerImpl transformer, ResultTreeHandler handler) {
        super(handler, transformer.getXPathContext().getDOMHelper());
        this.m_transformer = transformer;
        this.m_handler = handler;
    }

    public void traverse(Node pos) throws SAXException {
        this.m_startNode = pos;
        super.traverse(pos);
    }

    protected void endNode(Node node) throws SAXException {
        super.endNode(node);
        if (1 == node.getNodeType()) {
            this.m_transformer.getXPathContext().popCurrentNode();
        }
    }

    protected void startNode(Node node) throws SAXException {
        XPathContext xcntxt = this.m_transformer.getXPathContext();
        try {
            if (1 == node.getNodeType()) {
                xcntxt.pushCurrentNode(node);
                if (this.m_startNode != node) {
                    super.startNode(node);
                } else {
                    DOMHelper dhelper = xcntxt.getDOMHelper();
                    String elemName = node.getNodeName();
                    String localName = dhelper.getLocalNameOfNode(node);
                    String namespace = dhelper.getNamespaceOfNode(node);
                    xcntxt.pushCurrentNode(node);
                    this.m_handler.startElement(namespace, localName, elemName, null);
                    for (Node parent = node; parent != null; parent = parent.getParentNode()) {
                        if (1 != parent.getNodeType()) continue;
                        NamedNodeMap atts = ((Element)parent).getAttributes();
                        int n = atts.getLength();
                        for (int i = 0; i < n; ++i) {
                            String nsDeclPrefix = null;
                            Attr attr = (Attr)atts.item(i);
                            String name = attr.getName();
                            String value = attr.getValue();
                            if (name.startsWith("xmlns:")) {
                                nsDeclPrefix = name.substring(name.indexOf(":") + 1);
                            } else if (name.equals("xmlns")) {
                                nsDeclPrefix = "";
                            }
                            if (nsDeclPrefix == null && node != parent) continue;
                            this.m_handler.addAttribute(dhelper.getNamespaceOfNode(attr), dhelper.getLocalNameOfNode(attr), name, "CDATA", value);
                        }
                    }
                }
            } else {
                xcntxt.pushCurrentNode(node);
                super.startNode(node);
                xcntxt.popCurrentNode();
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }
}

