/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xml.utils;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler,
ErrorListener {
    public static final DefaultErrorHandler SINGLETON = new DefaultErrorHandler();

    public void warning(SAXParseException exception) throws SAXException {
        this.printLocation(exception);
        System.out.println("Parser warning: " + exception.getMessage());
    }

    public void error(SAXParseException exception) throws SAXException {
        this.printLocation(exception);
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.printLocation(exception);
        throw exception;
    }

    public void warning(TransformerException exception) throws TransformerException {
        this.printLocation(exception);
        System.out.println(exception.getMessage());
    }

    public void error(TransformerException exception) throws TransformerException {
        this.printLocation(exception);
        throw exception;
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        this.printLocation(exception);
        throw exception;
    }

    private void printLocation(SAXParseException exception) {
        String id = null != exception.getSystemId() ? exception.getSystemId() : "SystemId Unknown";
        System.out.print(id + "; Line " + exception.getLineNumber() + "; Column " + exception.getColumnNumber() + "; ");
    }

    private void printLocation(TransformerException exception) {
        SourceLocator locator = exception.getLocator();
        if (null != locator) {
            String id = locator.getPublicId() != locator.getPublicId() ? locator.getPublicId() : (null != locator.getSystemId() ? locator.getSystemId() : "SystemId Unknown");
            System.out.print(id + "; Line " + locator.getLineNumber() + "; Column " + locator.getColumnNumber() + "; ");
        }
    }
}

