/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath;

import com.scenari.xsldom.xml.utils.NodeVector;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
extends NodeVector
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    public static final NodeIterator NODE_ITERATOR_NULL = new NodeItNull();
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    private transient int m_last = 0;

    public NodeSet() {
    }

    public NodeSet(int blocksize) {
        super(blocksize);
    }

    public NodeSet(NodeList nodelist) {
        this.addNodes(nodelist);
    }

    public NodeSet(NodeSet nodelist) {
        this.addNodes((NodeIterator)nodelist);
    }

    public NodeSet(NodeIterator ni) {
        this.addNodes(ni);
    }

    public NodeSet(Node node) {
        super(2);
        this.addNode(node);
    }

    public Node getRoot() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)super.clone();
        return clone;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)this.clone();
        clone.reset();
        return clone;
    }

    public void reset() {
        this.m_next = 0;
    }

    public int getWhatToShow() {
        return -17;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node next = this.elementAt(this.m_next);
            ++this.m_next;
            return next;
        }
        return null;
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public void detach() {
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public void runTo(int index) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    public Node item(int index) {
        this.runTo(index);
        return this.elementAt(index);
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public void addNode(Node n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.addElement(n);
    }

    public void insertNode(Node n, int pos) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.insertElementAt(n, pos);
    }

    public void removeNode(Node n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.removeElement(n);
    }

    public void addNodes(NodeList nodelist) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        if (null != nodelist) {
            int nChildren = nodelist.getLength();
            for (int i = 0; i < nChildren; ++i) {
                Node obj = nodelist.item(i);
                if (null == obj) continue;
                this.addElement(obj);
            }
        }
    }

    public void addNodes(NodeSet ns) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.addNodes((NodeIterator)ns);
    }

    public void addNodes(NodeIterator iterator) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        if (null != iterator) {
            Node obj;
            while (null != (obj = iterator.nextNode())) {
                this.addElement(obj);
            }
        }
    }

    public void addNodesInDocOrder(NodeList nodelist, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        int nChildren = nodelist.getLength();
        for (int i = 0; i < nChildren; ++i) {
            Node node = nodelist.item(i);
            if (null == node) continue;
            this.addNodeInDocOrder(node, support);
        }
    }

    public void addNodesInDocOrder(NodeIterator iterator, XPathContext support) {
        Node node;
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        while (null != (node = iterator.nextNode())) {
            this.addNodeInDocOrder(node, support);
        }
    }

    private boolean addNodesInDocOrder(int start, int end, int testIndex, NodeList nodelist, XPathContext support) {
        int i;
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        boolean foundit = false;
        Node node = nodelist.item(testIndex);
        for (i = end; i >= start; --i) {
            boolean foundPrev;
            Node child = this.elementAt(i);
            if (child == node) {
                i = -2;
                break;
            }
            if (support.getDOMHelper().isNodeAfter(node, child)) continue;
            this.insertElementAt(node, i + 1);
            if (--testIndex <= 0 || (foundPrev = this.addNodesInDocOrder(0, i, testIndex, nodelist, support))) break;
            this.addNodesInDocOrder(i, this.size() - 1, testIndex, nodelist, support);
            break;
        }
        if (i == -1) {
            this.insertElementAt(node, 0);
        }
        return foundit;
    }

    public int addNodeInDocOrder(Node node, boolean test, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        int insertIndex = -1;
        if (test) {
            int i;
            int size = this.size();
            for (i = size - 1; i >= 0; --i) {
                Node child = this.elementAt(i);
                if (child == node) {
                    i = -2;
                    break;
                }
                if (!support.getDOMHelper().isNodeAfter(node, child)) break;
            }
            if (i != -2) {
                insertIndex = i + 1;
                this.insertElementAt(node, insertIndex);
            }
        } else {
            insertIndex = this.size();
            boolean foundit = false;
            for (int i = 0; i < insertIndex; ++i) {
                if (!this.item(i).equals(node)) continue;
                foundit = true;
                break;
            }
            if (!foundit) {
                this.addElement(node);
            }
        }
        return insertIndex;
    }

    public int addNodeInDocOrder(Node node, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        return this.addNodeInDocOrder(node, true, support);
    }

    public int size() {
        return super.size();
    }

    public void addElement(Node value) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.addElement(value);
    }

    public void insertElementAt(Node value, int at) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.insertElementAt(value, at);
    }

    public void appendNodes(NodeVector nodes) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.appendNodes(nodes);
    }

    public void removeAllElements() {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.removeAllElements();
    }

    public boolean removeElement(Node s) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        return super.removeElement(s);
    }

    public void removeElementAt(int i) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.removeElementAt(i);
    }

    public void setElementAt(Node node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.setElementAt(node, index);
    }

    public Node elementAt(int i) {
        this.runTo(i);
        return super.elementAt(i);
    }

    public boolean contains(Node s) {
        this.runTo(-1);
        return super.contains(s);
    }

    public int indexOf(Node elem, int index) {
        this.runTo(-1);
        return super.indexOf(elem, index);
    }

    public int indexOf(Node elem) {
        this.runTo(-1);
        return super.indexOf(elem);
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public void setCurrentPos(int i) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = i;
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        int saved = this.m_next;
        Node n = this.elementAt(this.m_next - 1);
        this.m_next = saved;
        return n;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public void setShouldCacheNodes(boolean b) {
        if (!this.isFresh()) {
            throw new RuntimeException("Can not call setShouldCacheNodes after nextNode has been called!");
        }
        this.m_cacheNodes = b;
        this.m_mutable = true;
    }

    public int getLast() {
        return this.m_last;
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public static class NodeItNull
    implements NodeIterator,
    ContextNodeList {
        public void detach() {
        }

        public boolean getExpandEntityReferences() {
            return false;
        }

        public NodeFilter getFilter() {
            return null;
        }

        public Node getRoot() {
            return null;
        }

        public int getWhatToShow() {
            return 0;
        }

        public Node nextNode() throws DOMException {
            return null;
        }

        public Node previousNode() throws DOMException {
            return null;
        }

        public NodeIterator cloneWithReset() throws CloneNotSupportedException {
            return this;
        }

        public Node getCurrentNode() {
            return null;
        }

        public int getCurrentPos() {
            return 0;
        }

        public int getLast() {
            return 0;
        }

        public boolean isFresh() {
            return true;
        }

        public void reset() {
        }

        public void runTo(int pIndex) {
        }

        public void setCurrentPos(int pI) {
        }

        public void setLast(int pLast) {
        }

        public void setShouldCacheNodes(boolean pB) {
        }

        public int size() {
            return 0;
        }

        public Object clone() throws CloneNotSupportedException {
            return this;
        }
    }
}

