/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath;

import com.scenari.xsldom.xalan.stree.SourceTreeHandler;
import com.scenari.xsldom.xml.utils.SystemIDResolver;
import com.scenari.xsldom.xpath.SourceTree;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTreeManager {
    private Vector m_sourceTree = new Vector();
    URIResolver m_uriResolver;

    public void reset() {
        this.m_sourceTree = new Vector();
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public String findURIFromDoc(Document owner) {
        Document root = owner.getOwnerDocument();
        if (null == root) {
            root = owner;
        }
        String url = null;
        int n = this.m_sourceTree.size();
        for (int i = 0; i < n; ++i) {
            SourceTree sTree = (SourceTree)this.m_sourceTree.elementAt(i);
            if (root != sTree.m_root) continue;
            url = sTree.m_url;
            break;
        }
        return url;
    }

    public Source resolveURI(String base, String urlString, SourceLocator locator) throws TransformerException, IOException {
        Source source = null;
        if (null != this.m_uriResolver) {
            source = this.m_uriResolver.resolve(urlString, base);
        }
        if (null == source) {
            String uri = SystemIDResolver.getAbsoluteURI(urlString, base);
            source = new StreamSource(uri);
        }
        return source;
    }

    public void putDocumentInCache(Node n, Source source) {
        Node cachedNode = this.getNode(source);
        if (null != cachedNode) {
            if (!cachedNode.equals(n)) {
                throw new RuntimeException("Programmer's Error!  putDocumentInCache found reparse of doc: " + source.getSystemId());
            }
            return;
        }
        if (null != source.getSystemId()) {
            this.m_sourceTree.addElement(new SourceTree(n, source.getSystemId()));
        }
    }

    public Node getNode(Source source) {
        String url = source.getSystemId();
        if (null == url) {
            return null;
        }
        Node node = null;
        int n = this.m_sourceTree.size();
        for (int i = 0; i < n; ++i) {
            SourceTree sTree = (SourceTree)this.m_sourceTree.elementAt(i);
            if (!url.equals(sTree.m_url)) continue;
            node = sTree.m_root;
            break;
        }
        return node;
    }

    public Node getSourceTree(String base, String urlString, SourceLocator locator) throws TransformerException {
        try {
            Source source = this.resolveURI(base, urlString, locator);
            return this.getSourceTree(source, locator);
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), locator, ioe);
        }
    }

    public Node getSourceTree(Source source, SourceLocator locator) throws TransformerException {
        Node n = this.getNode(source);
        if (null != n) {
            return n;
        }
        n = this.getDOMNode(source, locator);
        if (null != n) {
            this.putDocumentInCache(n, source);
        }
        return n;
    }

    public Node getDOMNode(Source source, SourceLocator locator) throws TransformerException {
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        Node doc = null;
        try {
            XMLReader reader = this.getXMLReader(source, locator);
            SourceTreeHandler handler = new SourceTreeHandler();
            if (handler instanceof SourceTreeHandler) {
                handler.setUseMultiThreading(false);
            }
            reader.setContentHandler(handler);
            if (handler instanceof DTDHandler) {
                reader.setDTDHandler(handler);
            }
            try {
                if (handler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                }
                if (handler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
                }
            }
            catch (SAXException se) {
                // empty catch block
            }
            try {
                if (handler instanceof LexicalHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", handler);
                }
                if (handler instanceof DeclHandler) {
                    reader.setProperty("http://xml.org/sax/handlers/DeclHandler", handler);
                }
            }
            catch (SAXNotRecognizedException snre) {
                // empty catch block
            }
            InputSource isource = SAXSource.sourceToInputSource(source);
            reader.parse(isource);
            if (handler instanceof SourceTreeHandler) {
                doc = handler.getRoot();
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), locator, ioe);
        }
        catch (SAXException se) {
            throw new TransformerException(se.getMessage(), locator, se);
        }
        return doc;
    }

    public XMLReader getXMLReader(Source inputSource, SourceLocator locator) throws TransformerException {
        try {
            XMLReader reader;
            XMLReader xMLReader = reader = inputSource instanceof SAXSource ? ((SAXSource)inputSource).getXMLReader() : null;
            if (null == reader) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex) {
                    throw new SAXException(ex);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError ex2) {
                }
                catch (AbstractMethodError ame) {
                    // empty catch block
                }
                if (null == reader) {
                    reader = XMLReaderFactory.createXMLReader();
                }
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException se) {
                // empty catch block
            }
            return reader;
        }
        catch (SAXException se) {
            throw new TransformerException(se.getMessage(), locator, se);
        }
    }
}

