/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath;

import com.scenari.xsldom.xml.utils.IntStack;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xpath.Arg;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XObject;
import java.util.Stack;
import javax.xml.transform.TransformerException;

public class VariableStack
extends Stack {
    private IntStack m_elemFramePos = new IntStack();
    private static final Stack m_emptyStackFrame = new Stack();
    private int m_globalStackFrameIndex = -1;
    private int m_searchStart = -1;

    public VariableStack() {
        this.pushContextMarker();
    }

    public void setSearchStart(int startPos) {
        this.m_searchStart = startPos;
    }

    public int getSearchStartOrTop() {
        return -1 == this.m_searchStart ? this.size() - 1 : this.m_searchStart;
    }

    public int getSearchStart() {
        return this.m_searchStart;
    }

    public void markGlobalStackFrame() {
        this.m_globalStackFrameIndex = this.size();
    }

    public int getContextPos() {
        return this.size() - 1;
    }

    public void pushContextMarker() {
        this.push(m_emptyStackFrame);
    }

    public void popCurrentContext() {
        this.pop();
    }

    private Stack getCurrentFrame() {
        int stackFrameIndex = -1 == this.m_searchStart ? this.size() - 1 : this.m_searchStart;
        return (Stack)this.elementAt(stackFrameIndex);
    }

    private Stack allocateCurrentFrame() {
        int stackFrameIndex = -1 == this.m_searchStart ? this.size() - 1 : this.m_searchStart;
        Stack newFrame = new Stack();
        this.setElementAt(newFrame, stackFrameIndex);
        return newFrame;
    }

    public void pushOrReplaceParameter(QName qname, XObject xval) {
        Stack frame = this.getCurrentFrame();
        if (frame == m_emptyStackFrame) {
            frame = this.allocateCurrentFrame();
        }
        for (int i = frame.size() - 1; i >= 0; --i) {
            Arg arg = (Arg)frame.elementAt(i);
            if (!arg.getQName().equals(qname) || !arg.isFromWithParam()) continue;
            frame.setElementAt(new Arg(qname, xval, true), i);
            return;
        }
        frame.push(new Arg(qname, xval, true));
    }

    public void remarkParams() {
        Stack frame = this.getCurrentFrame();
        for (int i = frame.size() - 1; i >= 0; --i) {
            Arg arg = (Arg)frame.elementAt(i);
            if (null == arg) continue;
            arg.setIsVisible(false);
        }
    }

    public void pushVariable(QName qname, XObject val) {
        Stack frame = this.getCurrentFrame();
        if (frame == m_emptyStackFrame) {
            frame = this.allocateCurrentFrame();
        }
        frame.push(new Arg(qname, val, false));
    }

    public void pushVariableArg(Arg arg) {
        Stack frame = this.getCurrentFrame();
        if (frame == m_emptyStackFrame) {
            frame = this.allocateCurrentFrame();
        }
        frame.push(arg);
    }

    public Arg getDeclaredVariable(QName qname) throws TransformerException {
        Stack frame = this.getCurrentFrame();
        for (int i = frame.size() - 1; i >= 0; --i) {
            Object obj = frame.elementAt(i);
            if (!((Arg)obj).getQName().equals(qname)) continue;
            return (Arg)obj;
        }
        Stack gframe = (Stack)this.elementAt(0);
        if (gframe == frame) {
            return null;
        }
        for (int i = gframe.size() - 1; i >= 0; --i) {
            Object obj = gframe.elementAt(i);
            if (!((Arg)obj).getQName().equals(qname)) continue;
            return (Arg)obj;
        }
        return null;
    }

    public Arg getParamArg(QName qname) throws TransformerException {
        Object val = null;
        Stack frame = this.getCurrentFrame();
        for (int i = frame.size() - 1; i >= 0; --i) {
            Arg arg = (Arg)frame.elementAt(i);
            if (!arg.getQName().equals(qname) || !arg.isFromWithParam()) continue;
            return arg;
        }
        return null;
    }

    public XObject getVariable(XPathContext xctxt, QName name) throws TransformerException {
        Arg arg;
        int i;
        Stack gframe;
        Stack frame = this.getCurrentFrame();
        if (frame != (gframe = (Stack)this.elementAt(0))) {
            for (i = frame.size() - 1; i >= 0; --i) {
                arg = (Arg)frame.elementAt(i);
                if (!arg.getQName().equals(name) || !arg.isVisible()) continue;
                XObject val = arg.getVal();
                if (val.getType() == 600) {
                    val = val.execute(xctxt);
                    arg.setVal(val);
                }
                return val;
            }
        }
        for (i = gframe.size() - 1; i >= 0; --i) {
            arg = (Arg)gframe.elementAt(i);
            if (!arg.getQName().equals(name) || !arg.isVisible()) continue;
            XObject val = arg.getVal();
            if (val.getType() == 600) {
                val = val.execute(xctxt);
                arg.setVal(val);
            }
            return val;
        }
        return null;
    }

    public void pushElemFrame() {
        Stack frame = this.getCurrentFrame();
        this.m_elemFramePos.push(frame.size());
    }

    public void popElemFrame() {
        Stack frame = this.getCurrentFrame();
        int newSize = this.m_elemFramePos.pop();
        frame.setSize(newSize);
    }

    public void reset() {
        this.setSize(1);
        this.m_elemFramePos.removeAllElements();
        this.m_globalStackFrameIndex = -1;
        this.m_searchStart = -1;
    }
}

