/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath;

import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xml.utils.DefaultErrorHandler;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.SAXSourceLocator;
import com.scenari.xsldom.xml.utils.WrappedRuntimeException;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.compiler.Compiler;
import com.scenari.xsldom.xpath.compiler.FunctionTable;
import com.scenari.xsldom.xpath.compiler.XPathParser;
import com.scenari.xsldom.xpath.functions.Function;
import com.scenari.xsldom.xpath.objects.XObject;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class XPath
implements Serializable {
    private static final boolean DEBUG_MATCHES = false;
    public static final int MATCH = 1;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_OTHER = 0.5;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final int SELECT = 0;
    protected static Map sMap = new Hashtable(2500);
    protected static long sReused = 0L;
    protected Expression m_mainExp;
    protected String m_patternString;

    public static XPath createXPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type) throws TransformerException {
        return XPath.createXPath(exprString, locator, prefixResolver, type, null);
    }

    public static XPath createXPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        XPathKey vKey = new XPathKey(exprString, prefixResolver, type);
        Object vXpath = sMap.get(vKey);
        if (vXpath == null) {
            vXpath = new XPath(exprString, locator, vKey, type, errorListener);
            vKey.fResolver = null;
            sMap.put(vKey, vXpath);
        } else {
            ++sReused;
        }
        return (XPath)vXpath;
    }

    private XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type) throws TransformerException {
        this(exprString, locator, prefixResolver, type, null);
    }

    private XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        if (null == errorListener) {
            errorListener = DefaultErrorHandler.SINGLETON;
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator);
        if (0 == type) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException("Can not deal with XPath type: " + type);
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
    }

    public void assertion(boolean b, String msg) {
        if (!b) {
            String fMsg = XSLMessages.createXPATHMessage(30, new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    public void error(XPathContext xctxt, Node sourceNode, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.fatalError(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        } else {
            SourceLocator slocator = xctxt.getSAXLocator();
            System.out.println(fmsg + "; file " + slocator.getSystemId() + "; line " + slocator.getLineNumber() + "; column " + slocator.getColumnNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject execute(XPathContext xctxt, Node contextNode) throws TransformerException {
        XObject xobj;
        block10: {
            xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
            xobj = null;
            try {
                xobj = this.m_mainExp.execute(xctxt);
            }
            catch (TransformerException te) {
                ErrorListener el = xctxt.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block10;
                }
                throw te;
            }
            catch (Exception e) {
                while (e instanceof WrappedRuntimeException) {
                    e = ((WrappedRuntimeException)e).getException();
                }
                String msg = e.getMessage();
                msg = msg == null || msg.length() == 0 ? "Unknown error in XPath" : msg;
                TransformerException te = new TransformerException(msg, null, e);
                ErrorListener el = xctxt.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block10;
                }
                throw te;
            }
            finally {
                xctxt.popCurrentNodeAndExpression();
            }
        }
        return xobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject execute(XPathContext xctxt, Node contextNode, PrefixResolver namespaceContext) throws TransformerException {
        PrefixResolver savedPrefixResolver = xctxt.getPrefixResolver();
        try {
            xctxt.setPrefixResolver(namespaceContext);
            XObject xObject = this.execute(xctxt, contextNode);
            return xObject;
        }
        finally {
            xctxt.setPrefixResolver(savedPrefixResolver);
        }
    }

    public Expression getExpression() {
        return this.m_mainExp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchScore(XPathContext xctxt, Node context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.m_mainExp.execute(xctxt);
            double d = score.num();
            return d;
        }
        finally {
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
        }
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public void installFunction(String name, int funcIndex, Function func) {
        FunctionTable.installFunction(func, funcIndex);
    }

    public void setExpression(Expression exp) {
        this.m_mainExp = exp;
    }

    public void warn(XPathContext xctxt, Node sourceNode, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.warning(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        }
    }

    protected static class XPathKey
    implements PrefixResolver {
        protected String fPattern;
        protected boolean fCompilMatch;
        protected PrefixResolver fResolver;
        protected String[] fUsedPrefix = null;

        public XPathKey(String pExprString, PrefixResolver pPrefixResolver, int pType) {
            this.fPattern = pExprString;
            this.fResolver = pPrefixResolver;
            this.fCompilMatch = pType == 1;
        }

        public int hashCode() {
            return this.fPattern.hashCode();
        }

        public boolean equals(Object pObj) {
            if (pObj == null || !(pObj instanceof XPathKey)) {
                return false;
            }
            if (this.fResolver != null) {
                return pObj.equals(this);
            }
            XPathKey vOther = (XPathKey)pObj;
            if (!vOther.fPattern.equals(this.fPattern) || this.fCompilMatch != vOther.fCompilMatch) {
                return false;
            }
            if (this.fUsedPrefix != null) {
                if (vOther.fResolver == null) {
                    return false;
                }
                int len = this.fUsedPrefix.length;
                for (int i = 0; i < len; i += 2) {
                    String vOtherNs = vOther.fResolver.getNamespaceForPrefix(this.fUsedPrefix[i]);
                    if (vOtherNs == null) {
                        vOtherNs = "";
                    }
                    if (vOtherNs.equals(this.fUsedPrefix[i + 1])) continue;
                    return false;
                }
            }
            return true;
        }

        public String getBaseIdentifier() {
            return this.fResolver.getBaseIdentifier();
        }

        public String getNamespaceForPrefix(String prefix, Node context) {
            return this.getNamespaceForPrefix(prefix);
        }

        public String getNamespaceForPrefix(String pPrefix) {
            String vNs = this.fResolver.getNamespaceForPrefix(pPrefix);
            if (vNs == null) {
                vNs = "";
            }
            if (this.fUsedPrefix == null) {
                this.fUsedPrefix = new String[2];
                this.fUsedPrefix[0] = pPrefix;
                this.fUsedPrefix[1] = vNs;
            } else {
                int vLen = this.fUsedPrefix.length;
                String[] vNew = new String[vLen + 2];
                System.arraycopy(this.fUsedPrefix, 0, vNew, 0, vLen);
                this.fUsedPrefix = vNew;
                this.fUsedPrefix[vLen] = pPrefix;
                this.fUsedPrefix[vLen + 1] = vNs;
            }
            return vNs;
        }
    }
}

