/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath;

import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.PrefixResolverDefault;
import com.scenari.xsldom.xpath.NodeSet;
import com.scenari.xsldom.xpath.XPath;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.objects.XObject;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPathAPI {
    public static Node selectSingleNode(Node contextNode, String str) throws TransformerException {
        return XPathAPI.selectSingleNode(contextNode, str, contextNode);
    }

    public static Node selectSingleNode(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        NodeIterator nl = XPathAPI.selectNodeIterator(contextNode, str, namespaceNode);
        return nl.nextNode();
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String str) throws TransformerException {
        return XPathAPI.selectNodeIterator(contextNode, str, contextNode);
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        XObject list = XPathAPI.eval(contextNode, str, namespaceNode);
        return list.nodeset();
    }

    public static NodeList selectNodeList(Node contextNode, String str) throws TransformerException {
        return XPathAPI.selectNodeList(contextNode, str, contextNode);
    }

    public static NodeList selectNodeList(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        XObject list = XPathAPI.eval(contextNode, str, namespaceNode);
        NodeSet nodeset = list.mutableNodeset();
        nodeset.setShouldCacheNodes(true);
        return nodeset;
    }

    public static XObject eval(Node contextNode, String str) throws TransformerException {
        return XPathAPI.eval(contextNode, str, contextNode);
    }

    public static XObject eval(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        XPathContext xpathSupport = new XPathContext();
        PrefixResolverDefault prefixResolver = new PrefixResolverDefault(namespaceNode.getNodeType() == 9 ? ((Document)namespaceNode).getDocumentElement() : namespaceNode);
        XPath xpath = XPath.createXPath(str, null, prefixResolver, 0, null);
        return xpath.execute(xpathSupport, contextNode, prefixResolver);
    }

    public static XObject eval(Node contextNode, String str, PrefixResolver prefixResolver) throws TransformerException {
        XPath xpath = XPath.createXPath(str, null, prefixResolver, 0, null);
        return xpath.execute(new XPathContext(), contextNode, prefixResolver);
    }
}

