/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath;

import com.scenari.xsldom.xalan.extensions.ExpressionContext;
import com.scenari.xsldom.xalan.extensions.ExtensionsTable;
import com.scenari.xsldom.xalan.res.XSLMessages;
import com.scenari.xsldom.xalan.stree.StreeDOMHelper;
import com.scenari.xsldom.xml.utils.DefaultErrorHandler;
import com.scenari.xsldom.xml.utils.NodeVector;
import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.QName;
import com.scenari.xsldom.xml.utils.SAXSourceLocator;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.SourceTreeManager;
import com.scenari.xsldom.xpath.VariableStack;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import com.scenari.xsldom.xpath.axes.SubContextList;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XObject;
import java.lang.reflect.Method;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.XMLReader;

public class XPathContext
implements ExpressionContext {
    SourceLocator m_saxLocation;
    private Object m_owner;
    private Method m_ownerGetErrorListener;
    private ExtensionsTable m_extensionsTable = new ExtensionsTable();
    private VariableStack m_variableStacks = new VariableStack();
    private DOMHelper m_domHelper = new StreeDOMHelper();
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private Stack m_contextNodeLists = new Stack();
    PrefixResolver m_currentPrefixResolver = null;
    private NodeVector m_currentNodes = new NodeVector();
    private NodeVector m_currentExpressionNodes = new NodeVector();
    private Stack m_axesIteratorStack = new Stack();

    public XPathContext() {
    }

    public XPathContext(Object owner) {
        this.m_owner = owner;
        try {
            this.m_ownerGetErrorListener = this.m_owner.getClass().getMethod("getErrorListener", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void reset() {
    }

    public void setSAXLocator(SourceLocator location) {
        this.m_saxLocation = location;
    }

    public SourceLocator getSAXLocator() {
        return this.m_saxLocation;
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    void setExtensionsTable(ExtensionsTable table) {
        this.m_extensionsTable = table;
    }

    public VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public void setVarStack(VariableStack varStack) {
        this.m_variableStacks = varStack;
    }

    public XObject getVariable(QName qname) throws TransformerException {
        return this.getVarStack().getVariable(this, qname);
    }

    public final DOMHelper getDOMHelper() {
        return this.m_domHelper;
    }

    public void setDOMHelper(DOMHelper helper) {
        this.m_domHelper = helper;
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public void setSourceTreeManager(SourceTreeManager mgr) {
        this.m_sourceTreeManager = mgr;
    }

    public final ErrorListener getErrorListener() {
        if (null != this.m_errorListener) {
            return this.m_errorListener;
        }
        ErrorListener retval = null;
        try {
            if (null != this.m_ownerGetErrorListener) {
                retval = (ErrorListener)this.m_ownerGetErrorListener.invoke(this.m_owner, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == retval) {
            if (null == this.m_defaultErrorListener) {
                this.m_defaultErrorListener = new DefaultErrorHandler();
            }
            retval = this.m_defaultErrorListener;
        }
        return retval;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Null error handler");
        }
        this.m_errorListener = listener;
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public void setPrimaryReader(XMLReader reader) {
        this.m_primaryReader = reader;
    }

    private void assertion(boolean b, String msg) throws TransformerException {
        ErrorListener errorHandler = this.getErrorListener();
        if (errorHandler != null) {
            errorHandler.fatalError(new TransformerException(XSLMessages.createMessage(30, new Object[]{msg}), (SAXSourceLocator)this.getSAXLocator()));
        }
    }

    public Stack getContextNodeListsStack() {
        return this.m_contextNodeLists;
    }

    public void setContextNodeListsStack(Stack s) {
        this.m_contextNodeLists = s;
    }

    public final ContextNodeList getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (ContextNodeList)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public final void pushContextNodeList(ContextNodeList nl) {
        this.m_contextNodeLists.push(nl);
    }

    public final void popContextNodeList() {
        this.m_contextNodeLists.pop();
    }

    public NodeVector getCurrentNodeStack() {
        return this.m_currentNodes;
    }

    public void setCurrentNodeStack(NodeVector nv) {
        this.m_currentNodes = nv;
    }

    public final Node getCurrentNode() {
        return this.m_currentNodes.peepOrNull();
    }

    public final void pushCurrentNodeAndExpression(Node cn, Node en) {
        this.m_currentNodes.push(cn);
        this.m_currentExpressionNodes.push(en);
    }

    public final void popCurrentNodeAndExpression() {
        this.m_currentNodes.popQuick();
        this.m_currentExpressionNodes.popQuick();
    }

    public final void pushCurrentNode(Node n) {
        this.m_currentNodes.push(n);
    }

    public final void popCurrentNode() {
        this.m_currentNodes.popQuick();
    }

    public NodeVector getCurrentExpressionNodeStack() {
        return this.m_currentExpressionNodes;
    }

    public void setCurrentExpressionNodeStack(NodeVector nv) {
        this.m_currentExpressionNodes = nv;
    }

    public final Node getCurrentExpressionNode() {
        return this.m_currentExpressionNodes.peepOrNull();
    }

    public final void pushCurrentExpressionNode(Node n) {
        this.m_currentExpressionNodes.push(n);
    }

    public final void popCurrentExpressionNode() {
        this.m_currentExpressionNodes.popQuick();
    }

    public final PrefixResolver getPrefixResolver() {
        return this.m_currentPrefixResolver;
    }

    public final void setPrefixResolver(PrefixResolver pr) {
        this.m_currentPrefixResolver = pr;
    }

    public Stack getAxesIteratorStackStacks() {
        return this.m_axesIteratorStack;
    }

    public void setAxesIteratorStackStacks(Stack s) {
        this.m_axesIteratorStack = s;
    }

    public final void pushSubContextList(SubContextList iter) {
        this.m_axesIteratorStack.push(iter);
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : (SubContextList)this.m_axesIteratorStack.peek();
    }

    public final Node getContextNode() {
        return this.getCurrentNode();
    }

    public final NodeIterator getContextNodes() {
        try {
            ContextNodeList cnl = this.getContextNodeList();
            if (null != cnl) {
                return cnl.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public final double toNumber(Node n) {
        return XNodeSet.getNumberFromNode(n);
    }

    public final String toString(Node n) {
        return XNodeSet.getStringFromNode(n);
    }
}

