/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xalan.stree.Child;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import com.scenari.xsldom.xpath.axes.PredicatedNodeTest;
import com.scenari.xsldom.xpath.compiler.Compiler;
import com.scenari.xsldom.xpath.patterns.NodeTestFilter;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AxesWalker
extends PredicatedNodeTest
implements Cloneable,
TreeWalker,
NodeFilter {
    static final boolean DEBUG = false;
    static final boolean DEBUG_WAITING = false;
    static final boolean DEBUG_TRAVERSAL = false;
    static final boolean DEBUG_LOCATED = false;
    static boolean m_didDumpAll = false;
    public static final String FEATURE_NODETESTFILTER = "NodeTestFilter";
    transient Node m_root;
    transient Node m_currentNode;
    transient Node m_prevReturned;
    private int m_argLen;
    private int m_stepType;
    private transient boolean m_didSwitch = false;
    transient boolean m_isDone = false;
    transient boolean m_isFresh;
    protected transient int m_nextLevelAmount;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;

    public AxesWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        this.m_stepType = stepType;
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_argLen = compiler.getArgLength(opPos);
                break;
            }
            default: {
                this.m_argLen = compiler.getArgLengthOfStep(opPos);
            }
        }
        this.initPredicateInfo(compiler, opPos);
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker clone = (AxesWalker)super.clone();
        return clone;
    }

    AxesWalker cloneDeep(LocPathIterator cloneOwner) throws CloneNotSupportedException {
        AxesWalker clone = (AxesWalker)this.clone();
        clone.setLocPathIterator(cloneOwner);
        if (this.m_lpi.m_lastUsedWalker == this) {
            cloneOwner.m_lastUsedWalker = clone;
        }
        if (null != this.m_nextWalker) {
            clone.m_nextWalker = this.m_nextWalker.cloneDeep(cloneOwner);
            clone.m_nextWalker.m_prevWalker = clone;
        }
        return clone;
    }

    protected int getStepType() {
        return this.m_stepType;
    }

    protected int getArgLen() {
        return this.m_argLen;
    }

    boolean isAncestorOfRootContext(Node n) {
        Node parent = this.m_root;
        while (null != (parent = parent.getParentNode())) {
            if (!parent.equals(n)) continue;
            return true;
        }
        return false;
    }

    public Node getRoot() {
        return this.m_root;
    }

    public void setRoot(Node root) {
        this.m_isFresh = true;
        this.m_isDone = false;
        this.m_root = root;
        this.m_currentNode = root;
        this.m_prevReturned = null;
        if (null == root) {
            throw new RuntimeException("\n !!!! Error! Setting the root of a walker to null!!!");
        }
        this.resetProximityPositions();
    }

    public final Node getCurrentNode() {
        return this.m_currentNode;
    }

    public void setCurrentNode(Node currentNode) throws DOMException {
        this.m_currentNode = currentNode;
    }

    protected Node setCurrentIfNotNull(Node currentNode) throws DOMException {
        if (null != currentNode) {
            this.m_currentNode = currentNode;
        }
        return currentNode;
    }

    public NodeFilter getFilter() {
        return this;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node parentNode() {
        return null;
    }

    public Node firstChild() {
        return null;
    }

    public Node nextSibling() {
        return null;
    }

    public Node lastChild() {
        throw new RuntimeException("lastChild not supported!");
    }

    public Node previousSibling() {
        throw new RuntimeException("previousSibling not supported!");
    }

    public Node previousNode() {
        throw new RuntimeException("previousNode not supported!");
    }

    public void setNextWalker(AxesWalker walker) {
        this.m_nextWalker = walker;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public void setPrevWalker(AxesWalker walker) {
        this.m_prevWalker = walker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    public String toString() {
        String currentNodeName;
        String rootName;
        Class<?> cl = this.getClass();
        String clName = cl.getName();
        StringTokenizer tokenizer = new StringTokenizer(clName, ".");
        while (tokenizer.hasMoreTokens()) {
            clName = tokenizer.nextToken();
        }
        try {
            rootName = null == this.m_root ? "null" : this.m_root.getNodeName() + "{" + ((Child)this.m_root).getUid() + "}";
            currentNodeName = null == this.m_root ? "null" : this.m_currentNode.getNodeName() + "{" + ((Child)this.m_currentNode).getUid() + "}";
        }
        catch (ClassCastException cce) {
            rootName = null == this.m_root ? "null" : this.m_root.getNodeName();
            currentNodeName = null == this.m_root ? "null" : this.m_currentNode.getNodeName();
        }
        return clName + "[" + rootName + "][" + currentNodeName + "]";
    }

    private Node returnNextNode(Node n) {
        return n;
    }

    private void printDebug(String s) {
    }

    private void dumpAll(Node node, int indent) {
        String value;
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.print(this.nodeToString(node));
        if (3 == node.getNodeType() && null != (value = node.getNodeValue())) {
            System.out.print("+= -->" + value.trim());
        }
        System.out.println("");
        NamedNodeMap map = node.getAttributes();
        if (null != map) {
            int n = map.getLength();
            for (int i = 0; i < n; ++i) {
                for (int k = 0; k < indent; ++k) {
                    System.out.print(" ");
                }
                System.out.print("attr -->");
                System.out.print(this.nodeToString(map.item(i)));
                String value2 = map.item(i).getNodeValue();
                if (null != value2) {
                    System.out.print("+= -->" + value2.trim());
                }
                System.out.println("");
            }
        }
        for (Node child = node.getFirstChild(); null != child; child = child.getNextSibling()) {
            this.dumpAll(child, indent + 1);
        }
    }

    private void printDebugAdd(String s) {
    }

    private void printEntryDebug() {
    }

    protected Node getNextNode() {
        Node p;
        Node current;
        if (this.m_isFresh) {
            this.m_isFresh = false;
        }
        if ((current = this.getCurrentNode()).isSupported(FEATURE_NODETESTFILTER, "1.0")) {
            ((NodeTestFilter)((Object)current)).setNodeTest(this);
        }
        Node next = this.firstChild();
        while (null == next && (null != (next = this.nextSibling()) || null != (p = this.parentNode()))) {
        }
        if (null == next) {
            this.m_isDone = true;
        }
        return next;
    }

    public Node nextNode() {
        Node nextNode = null;
        AxesWalker walker = this.m_lpi.getLastUsedWalker();
        while (null != walker) {
            nextNode = walker.getNextNode();
            if (null == nextNode) {
                walker = walker.m_prevWalker;
                continue;
            }
            if (walker.acceptNode(nextNode) != 1) continue;
            if (null == walker.m_nextWalker) {
                this.m_lpi.setLastUsedWalker(walker);
                break;
            }
            AxesWalker prev = walker;
            walker = walker.m_nextWalker;
            walker.setRoot(nextNode);
            walker.m_prevWalker = prev;
        }
        return nextNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPos(XPathContext xctxt) {
        AxesWalker walker;
        int pos = this.getProximityPosition();
        try {
            walker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return -1;
        }
        walker.setPredicateCount(walker.getPredicateCount() - 1);
        walker.setNextWalker(null);
        walker.setPrevWalker(null);
        LocPathIterator lpi = walker.getLocPathIterator();
        AxesWalker savedWalker = lpi.getLastUsedWalker();
        try {
            lpi.setLastUsedWalker(walker);
            while (null != walker.nextNode()) {
                ++pos;
            }
        }
        finally {
            lpi.setLastUsedWalker(savedWalker);
        }
        return pos;
    }

    protected boolean isFastWalker() {
        return false;
    }
}

