/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xpath.VariableStack;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import com.scenari.xsldom.xpath.compiler.Compiler;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class DescendantIterator
extends LocPathIterator {
    private transient Node m_startContext;
    private boolean m_orSelf;
    private boolean m_fromRoot;

    public DescendantIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
        int[] ops = compiler.getOpMap();
        int firstStepPos = Compiler.getFirstChildPos(opPos);
        int stepType = ops[firstStepPos];
        if (42 == stepType) {
            this.m_orSelf = true;
        }
        if (48 == stepType) {
            this.m_orSelf = true;
            firstStepPos += 8;
        } else if (50 == stepType) {
            this.m_fromRoot = true;
            this.m_orSelf = true;
            firstStepPos += 8;
        } else {
            this.m_orSelf = false;
        }
        int whatToShow = compiler.getWhatToShow(firstStepPos);
        if (0 == (whatToShow & 0x43) || whatToShow == -1) {
            this.initNodeTest(whatToShow);
        } else {
            this.initNodeTest(whatToShow, compiler.getStepNS(firstStepPos), compiler.getStepLocalName(firstStepPos));
        }
        this.initPredicateInfo(compiler, firstStepPos);
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        DescendantIterator clone = (DescendantIterator)super.cloneWithReset();
        clone.resetProximityPositions();
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node nextNode() throws DOMException {
        int savedStart;
        VariableStack vars;
        Node pos;
        boolean getSelf;
        if (null != this.m_cachedNodes && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node next = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return next;
        }
        if (this.m_foundLast) {
            return null;
        }
        if (null == this.m_lastFetched) {
            getSelf = this.m_orSelf;
            pos = getSelf && this.m_fromRoot ? (this.m_context.getNodeType() == 9 ? this.m_context : this.m_context.getOwnerDocument()) : this.m_context;
            this.m_startContext = pos;
            this.resetProximityPositions();
        } else {
            pos = this.m_lastFetched;
            getSelf = false;
        }
        if (-1 != this.m_varStackPos) {
            vars = this.m_execContext.getVarStack();
            savedStart = vars.getSearchStart();
            vars.setSearchStart(this.m_varStackPos);
        } else {
            vars = null;
            savedStart = 0;
        }
        try {
            Node node;
            Node top = this.m_startContext;
            Node next = null;
            while (null != pos) {
                if (getSelf) {
                    this.m_lastFetched = pos;
                    if (1 == this.acceptNode(pos)) {
                        next = pos;
                        break;
                    }
                } else {
                    getSelf = true;
                }
                Node nextNode = pos.getFirstChild();
                while (null == nextNode && !top.equals(pos)) {
                    nextNode = pos.getNextSibling();
                    if (null != nextNode || null != (pos = pos.getParentNode()) && !top.equals(pos)) continue;
                    nextNode = null;
                    break;
                }
                pos = nextNode;
            }
            this.m_lastFetched = next;
            if (null != next) {
                if (null != this.m_cachedNodes) {
                    this.m_cachedNodes.addElement(next);
                }
                ++this.m_next;
                node = next;
                return node;
            }
            this.m_foundLast = true;
            this.m_startContext = null;
            node = null;
            return node;
        }
        finally {
            if (-1 != this.m_varStackPos) {
                vars.setSearchStart(savedStart);
            }
        }
    }
}

