/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xml.utils.WrappedRuntimeException;
import com.scenari.xsldom.xpath.Expression;
import com.scenari.xsldom.xpath.VariableStack;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.AxesWalker;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import com.scenari.xsldom.xpath.axes.LocPathIterator;
import com.scenari.xsldom.xpath.compiler.Compiler;
import com.scenari.xsldom.xpath.objects.XObject;
import com.scenari.xsldom.xpath.patterns.NodeTestFilter;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient NodeIterator m_nodeSet;
    private transient Node m_peek = null;

    public FilterExprWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        super.init(compiler, opPos, stepType);
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(opPos);
                break;
            }
            default: {
                this.m_expr = compiler.compile(opPos + 2);
            }
        }
    }

    public void setRoot(Node root) {
        XPathContext xctxt = this.m_lpi.getXPathContext();
        PrefixResolver savedResolver = xctxt.getPrefixResolver();
        try {
            XObject obj;
            xctxt.pushCurrentNode(root);
            xctxt.setPrefixResolver(this.m_lpi.getPrefixResolver());
            if (this.m_lpi.getIsTopLevel()) {
                VariableStack vars = this.m_lpi.m_execContext.getVarStack();
                int savedStart = vars.getSearchStart();
                vars.setSearchStart(this.m_lpi.m_varStackPos);
                obj = this.m_expr.execute(this.m_lpi.getXPathContext());
                vars.setSearchStart(savedStart);
            } else {
                obj = this.m_expr.execute(this.m_lpi.getXPathContext());
            }
            this.m_nodeSet = null != obj ? obj.nodeset() : null;
            this.m_peek = null;
        }
        catch (TransformerException se) {
            throw new WrappedRuntimeException(se);
        }
        finally {
            xctxt.popCurrentNode();
            xctxt.setPrefixResolver(savedResolver);
        }
        super.setRoot(root);
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker clone = (FilterExprWalker)super.clone();
        if (null != this.m_nodeSet) {
            clone.m_nodeSet = (NodeIterator)((ContextNodeList)((Object)this.m_nodeSet)).clone();
        }
        return clone;
    }

    public short acceptNode(Node n) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public Node getNextNode() {
        Node next;
        if (null != this.m_peek) {
            next = this.m_peek;
            this.m_peek = null;
        } else if (null != this.m_nodeSet) {
            Node current = this.getCurrentNode();
            if (current instanceof NodeTestFilter) {
                ((NodeTestFilter)((Object)current)).setNodeTest(this);
            }
            next = this.m_nodeSet.nextNode();
        } else {
            next = null;
        }
        this.m_nextLevelAmount = null == next ? 0 : (next.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(next);
    }
}

