/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.xsldom.xpath.axes;

import com.scenari.xsldom.xml.utils.PrefixResolver;
import com.scenari.xsldom.xpath.DOMHelper;
import com.scenari.xsldom.xpath.NodeSet;
import com.scenari.xsldom.xpath.VariableStack;
import com.scenari.xsldom.xpath.XPathContext;
import com.scenari.xsldom.xpath.axes.AxesWalker;
import com.scenari.xsldom.xpath.axes.ContextNodeList;
import com.scenari.xsldom.xpath.axes.PredicatedNodeTest;
import com.scenari.xsldom.xpath.axes.WalkerFactory;
import com.scenari.xsldom.xpath.compiler.Compiler;
import com.scenari.xsldom.xpath.objects.XNodeSet;
import com.scenari.xsldom.xpath.objects.XObject;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
NodeIterator,
ContextNodeList,
NodeList,
Serializable {
    transient int m_varStackPos = -1;
    transient int m_varStackContext;
    private boolean m_isTopLevel = false;
    private transient int m_last = 0;
    public transient Node m_lastFetched;
    transient NodeSet m_cachedNodes;
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;
    protected transient boolean m_foundLast = false;
    protected transient DOMHelper m_dhelper;
    protected transient Node m_context;
    protected transient Node m_currentContextNode;
    protected PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;
    protected transient int m_next = 0;
    protected int m_analysis = 0;

    public LocPathIterator(PrefixResolver nscontext) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = nscontext;
    }

    public LocPathIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        this(compiler, opPos, analysis, true);
    }

    public LocPathIterator(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        this.m_analysis = analysis;
        this.setLocPathIterator(this);
        int firstStepPos = Compiler.getFirstChildPos(opPos);
        if (shouldLoadWalkers) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, firstStepPos, 0);
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        try {
            LocPathIterator clone = (LocPathIterator)this.clone();
            clone.initContext(xctxt);
            return new XNodeSet(clone);
        }
        catch (CloneNotSupportedException ncse) {
            throw new TransformerException(ncse);
        }
    }

    public void setIsTopLevel(boolean b) {
        this.m_isTopLevel = b;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public void initContext(XPathContext execContext) {
        this.m_context = execContext.getCurrentNode();
        this.m_currentContextNode = execContext.getCurrentExpressionNode();
        this.m_execContext = execContext;
        this.m_prefixResolver = execContext.getPrefixResolver();
        this.m_dhelper = execContext.getDOMHelper();
        if (this.m_isTopLevel) {
            VariableStack vars = execContext.getVarStack();
            this.m_varStackPos = vars.getSearchStartOrTop();
            this.m_varStackContext = vars.getContextPos();
        }
    }

    protected void setNextPosition(int next) {
        this.m_next = next;
    }

    public final int getCurrentPos() {
        return this.m_next;
    }

    void incrementNextPosition() {
        ++this.m_next;
    }

    public void setShouldCacheNodes(boolean b) {
        this.m_cachedNodes = b ? new NodeSet() : null;
    }

    public NodeSet getCachedNodes() {
        return this.m_cachedNodes;
    }

    public void setCurrentPos(int i) {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.setNextPosition(i);
        this.m_cachedNodes.setCurrentPos(i);
    }

    public int size() {
        if (null == this.m_cachedNodes) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }

    public Node item(int index) {
        this.resetToCachedList();
        return this.m_cachedNodes.item(index);
    }

    public int getLength() {
        this.resetToCachedList();
        return this.m_cachedNodes.getLength();
    }

    private void resetToCachedList() {
        int pos = this.getCurrentPos();
        if (null == this.m_cachedNodes || pos != 0) {
            this.setShouldCacheNodes(true);
        }
        this.runTo(-1);
        this.setCurrentPos(pos);
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public Node previousNode() throws DOMException {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public int getWhatToShow() {
        return -17;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public Node getRoot() {
        return this.m_context;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public void detach() {
        this.m_context = null;
        this.m_execContext = null;
        this.m_prefixResolver = null;
        this.m_dhelper = null;
        this.m_varStackPos = -1;
        this.m_varStackContext = 0;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator clone = (LocPathIterator)this.clone();
        clone.reset();
        return clone;
    }

    public Object clone() throws CloneNotSupportedException {
        LocPathIterator clone = (LocPathIterator)super.clone();
        if (null != this.m_firstWalker) {
            clone.m_firstWalker = this.m_firstWalker.cloneDeep(clone);
        }
        return clone;
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_lastFetched = null;
        this.m_next = 0;
        this.m_last = 0;
        if (null != this.m_firstWalker) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
        }
    }

    public Node nextNode() throws DOMException {
        if (null != this.m_cachedNodes && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node next = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return next;
        }
        if (-1 == this.m_varStackPos) {
            if (null == this.m_firstWalker.getRoot()) {
                this.setNextPosition(0);
                this.m_firstWalker.setRoot(this.m_context);
                this.m_lastUsedWalker = this.m_firstWalker;
            }
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack vars = this.m_execContext.getVarStack();
        int savedStart = vars.getSearchStart();
        vars.setSearchStart(this.m_varStackPos);
        if (null == this.m_firstWalker.getRoot()) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        Node n = this.returnNextNode(this.m_firstWalker.nextNode());
        vars.setSearchStart(savedStart);
        return n;
    }

    protected Node returnNextNode(Node nextNode) {
        if (null != nextNode) {
            if (null != this.m_cachedNodes) {
                this.m_cachedNodes.addElement(nextNode);
            }
            this.incrementNextPosition();
        }
        this.m_lastFetched = nextNode;
        if (null == nextNode) {
            this.m_foundLast = true;
        }
        return nextNode;
    }

    public Node getCurrentNode() {
        return this.m_lastFetched;
    }

    public void runTo(int index) {
        if (this.m_foundLast || index >= 0 && index <= this.getCurrentPos()) {
            return;
        }
        if (-1 == index) {
            while (null != this.nextNode()) {
            }
        } else {
            while (null != this.nextNode() && this.getCurrentPos() < index) {
            }
        }
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final void setLastUsedWalker(AxesWalker walker) {
        this.m_lastUsedWalker = walker;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    public final DOMHelper getDOMHelper() {
        return this.m_dhelper;
    }

    public final Node getContext() {
        return this.m_context;
    }

    public final Node getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public final void setCurrentContextNode(Node n) {
        this.m_currentContextNode = n;
    }

    public final PrefixResolver getPrefixResolver() {
        return this.m_prefixResolver;
    }

    public int getLast() {
        return this.m_last;
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public int getLastPos(XPathContext xctxt) {
        LocPathIterator clone;
        int pos = this.getProximityPosition();
        try {
            clone = (LocPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return -1;
        }
        clone.setPredicateCount(clone.getPredicateCount() - 1);
        while (null != clone.nextNode()) {
            ++pos;
        }
        return pos;
    }

    int getAnalysis() {
        return this.m_analysis;
    }

    void setAnalysis(int a) {
        this.m_analysis = a;
    }
}

